/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.controllers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.SerializedOption;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.heartbeat.HeartbeatSchema;
import org.apache.hyracks.util.MXHelper;
import org.apache.hyracks.util.PidHelper;

public final class NodeRegistration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String nodeId;
    private final NetworkAddress ncAddress;
    private final NetworkAddress dataAddress;
    private final NetworkAddress resultAddress;
    private final NetworkAddress messagingAddress;
    private final String osName;
    private final String arch;
    private final String osVersion;
    private final int nProcessors;
    private final String vmName;
    private final String vmVersion;
    private final String vmVendor;
    private final String classpath;
    private final String libraryPath;
    private final String bootClasspath;
    private final List<String> inputArguments;
    private final Map<String, String> systemProperties;
    private final HeartbeatSchema hbSchema;
    private final long pid;
    private final NodeCapacity capacity;
    private final HashMap<SerializedOption, Object> config;

    public NodeRegistration(NetworkAddress ncAddress, String nodeId, NCConfig ncConfig, NetworkAddress dataAddress, NetworkAddress resultAddress, HeartbeatSchema hbSchema, NetworkAddress messagingAddress, NodeCapacity capacity) {
        this.ncAddress = ncAddress;
        this.nodeId = nodeId;
        this.dataAddress = dataAddress;
        this.resultAddress = resultAddress;
        this.hbSchema = hbSchema;
        this.messagingAddress = messagingAddress;
        this.capacity = capacity;
        this.osName = MXHelper.osMXBean.getName();
        this.arch = MXHelper.osMXBean.getArch();
        this.osVersion = MXHelper.osMXBean.getVersion();
        this.nProcessors = MXHelper.osMXBean.getAvailableProcessors();
        this.vmName = MXHelper.runtimeMXBean.getVmName();
        this.vmVersion = MXHelper.runtimeMXBean.getVmVersion();
        this.vmVendor = MXHelper.runtimeMXBean.getVmVendor();
        this.classpath = MXHelper.runtimeMXBean.getClassPath();
        this.libraryPath = MXHelper.runtimeMXBean.getLibraryPath();
        this.bootClasspath = MXHelper.getBootClassPath();
        this.inputArguments = MXHelper.runtimeMXBean.getInputArguments();
        this.systemProperties = MXHelper.runtimeMXBean.getSystemProperties();
        this.pid = PidHelper.getPid();
        IApplicationConfig cfg = ncConfig.getConfigManager().getNodeEffectiveConfig(nodeId);
        this.config = new HashMap();
        for (IOption option : cfg.getOptions()) {
            this.config.put(option.toSerializable(), cfg.get(option));
        }
    }

    public NetworkAddress getNodeControllerAddress() {
        return this.ncAddress;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public NodeCapacity getCapacity() {
        return this.capacity;
    }

    public Map<SerializedOption, Object> getConfig() {
        return this.config;
    }

    public NetworkAddress getDataAddress() {
        return this.dataAddress;
    }

    public NetworkAddress getResultAddress() {
        return this.resultAddress;
    }

    public String getOSName() {
        return this.osName;
    }

    public String getArch() {
        return this.arch;
    }

    public String getOSVersion() {
        return this.osVersion;
    }

    public int getNProcessors() {
        return this.nProcessors;
    }

    public HeartbeatSchema getHeartbeatSchema() {
        return this.hbSchema;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public String getBootClasspath() {
        return this.bootClasspath;
    }

    public List<String> getInputArguments() {
        return this.inputArguments;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public NetworkAddress getMessagingAddress() {
        return this.messagingAddress;
    }

    public long getPid() {
        return this.pid;
    }
}

