/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.VirtualBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.VirtualPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalVirtualBufferCache
implements IVirtualBufferCache,
ILifeCycleComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ILSMMemoryComponent, AtomicInteger> memoryComponentUsageMap = Collections.synchronizedMap(new HashMap());
    private final Map<FileReference, AtomicInteger> fileRefUsageMap = Collections.synchronizedMap(new HashMap());
    private final Int2ObjectMap<AtomicInteger> fileIdUsageMap = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final int maxConcurrentFlushes;
    private final List<ILSMIndex> primaryIndexes = new ArrayList<ILSMIndex>();
    private final Set<ILSMIndex> flushingIndexes = Collections.synchronizedSet(new HashSet());
    private final Set<ILSMMemoryComponent> flushingComponents = Collections.synchronizedSet(new HashSet());
    private volatile int flushPtr;
    private final int filteredMemoryComponentMaxNumPages;
    private final int flushPageBudget;
    private final VirtualBufferCache vbc;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final FlushThread flushThread = new FlushThread();

    public GlobalVirtualBufferCache(ICacheMemoryAllocator allocator, StorageProperties storageProperties, int maxConcurrentFlushes) {
        this.vbc = new VirtualBufferCache(allocator, storageProperties.getBufferCachePageSize(), (int)(storageProperties.getMemoryComponentGlobalBudget() / (long)storageProperties.getMemoryComponentPageSize()));
        this.flushPageBudget = (int)((double)(storageProperties.getMemoryComponentGlobalBudget() / (long)storageProperties.getMemoryComponentPageSize()) * storageProperties.getMemoryComponentFlushThreshold());
        this.filteredMemoryComponentMaxNumPages = storageProperties.getFilteredMemoryComponentMaxNumPages();
        this.maxConcurrentFlushes = maxConcurrentFlushes;
    }

    public int getPageSize() {
        return this.vbc.getPageSize();
    }

    public int getPageSizeWithHeader() {
        return this.vbc.getPageSizeWithHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ILSMMemoryComponent memoryComponent) {
        ILSMIndex index = memoryComponent.getLsmIndex();
        if (index.isPrimaryIndex()) {
            GlobalVirtualBufferCache globalVirtualBufferCache = this;
            synchronized (globalVirtualBufferCache) {
                if (!this.primaryIndexes.contains(index)) {
                    this.primaryIndexes.add(index);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Registered {} index {} to the global VBC", (Object)(this.isMetadataIndex(index) ? "metadata" : "primary"), (Object)index.toString());
                    }
                }
                if (index.getNumOfFilterFields() > 0) {
                    AtomicInteger usage = new AtomicInteger();
                    this.memoryComponentUsageMap.put(memoryComponent, usage);
                    for (FileReference ref : memoryComponent.getComponentFileRefs().getFileReferences()) {
                        if (ref == null) continue;
                        this.fileRefUsageMap.put(ref, usage);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ILSMMemoryComponent memoryComponent) {
        ILSMIndex index = memoryComponent.getLsmIndex();
        if (index.isPrimaryIndex()) {
            GlobalVirtualBufferCache globalVirtualBufferCache = this;
            synchronized (globalVirtualBufferCache) {
                int pos = this.primaryIndexes.indexOf(index);
                if (pos >= 0) {
                    this.primaryIndexes.remove(index);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Unregistered {} index {} to the global VBC", (Object)(this.isMetadataIndex(index) ? "metadata" : "primary"), (Object)index.toString());
                    }
                    if (this.primaryIndexes.isEmpty()) {
                        this.flushPtr = 0;
                    } else if (this.flushPtr > pos) {
                        this.flushPtr = (this.flushPtr - 1) % this.primaryIndexes.size();
                    }
                }
                if (index.getNumOfFilterFields() > 0) {
                    this.memoryComponentUsageMap.remove(memoryComponent);
                    for (FileReference ref : memoryComponent.getComponentFileRefs().getFileReferences()) {
                        if (ref == null) continue;
                        this.fileRefUsageMap.remove(ref);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushed(ILSMMemoryComponent memoryComponent) throws HyracksDataException {
        AtomicInteger usage;
        this.flushingComponents.remove(memoryComponent);
        if (this.flushingIndexes.remove(memoryComponent.getLsmIndex())) {
            LOGGER.info("Completed flushing {}.", (Object)memoryComponent.getIndex());
            GlobalVirtualBufferCache globalVirtualBufferCache = this;
            synchronized (globalVirtualBufferCache) {
                int size = this.primaryIndexes.size();
                for (int i = 0; i < size; ++i) {
                    ILSMOperationTracker opTracker;
                    ILSMOperationTracker iLSMOperationTracker = opTracker = this.primaryIndexes.get(i).getOperationTracker();
                    synchronized (iLSMOperationTracker) {
                        opTracker.notifyAll();
                        continue;
                    }
                }
            }
            this.checkAndNotifyFlushThread();
        }
        if (memoryComponent.getLsmIndex().getNumOfFilterFields() > 0 && memoryComponent.getLsmIndex().isPrimaryIndex() && (usage = this.memoryComponentUsageMap.get(memoryComponent)) != null) {
            usage.set(0);
        }
    }

    public int getPageBudget() {
        return this.vbc.getPageBudget();
    }

    public boolean isFull() {
        boolean full = this.vbc.isFull();
        if (full) {
            this.checkAndNotifyFlushThread();
        }
        return full;
    }

    public boolean isFull(ILSMMemoryComponent memoryComponent) {
        return this.flushingComponents.contains(memoryComponent) || this.isFilteredMemoryComponentFull(memoryComponent);
    }

    private boolean isFilteredMemoryComponentFull(ILSMMemoryComponent memoryComponent) {
        if (this.filteredMemoryComponentMaxNumPages <= 0 || memoryComponent.getLsmIndex().getNumOfFilterFields() == 0 || !memoryComponent.getLsmIndex().isPrimaryIndex()) {
            return false;
        }
        AtomicInteger usage = this.memoryComponentUsageMap.get(memoryComponent);
        return usage.get() >= this.filteredMemoryComponentMaxNumPages;
    }

    public int createFile(FileReference fileRef) throws HyracksDataException {
        int fileId = this.vbc.createFile(fileRef);
        this.updateFileIdUsageMap(fileRef, fileId);
        return fileId;
    }

    public int openFile(FileReference fileRef) throws HyracksDataException {
        int fileId = this.vbc.openFile(fileRef);
        this.updateFileIdUsageMap(fileRef, fileId);
        return fileId;
    }

    private void updateFileIdUsageMap(FileReference fileRef, int fileId) {
        AtomicInteger usage = this.fileRefUsageMap.get(fileRef);
        if (usage != null) {
            this.fileIdUsageMap.put(fileId, (Object)usage);
        }
    }

    public void openFile(int fileId) throws HyracksDataException {
        this.vbc.openFile(fileId);
    }

    public void closeFile(int fileId) throws HyracksDataException {
        this.vbc.closeFile(fileId);
    }

    public void deleteFile(FileReference fileRef) throws HyracksDataException {
        this.vbc.deleteFile(fileRef);
    }

    public void deleteFile(int fileId) throws HyracksDataException {
        this.vbc.deleteFile(fileId);
    }

    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        ICachedPage page = this.vbc.pin(dpid, newPage);
        if (newPage) {
            this.incrementFilteredMemoryComponentUsage(dpid, 1);
            this.checkAndNotifyFlushThread();
        }
        return page;
    }

    private void incrementFilteredMemoryComponentUsage(long dpid, int pages) {
        AtomicInteger usage;
        if (this.filteredMemoryComponentMaxNumPages > 0 && (usage = (AtomicInteger)this.fileIdUsageMap.get(BufferedFileHandle.getFileId((long)dpid))) != null) {
            usage.addAndGet(pages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndNotifyFlushThread() {
        if (this.vbc.getUsage() < this.flushPageBudget) {
            return;
        }
        Object object = this.flushThread.flushLock;
        synchronized (object) {
            this.flushThread.flushLock.notifyAll();
        }
    }

    public void resizePage(ICachedPage cPage, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) throws HyracksDataException {
        this.vbc.resizePage(cPage, multiplier, extraPageBlockHelper);
        int delta = multiplier - cPage.getFrameSizeMultiplier();
        this.incrementFilteredMemoryComponentUsage(((VirtualPage)cPage).dpid(), delta);
        if (delta > 0) {
            this.checkAndNotifyFlushThread();
        }
    }

    public void unpin(ICachedPage page) throws HyracksDataException {
        this.vbc.unpin(page);
    }

    public void flush(ICachedPage page) throws HyracksDataException {
        this.vbc.flush(page);
    }

    public void force(int fileId, boolean metadata) throws HyracksDataException {
        this.vbc.force(fileId, metadata);
    }

    public void open() throws HyracksDataException {
    }

    public void close() throws HyracksDataException {
    }

    public void start() {
        if (this.isOpen.compareAndSet(false, true)) {
            try {
                this.vbc.open();
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException("Fail to open virtual buffer cache ", e);
            }
            this.flushThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean dumpState, OutputStream ouputStream) throws IOException {
        if (this.isOpen.compareAndSet(true, false)) {
            if (dumpState) {
                this.dumpState(ouputStream);
            }
            this.vbc.close();
            Object object = this.flushThread.flushLock;
            synchronized (object) {
                this.flushThread.flushLock.notifyAll();
            }
            try {
                this.flushThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    public void dumpState(OutputStream os) throws IOException {
        os.write(this.vbc.toString().getBytes());
    }

    public IFileMapManager getFileMapProvider() {
        return this.vbc.getFileMapProvider();
    }

    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        return this.vbc.getNumPagesOfFile(fileId);
    }

    public void returnPage(ICachedPage page) {
        this.vbc.returnPage(page);
    }

    public IFIFOPageWriter createFIFOWriter(IPageWriteCallback callback, IPageWriteFailureCallback failureCallback) {
        return this.vbc.createFIFOWriter(callback, failureCallback);
    }

    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        return this.vbc.confiscatePage(dpid);
    }

    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        return this.vbc.confiscateLargePage(dpid, multiplier, extraBlockPageId);
    }

    public void returnPage(ICachedPage page, boolean reinsert) {
        this.vbc.returnPage(page, reinsert);
    }

    public int getFileReferenceCount(int fileId) {
        return this.vbc.getFileReferenceCount(fileId);
    }

    public boolean isReplicationEnabled() {
        return this.vbc.isReplicationEnabled();
    }

    public IIOReplicationManager getIOReplicationManager() {
        return this.vbc.getIOReplicationManager();
    }

    public void purgeHandle(int fileId) throws HyracksDataException {
        this.vbc.purgeHandle(fileId);
    }

    public String toString() {
        return this.vbc.toString();
    }

    public void closeFileIfOpen(FileReference fileRef) {
        this.vbc.closeFileIfOpen(fileRef);
    }

    public int getUsage() {
        return this.vbc.getUsage();
    }

    private boolean isMetadataIndex(ILSMIndex index) {
        BaseOperationTracker opTracker = (BaseOperationTracker)index.getOperationTracker();
        return MetadataIndexImmutableProperties.isMetadataDataset(opTracker.getDatasetInfo().getDatasetID());
    }

    private class FlushThread
    extends Thread {
        private final Object flushLock = new Object();

        private FlushThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (GlobalVirtualBufferCache.this.isOpen.get()) {
                Object object = this.flushLock;
                synchronized (object) {
                    try {
                        this.flushLock.wait();
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Flushing thread is interrupted unexpectedly.", (Throwable)e);
                    }
                }
                if (!GlobalVirtualBufferCache.this.isOpen.get()) continue;
                try {
                    this.scheduleFlush();
                }
                catch (Throwable e) {
                    LOGGER.error("Unexpected exception when trying to schedule flushes.", e);
                    ExitUtil.halt((int)55);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleFlush() throws HyracksDataException {
            ILSMIndex selectedIndex = null;
            GlobalVirtualBufferCache globalVirtualBufferCache = GlobalVirtualBufferCache.this;
            synchronized (globalVirtualBufferCache) {
                while (GlobalVirtualBufferCache.this.flushingIndexes.size() < GlobalVirtualBufferCache.this.maxConcurrentFlushes && (selectedIndex = this.selectFlushIndex()) != null) {
                    LOGGER.debug("Waiting for flushing primary index {} to complete...", (Object)selectedIndex);
                    GlobalVirtualBufferCache.this.flushingIndexes.add(selectedIndex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ILSMIndex selectFlushIndex() throws HyracksDataException {
            int cycles = 0;
            while (GlobalVirtualBufferCache.this.vbc.getUsage() >= GlobalVirtualBufferCache.this.flushPageBudget && cycles <= GlobalVirtualBufferCache.this.primaryIndexes.size()) {
                PrimaryIndexOperationTracker opTracker;
                ILSMIndex primaryIndex = GlobalVirtualBufferCache.this.primaryIndexes.get(GlobalVirtualBufferCache.this.flushPtr);
                GlobalVirtualBufferCache.this.flushPtr = (GlobalVirtualBufferCache.this.flushPtr + 1) % GlobalVirtualBufferCache.this.primaryIndexes.size();
                ++cycles;
                if (primaryIndex.isCurrentMutableComponentEmpty() || GlobalVirtualBufferCache.this.flushingIndexes.contains(primaryIndex)) continue;
                PrimaryIndexOperationTracker primaryIndexOperationTracker = opTracker = (PrimaryIndexOperationTracker)primaryIndex.getOperationTracker();
                synchronized (primaryIndexOperationTracker) {
                    boolean flushable;
                    boolean bl = flushable = !primaryIndex.isCurrentMutableComponentEmpty();
                    if (flushable && !opTracker.isFlushLogCreated()) {
                        ILSMMemoryComponent memoryComponent = primaryIndex.getCurrentMemoryComponent();
                        if (memoryComponent.getState() == ILSMComponent.ComponentState.READABLE_WRITABLE) {
                            memoryComponent.setUnwritable();
                        }
                        opTracker.setFlushOnExit(true);
                        opTracker.flushIfNeeded();
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Requested flushing {} index {}", (Object)(GlobalVirtualBufferCache.this.isMetadataIndex(primaryIndex) ? "metadata" : "primary"), (Object)primaryIndex.toString());
                        }
                    }
                    if ((flushable || opTracker.isFlushLogCreated()) && !GlobalVirtualBufferCache.this.isMetadataIndex(primaryIndex)) {
                        GlobalVirtualBufferCache.this.flushingComponents.add(primaryIndex.getCurrentMemoryComponent());
                        return primaryIndex;
                    }
                }
            }
            return null;
        }
    }
}

