/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.delta;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingConfig;
import org.apache.parquet.io.ParquetEncodingException;

public class DeltaBinaryPackingValuesWriter
extends ValuesWriter {
    public static final int MAX_BITWIDTH = 32;
    public static final int DEFAULT_NUM_BLOCK_VALUES = 128;
    public static final int DEFAULT_NUM_MINIBLOCKS = 4;
    private final CapacityByteArrayOutputStream baos;
    private final DeltaBinaryPackingConfig config;
    private final int[] bitWidths;
    private int totalValueCount = 0;
    private int deltaValuesToFlush = 0;
    private int[] deltaBlockBuffer;
    private byte[] miniBlockByteBuffer;
    private int firstValue = 0;
    private int previousValue = 0;
    private int minDeltaInCurrentBlock = Integer.MAX_VALUE;

    public DeltaBinaryPackingValuesWriter(int slabSize, int pageSize) {
        this(128, 4, slabSize, pageSize);
    }

    public DeltaBinaryPackingValuesWriter(int blockSizeInValues, int miniBlockNum, int slabSize, int pageSize) {
        this.config = new DeltaBinaryPackingConfig(blockSizeInValues, miniBlockNum);
        this.bitWidths = new int[this.config.miniBlockNumInABlock];
        this.deltaBlockBuffer = new int[blockSizeInValues];
        this.miniBlockByteBuffer = new byte[this.config.miniBlockSizeInValues * 32];
        this.baos = new CapacityByteArrayOutputStream(slabSize, pageSize);
    }

    @Override
    public long getBufferedSize() {
        return this.baos.size();
    }

    @Override
    public void writeInteger(int v) {
        ++this.totalValueCount;
        if (this.totalValueCount == 1) {
            this.previousValue = this.firstValue = v;
            return;
        }
        int delta = v - this.previousValue;
        this.previousValue = v;
        this.deltaBlockBuffer[this.deltaValuesToFlush++] = delta;
        if (delta < this.minDeltaInCurrentBlock) {
            this.minDeltaInCurrentBlock = delta;
        }
        if (this.config.blockSizeInValues == this.deltaValuesToFlush) {
            this.flushBlockBuffer();
        }
    }

    private void flushBlockBuffer() {
        int i;
        for (int i2 = 0; i2 < this.deltaValuesToFlush; ++i2) {
            this.deltaBlockBuffer[i2] = this.deltaBlockBuffer[i2] - this.minDeltaInCurrentBlock;
        }
        this.writeMinDelta();
        int miniBlocksToFlush = this.getMiniBlockCountToFlush(this.deltaValuesToFlush);
        this.calculateBitWidthsForDeltaBlockBuffer(miniBlocksToFlush);
        for (i = 0; i < this.config.miniBlockNumInABlock; ++i) {
            this.writeBitWidthForMiniBlock(i);
        }
        for (i = 0; i < miniBlocksToFlush; ++i) {
            int miniBlockStart;
            int currentBitWidth = this.bitWidths[i];
            BytePacker packer = Packer.LITTLE_ENDIAN.newBytePacker(currentBitWidth);
            for (int j = miniBlockStart = i * this.config.miniBlockSizeInValues; j < (i + 1) * this.config.miniBlockSizeInValues; j += 8) {
                packer.pack8Values(this.deltaBlockBuffer, j, this.miniBlockByteBuffer, 0);
                this.baos.write(this.miniBlockByteBuffer, 0, currentBitWidth);
            }
        }
        this.minDeltaInCurrentBlock = Integer.MAX_VALUE;
        this.deltaValuesToFlush = 0;
    }

    private void writeBitWidthForMiniBlock(int i) {
        try {
            BytesUtils.writeIntLittleEndianOnOneByte((OutputStream)this.baos, (int)this.bitWidths[i]);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("can not write bitwith for miniblock", e);
        }
    }

    private void writeMinDelta() {
        try {
            BytesUtils.writeZigZagVarInt((int)this.minDeltaInCurrentBlock, (OutputStream)this.baos);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("can not write min delta for block", e);
        }
    }

    private void calculateBitWidthsForDeltaBlockBuffer(int miniBlocksToFlush) {
        for (int miniBlockIndex = 0; miniBlockIndex < miniBlocksToFlush; ++miniBlockIndex) {
            int mask = 0;
            int miniStart = miniBlockIndex * this.config.miniBlockSizeInValues;
            int miniEnd = Math.min((miniBlockIndex + 1) * this.config.miniBlockSizeInValues, this.deltaValuesToFlush);
            for (int i = miniStart; i < miniEnd; ++i) {
                mask |= this.deltaBlockBuffer[i];
            }
            this.bitWidths[miniBlockIndex] = 32 - Integer.numberOfLeadingZeros(mask);
        }
    }

    private int getMiniBlockCountToFlush(double numberCount) {
        return (int)Math.ceil(numberCount / (double)this.config.miniBlockSizeInValues);
    }

    @Override
    public BytesInput getBytes() {
        if (this.deltaValuesToFlush != 0) {
            this.flushBlockBuffer();
        }
        return BytesInput.concat((BytesInput[])new BytesInput[]{this.config.toBytesInput(), BytesInput.fromUnsignedVarInt((int)this.totalValueCount), BytesInput.fromZigZagVarInt((int)this.firstValue), BytesInput.from((CapacityByteArrayOutputStream)this.baos)});
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_BINARY_PACKED;
    }

    @Override
    public void reset() {
        this.totalValueCount = 0;
        this.baos.reset();
        this.deltaValuesToFlush = 0;
        this.minDeltaInCurrentBlock = Integer.MAX_VALUE;
    }

    @Override
    public long getAllocatedSize() {
        return this.baos.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s DeltaBinaryPacking %d bytes", prefix, this.getAllocatedSize());
    }
}

