/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingScheduler;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.input.stream.HDFSInputStream;
import org.apache.asterix.hivecompat.io.RCFileInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.context.ICCContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.hdfs.scheduler.Scheduler;

public class HDFSUtils {
    public static Scheduler initializeHDFSScheduler(ICCServiceContext serviceCtx) throws HyracksDataException {
        ICCContext ccContext = serviceCtx.getCCContext();
        Scheduler scheduler = null;
        try {
            scheduler = new Scheduler(ccContext.getClusterControllerInfo().getClientNetAddress(), ccContext.getClusterControllerInfo().getClientNetPort());
        }
        catch (HyracksException e) {
            throw new RuntimeDataException(3078, new Serializable[0]);
        }
        return scheduler;
    }

    public static IndexingScheduler initializeIndexingHDFSScheduler(ICCServiceContext serviceCtx) throws HyracksDataException {
        IndexingScheduler scheduler = null;
        try {
            ICcApplicationContext appCtx = (ICcApplicationContext)serviceCtx.getApplicationContext();
            IHyracksClientConnection hcc = appCtx.getHcc();
            scheduler = new IndexingScheduler(hcc.getNodeControllerInfos());
        }
        catch (HyracksException e) {
            throw new RuntimeDataException(3078, new Serializable[0]);
        }
        return scheduler;
    }

    public static InputSplit[] getSplits(JobConf conf, List<ExternalFile> files) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        ArrayList<FileSplit> fileSplits = new ArrayList<FileSplit>();
        ArrayList<ExternalFile> orderedExternalFiles = new ArrayList<ExternalFile>();
        for (ExternalFile file : files) {
            BlockLocation[] fileBlocks;
            FileStatus fileStatus;
            Path filePath = new Path(file.getFileName());
            try {
                fileStatus = fs.getFileStatus(filePath);
            }
            catch (FileNotFoundException e) {
                continue;
            }
            if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.ADD_OP && fileStatus.getModificationTime() == file.getLastModefiedTime().getTime()) {
                BlockLocation[] fileBlocks2;
                for (BlockLocation block : fileBlocks2 = fs.getFileBlockLocations(fileStatus, 0L, file.getSize())) {
                    if (block.getOffset() >= file.getSize()) continue;
                    fileSplits.add(new FileSplit(filePath, block.getOffset(), block.getLength() + block.getOffset() < file.getSize() ? block.getLength() : file.getSize() - block.getOffset(), block.getHosts()));
                    orderedExternalFiles.add(file);
                }
                continue;
            }
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.NO_OP || fileStatus.getModificationTime() != file.getLastModefiedTime().getTime()) continue;
            long oldSize = 0L;
            long newSize = file.getSize();
            for (int i = 0; i < files.size(); ++i) {
                if (files.get(i).getFileName() != file.getFileName() || files.get(i).getSize() == file.getSize()) continue;
                newSize = files.get(i).getSize();
                oldSize = file.getSize();
                break;
            }
            for (BlockLocation block : fileBlocks = fs.getFileBlockLocations(fileStatus, 0L, newSize)) {
                if (block.getOffset() + block.getLength() <= oldSize || block.getOffset() >= newSize) continue;
                long startCut = block.getOffset() > oldSize ? 0L : oldSize - block.getOffset();
                long endCut = block.getOffset() + block.getLength() < newSize ? 0L : block.getOffset() + block.getLength() - newSize;
                long splitLength = block.getLength() - startCut - endCut;
                fileSplits.add(new FileSplit(filePath, block.getOffset() + startCut, splitLength, block.getHosts()));
                orderedExternalFiles.add(file);
            }
        }
        fs.close();
        files.clear();
        files.addAll(orderedExternalFiles);
        return (InputSplit[])fileSplits.toArray(new FileSplit[fileSplits.size()]);
    }

    public static String getInputFormatClassName(Map<String, String> configuration) {
        String inputFormatParameter;
        switch (inputFormatParameter = configuration.get("input-format").trim()) {
            case "text-input-format": {
                return "org.apache.hadoop.mapred.TextInputFormat";
            }
            case "sequence-input-format": {
                return "org.apache.hadoop.mapred.SequenceFileInputFormat";
            }
            case "rc-input-format": {
                return "org.apache.asterix.hivecompat.io.RCFileInputFormat";
            }
        }
        return inputFormatParameter;
    }

    public static Class<?> getInputFormatClass(Map<String, String> configuration) throws ClassNotFoundException {
        String inputFormatParameter;
        switch (inputFormatParameter = configuration.get("input-format").trim()) {
            case "text-input-format": {
                return TextInputFormat.class;
            }
            case "sequence-input-format": {
                return SequenceFileInputFormat.class;
            }
            case "rc-input-format": {
                return RCFileInputFormat.class;
            }
        }
        return Class.forName(inputFormatParameter);
    }

    public static JobConf configureHDFSJobConf(Map<String, String> configuration) {
        JobConf conf = new JobConf();
        String localShortCircuitSocketPath = configuration.get("local-socket-path");
        String formatClassName = HDFSUtils.getInputFormatClassName(configuration);
        conf.set("fs.defaultFS", configuration.get("hdfs").trim());
        conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        conf.setClassLoader(HDFSInputStream.class.getClassLoader());
        conf.set("mapred.input.dir", configuration.get("path").trim());
        conf.set("mapred.input.format.class", formatClassName);
        if (localShortCircuitSocketPath != null) {
            conf.set("dfs.client.read.shortcircuit", "true");
            conf.set("dfs.domain.socket.path", localShortCircuitSocketPath.trim());
        }
        return conf;
    }

    public static AlgebricksAbsolutePartitionConstraint getPartitionConstraints(IApplicationContext appCtx, AlgebricksAbsolutePartitionConstraint clusterLocations) {
        if (clusterLocations == null) {
            IClusterStateManager clusterStateManager = ((ICcApplicationContext)appCtx).getClusterStateManager();
            ArrayList<String> locs = new ArrayList<String>();
            Map stores = appCtx.getMetadataProperties().getStores();
            for (String node : stores.keySet()) {
                int numIODevices = clusterStateManager.getIODevices(node).length;
                for (int k = 0; k < numIODevices; ++k) {
                    locs.add(node);
                }
            }
            String[] cluster = new String[locs.size()];
            cluster = locs.toArray(cluster);
            return new AlgebricksAbsolutePartitionConstraint(cluster);
        }
        return clusterLocations;
    }

    public static RecordId.RecordIdType getRecordIdType(Map<String, String> configuration) {
        String inputFormatParameter;
        switch (inputFormatParameter = configuration.get("input-format").trim()) {
            case "text-input-format": 
            case "sequence-input-format": {
                return RecordId.RecordIdType.OFFSET;
            }
            case "rc-input-format": {
                return RecordId.RecordIdType.RC;
            }
        }
        return null;
    }
}

