/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractDecorrelationRule;

public class MoveFreeVariableOperatorOutOfSubplanRule
extends AbstractDecorrelationRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplanOp = (SubplanOperator)op;
        ILogicalOperator inputOp = (ILogicalOperator)((Mutable)subplanOp.getInputs().get(0)).getValue();
        HashSet<LogicalVariable> liveVarsBeforeSubplan = new HashSet<LogicalVariable>();
        VariableUtilities.getLiveVariables((ILogicalOperator)inputOp, liveVarsBeforeSubplan);
        boolean changed = false;
        for (ILogicalPlan plan : subplanOp.getNestedPlans()) {
            for (Mutable rootRef : plan.getRoots()) {
                if (!this.descOrSelfIsScanOrJoin((ILogicalOperator)rootRef.getValue())) continue;
                Mutable currentOpRef = rootRef;
                ILogicalOperator currentOp = (ILogicalOperator)rootRef.getValue();
                while (currentOp.getInputs().size() == 1) {
                    Mutable childOpRef = (Mutable)currentOp.getInputs().get(0);
                    ILogicalOperator childOp = (ILogicalOperator)childOpRef.getValue();
                    if (this.movableOperator(currentOp.getOperatorTag()) && this.independentOperator(currentOp, liveVarsBeforeSubplan) && this.producedVariablesCanbePropagated(currentOp)) {
                        this.extractOperator((ILogicalOperator)subplanOp, inputOp, (Mutable<ILogicalOperator>)currentOpRef);
                        inputOp = currentOp;
                        changed = true;
                    } else {
                        currentOpRef = childOpRef;
                    }
                    currentOp = childOp;
                }
            }
        }
        return changed;
    }

    private boolean independentOperator(ILogicalOperator op, Set<LogicalVariable> liveVarsBeforeSubplan) throws AlgebricksException {
        HashSet usedVars = new HashSet();
        VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVars);
        return liveVarsBeforeSubplan.containsAll(usedVars);
    }

    private boolean producedVariablesCanbePropagated(ILogicalOperator operator) throws AlgebricksException {
        ILogicalOperator currentOperator = operator;
        while (!currentOperator.getInputs().isEmpty()) {
            LogicalOperatorTag operatorTag = currentOperator.getOperatorTag();
            if (operatorTag == LogicalOperatorTag.AGGREGATE || operatorTag == LogicalOperatorTag.RUNNINGAGGREGATE || operatorTag == LogicalOperatorTag.GROUP) {
                return false;
            }
            if (operatorTag == LogicalOperatorTag.PROJECT) {
                HashSet producedVars = new HashSet();
                VariableUtilities.getProducedVariables((ILogicalOperator)currentOperator, producedVars);
                ProjectOperator projectOperator = (ProjectOperator)currentOperator;
                if (!projectOperator.getVariables().containsAll(producedVars)) {
                    return false;
                }
            }
            currentOperator = (ILogicalOperator)((Mutable)currentOperator.getInputs().get(0)).getValue();
        }
        return true;
    }

    private void extractOperator(ILogicalOperator subplan, ILogicalOperator inputOp, Mutable<ILogicalOperator> currentOpRef) {
        ILogicalOperator currentOp = (ILogicalOperator)currentOpRef.getValue();
        currentOpRef.setValue(((Mutable)currentOp.getInputs().get(0)).getValue());
        ((Mutable)subplan.getInputs().get(0)).setValue((Object)currentOp);
        ((Mutable)currentOp.getInputs().get(0)).setValue((Object)inputOp);
    }

    protected boolean movableOperator(LogicalOperatorTag operatorTag) {
        return operatorTag == LogicalOperatorTag.ASSIGN || operatorTag == LogicalOperatorTag.SUBPLAN;
    }
}

