// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeApisixClusterConfigs implements ApisixClusterConfigInterface
type FakeApisixClusterConfigs struct {
	Fake *FakeApisixV2
}

var apisixclusterconfigsResource = v2.SchemeGroupVersion.WithResource("apisixclusterconfigs")

var apisixclusterconfigsKind = v2.SchemeGroupVersion.WithKind("ApisixClusterConfig")

// Get takes name of the apisixClusterConfig, and returns the corresponding apisixClusterConfig object, and an error if there is any.
func (c *FakeApisixClusterConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.ApisixClusterConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(apisixclusterconfigsResource, name), &v2.ApisixClusterConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixClusterConfig), err
}

// List takes label and field selectors, and returns the list of ApisixClusterConfigs that match those selectors.
func (c *FakeApisixClusterConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v2.ApisixClusterConfigList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(apisixclusterconfigsResource, apisixclusterconfigsKind, opts), &v2.ApisixClusterConfigList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2.ApisixClusterConfigList{ListMeta: obj.(*v2.ApisixClusterConfigList).ListMeta}
	for _, item := range obj.(*v2.ApisixClusterConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested apisixClusterConfigs.
func (c *FakeApisixClusterConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(apisixclusterconfigsResource, opts))
}

// Create takes the representation of a apisixClusterConfig and creates it.  Returns the server's representation of the apisixClusterConfig, and an error, if there is any.
func (c *FakeApisixClusterConfigs) Create(ctx context.Context, apisixClusterConfig *v2.ApisixClusterConfig, opts v1.CreateOptions) (result *v2.ApisixClusterConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(apisixclusterconfigsResource, apisixClusterConfig), &v2.ApisixClusterConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixClusterConfig), err
}

// Update takes the representation of a apisixClusterConfig and updates it. Returns the server's representation of the apisixClusterConfig, and an error, if there is any.
func (c *FakeApisixClusterConfigs) Update(ctx context.Context, apisixClusterConfig *v2.ApisixClusterConfig, opts v1.UpdateOptions) (result *v2.ApisixClusterConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(apisixclusterconfigsResource, apisixClusterConfig), &v2.ApisixClusterConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixClusterConfig), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeApisixClusterConfigs) UpdateStatus(ctx context.Context, apisixClusterConfig *v2.ApisixClusterConfig, opts v1.UpdateOptions) (*v2.ApisixClusterConfig, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(apisixclusterconfigsResource, "status", apisixClusterConfig), &v2.ApisixClusterConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixClusterConfig), err
}

// Delete takes name of the apisixClusterConfig and deletes it. Returns an error if one occurs.
func (c *FakeApisixClusterConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(apisixclusterconfigsResource, name, opts), &v2.ApisixClusterConfig{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeApisixClusterConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(apisixclusterconfigsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v2.ApisixClusterConfigList{})
	return err
}

// Patch applies the patch and returns the patched apisixClusterConfig.
func (c *FakeApisixClusterConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.ApisixClusterConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(apisixclusterconfigsResource, name, pt, data, subresources...), &v2.ApisixClusterConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2.ApisixClusterConfig), err
}
