﻿/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Deployment script for $(METRICSDBNAME)

Use this script in sqlcmd mode, with a series of environment variables like this:
set METRICSDBNAME=HadoopMetrics
set METRICSDBLOGNAME=HadoopMetrics_log

set METRICSDBPATH=C:\Program Files\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQL\DATA\HadoopMetrics.mdf
set METRICSDBLOGPATH=C:\Program Files\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQL\DATA\HadoopMetrics_log.ldf

set METRICSDBOWNER=hadoop

sqlcmd -S localhost\SQLEXPRESS -i C:\app\ambari-server-1.3.0-SNAPSHOT\resources\Hadoop-Metrics-SQLServer-CREATELOCAL.sql
*/

USE [master]
GO

IF db_id('$(METRICSDBNAME)') IS NOT NULL
BEGIN
    Print N'Dropping [dbo].[$(METRICSDBNAME)] database...'
    ALTER DATABASE [$(METRICSDBNAME)] SET  SINGLE_USER WITH ROLLBACK IMMEDIATE
    DROP DATABASE [$(METRICSDBNAME)]
END
GO

Print N'Creating [dbo].[$(METRICSDBNAME)] database at $(METRICSDBPATH)...'

/****** Object:  Database [$(METRICSDBNAME)]    Script Date: 9/11/2014 3:58:17 PM ******/
CREATE DATABASE [$(METRICSDBNAME)]
 CONTAINMENT = NONE
 ON  PRIMARY
 (NAME = N'$(METRICSDBNAME)', FILENAME = N'$(METRICSDBPATH)' , SIZE = 3264KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB)
 LOG ON
 (NAME = N'$(METRICSDBLOGNAME)', FILENAME = N'$(METRICSDBLOGPATH)' , SIZE = 832KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO

ALTER DATABASE [$(METRICSDBNAME)] SET COMPATIBILITY_LEVEL = 120
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
BEGIN
    EXEC [$(METRICSDBNAME)].[dbo].[sp_fulltext_database] @action = 'enable'
END
GO
ALTER DATABASE [$(METRICSDBNAME)] SET ANSI_NULL_DEFAULT OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET ANSI_NULLS OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET ANSI_PADDING OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET ANSI_WARNINGS OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET ARITHABORT OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET AUTO_CLOSE ON
GO
ALTER DATABASE [$(METRICSDBNAME)] SET AUTO_SHRINK OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET AUTO_UPDATE_STATISTICS ON
GO
ALTER DATABASE [$(METRICSDBNAME)] SET CURSOR_CLOSE_ON_COMMIT OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET CURSOR_DEFAULT  GLOBAL
GO
ALTER DATABASE [$(METRICSDBNAME)] SET CONCAT_NULL_YIELDS_NULL OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET NUMERIC_ROUNDABORT OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET QUOTED_IDENTIFIER OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET RECURSIVE_TRIGGERS OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET  ENABLE_BROKER
GO
ALTER DATABASE [$(METRICSDBNAME)] SET AUTO_UPDATE_STATISTICS_ASYNC OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET DATE_CORRELATION_OPTIMIZATION OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET TRUSTWORTHY OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET ALLOW_SNAPSHOT_ISOLATION OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET PARAMETERIZATION SIMPLE
GO
ALTER DATABASE [$(METRICSDBNAME)] SET READ_COMMITTED_SNAPSHOT OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET HONOR_BROKER_PRIORITY OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET RECOVERY SIMPLE
GO
ALTER DATABASE [$(METRICSDBNAME)] SET  MULTI_USER
GO
ALTER DATABASE [$(METRICSDBNAME)] SET PAGE_VERIFY CHECKSUM
GO
ALTER DATABASE [$(METRICSDBNAME)] SET DB_CHAINING OFF
GO
ALTER DATABASE [$(METRICSDBNAME)] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF )
GO
ALTER DATABASE [$(METRICSDBNAME)] SET TARGET_RECOVERY_TIME = 0 SECONDS
GO
ALTER DATABASE [$(METRICSDBNAME)] SET DELAYED_DURABILITY = DISABLED
GO
ALTER DATABASE [$(METRICSDBNAME)] SET  READ_WRITE
GO

USE [$(METRICSDBNAME)]
GO

IF NOT EXISTS (SELECT name FROM sys.filegroups WHERE is_default=1 AND name = N'PRIMARY') ALTER DATABASE METRICSDBNAME MODIFY FILEGROUP [PRIMARY] DEFAULT
GO

ALTER authorization on DATABASE::$(METRICSDBNAME) to [NT AUTHORITY\SYSTEM]
GO

if exists (select 1 from master.sys.syslogins where name='$(METRICSDBOWNER)')
BEGIN
    CREATE USER [$(METRICSDBOWNER)] FOR LOGIN [$(METRICSDBOWNER)]
    ALTER ROLE [db_owner] ADD MEMBER [$(METRICSDBOWNER)]
END
GO

Print N'[dbo].[$(METRICSDBNAME)] database created.'
