/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.trident;

import backtype.storm.Config;
import backtype.storm.ILocalDRPC;
import backtype.storm.LocalCluster;
import backtype.storm.LocalDRPC;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.List;
import java.util.Map;
import storm.trident.TridentState;
import storm.trident.TridentTopology;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.CombinerAggregator;
import storm.trident.operation.Filter;
import storm.trident.operation.Function;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.builtin.Count;
import storm.trident.operation.builtin.FilterNull;
import storm.trident.operation.builtin.MapGet;
import storm.trident.operation.builtin.Sum;
import storm.trident.spout.IBatchSpout;
import storm.trident.state.QueryFunction;
import storm.trident.state.StateFactory;
import storm.trident.testing.FixedBatchSpout;
import storm.trident.testing.MemoryMapState;
import storm.trident.tuple.TridentTuple;

public class TridentWordCount {
    public static StormTopology buildTopology(LocalDRPC drpc) {
        FixedBatchSpout spout = new FixedBatchSpout(new Fields(new String[]{"sentence"}), 3, new List[]{new Values(new Object[]{"the cow jumped over the moon"}), new Values(new Object[]{"the man went to the store and bought some candy"}), new Values(new Object[]{"four score and seven years ago"}), new Values(new Object[]{"how many apples can you eat"}), new Values(new Object[]{"to be or not to be the person"})});
        spout.setCycle(true);
        TridentTopology topology = new TridentTopology();
        TridentState wordCounts = topology.newStream("spout1", (IBatchSpout)spout).parallelismHint(16).each(new Fields(new String[]{"sentence"}), (Function)new Split(), new Fields(new String[]{"word"})).groupBy(new Fields(new String[]{"word"})).persistentAggregate((StateFactory)new MemoryMapState.Factory(), (CombinerAggregator)new Count(), new Fields(new String[]{"count"})).parallelismHint(16);
        topology.newDRPCStream("words", (ILocalDRPC)drpc).each(new Fields(new String[]{"args"}), (Function)new Split(), new Fields(new String[]{"word"})).groupBy(new Fields(new String[]{"word"})).stateQuery(wordCounts, new Fields(new String[]{"word"}), (QueryFunction)new MapGet(), new Fields(new String[]{"count"})).each(new Fields(new String[]{"count"}), (Filter)new FilterNull()).aggregate(new Fields(new String[]{"count"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"sum"}));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        Config conf = new Config();
        conf.setMaxSpoutPending(20);
        if (args.length == 0) {
            LocalDRPC drpc = new LocalDRPC();
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("wordCounter", (Map)conf, TridentWordCount.buildTopology(drpc));
            for (int i = 0; i < 100; ++i) {
                System.out.println("DRPC RESULT: " + drpc.execute("words", "cat the dog jumped"));
                Thread.sleep(1000L);
            }
        } else {
            conf.setNumWorkers(3);
            StormSubmitter.submitTopology((String)args[0], (Map)conf, (StormTopology)TridentWordCount.buildTopology(null));
        }
    }

    public static class Split
    extends BaseFunction {
        public void execute(TridentTuple tuple, TridentCollector collector) {
            String sentence = tuple.getString(0);
            for (String word : sentence.split(" ")) {
                collector.emit((List)new Values(new Object[]{word}));
            }
        }
    }
}

