/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.tools;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class SlotBasedCounter<T>
implements Serializable {
    private static final long serialVersionUID = 4858185737378394432L;
    private final Map<T, long[]> objToCounts = new HashMap<T, long[]>();
    private final int numSlots;

    public SlotBasedCounter(int numSlots) {
        if (numSlots <= 0) {
            throw new IllegalArgumentException("Number of slots must be greater than zero (you requested " + numSlots + ")");
        }
        this.numSlots = numSlots;
    }

    public void incrementCount(T obj, int slot) {
        long[] counts = this.objToCounts.get(obj);
        if (counts == null) {
            counts = new long[this.numSlots];
            this.objToCounts.put(obj, counts);
        }
        int n = slot;
        counts[n] = counts[n] + 1L;
    }

    public long getCount(T obj, int slot) {
        long[] counts = this.objToCounts.get(obj);
        if (counts == null) {
            return 0L;
        }
        return counts[slot];
    }

    public Map<T, Long> getCounts() {
        HashMap<T, Long> result = new HashMap<T, Long>();
        for (T obj : this.objToCounts.keySet()) {
            result.put(obj, this.computeTotalCount(obj));
        }
        return result;
    }

    private long computeTotalCount(T obj) {
        long[] curr = this.objToCounts.get(obj);
        long total = 0L;
        for (long l : curr) {
            total += l;
        }
        return total;
    }

    public void wipeSlot(int slot) {
        for (T obj : this.objToCounts.keySet()) {
            this.resetSlotCountToZero(obj, slot);
        }
    }

    private void resetSlotCountToZero(T obj, int slot) {
        long[] counts = this.objToCounts.get(obj);
        counts[slot] = 0L;
    }

    private boolean shouldBeRemovedFromCounter(T obj) {
        return this.computeTotalCount(obj) == 0L;
    }

    public void wipeZeros() {
        HashSet<T> objToBeRemoved = new HashSet<T>();
        for (Object obj : this.objToCounts.keySet()) {
            if (!this.shouldBeRemovedFromCounter(obj)) continue;
            objToBeRemoved.add(obj);
        }
        for (Object obj : objToBeRemoved) {
            this.objToCounts.remove(obj);
        }
    }
}

