/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

public class JspHelper {
    public static final String CURRENT_CONF = "current.conf";
    public static final String WEB_UGI_PROPERTY_NAME = "dfs.web.ugi";
    public static final String DELEGATION_PARAMETER_NAME = "delegation";
    static final String SET_DELEGATION = "&delegation=";
    private static final Log LOG = LogFactory.getLog(JspHelper.class);
    static FSNamesystem fsn = null;
    public static InetSocketAddress nameNodeAddr;
    static Random rand;

    public JspHelper() {
        fsn = FSNamesystem.getFSNamesystem();
        nameNodeAddr = DataNode.getDataNode() != null ? DataNode.getDataNode().getNameNodeAddr() : fsn.getDFSNameNodeAddress();
    }

    public DatanodeID randomNode() throws IOException {
        return fsn.getRandomDatanode();
    }

    public static DatanodeInfo bestNode(LocatedBlock blk) throws IOException {
        TreeSet<DatanodeInfo> deadNodes = new TreeSet<DatanodeInfo>();
        DatanodeInfo chosenNode = null;
        int failures = 0;
        Socket s = null;
        DatanodeInfo[] nodes = blk.getLocations();
        if (nodes == null || nodes.length == 0) {
            throw new IOException("No nodes contain this block");
        }
        while (s == null) {
            if (chosenNode == null) {
                while (deadNodes.contains(chosenNode = nodes[rand.nextInt(nodes.length)])) {
                }
            }
            int index = rand.nextInt(nodes.length);
            chosenNode = nodes[index];
            InetSocketAddress targetAddr = NetUtils.createSocketAddr(chosenNode.getHost() + ":" + chosenNode.getInfoPort());
            try {
                s = new Socket();
                s.connect(targetAddr, 60000);
                s.setSoTimeout(60000);
            }
            catch (IOException e) {
                deadNodes.add(chosenNode);
                s.close();
                s = null;
                ++failures;
            }
            if (failures != nodes.length) continue;
            throw new IOException("Could not reach the block containing the data. Please try again");
        }
        s.close();
        return chosenNode;
    }

    public void streamBlockInAscii(InetSocketAddress addr, long blockId, Token<BlockTokenIdentifier> accessToken, long genStamp, long blockSize, long offsetIntoBlock, long chunkSizeToView, JspWriter out, Configuration conf) throws IOException {
        if (chunkSizeToView == 0L) {
            return;
        }
        Socket s = new Socket();
        s.connect(addr, 60000);
        s.setSoTimeout(60000);
        long amtToRead = Math.min(chunkSizeToView, blockSize - offsetIntoBlock);
        BlockReader blockReader = DFSClient.RemoteBlockReader.newBlockReader(s, addr.toString() + ":" + blockId, blockId, accessToken, genStamp, offsetIntoBlock, amtToRead, conf.getInt("io.file.buffer.size", 4096));
        byte[] buf = new byte[(int)amtToRead];
        int readOffset = 0;
        int retries = 2;
        while (amtToRead > 0L) {
            int numRead;
            try {
                numRead = blockReader.readAll(buf, readOffset, (int)amtToRead);
            }
            catch (IOException e) {
                if (--retries != 0) continue;
                throw new IOException("Could not read data from datanode");
            }
            amtToRead -= (long)numRead;
            readOffset += numRead;
        }
        blockReader = null;
        s.close();
        out.print(HtmlQuoting.quoteHtmlChars(new String(buf)));
    }

    public void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        if (fsn != null) {
            fsn.DFSNodesStatus(live, dead);
            fsn.removeDecomNodeFromDeadList(dead);
        }
    }

    public void addTableHeader(JspWriter out) throws IOException {
        out.print("<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\">");
        out.print("<tbody>");
    }

    public void addTableRow(JspWriter out, String[] columns) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            out.print("<td style=\"vertical-align: top;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public void addTableRow(JspWriter out, String[] columns, int row) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            if (row / 2 * 2 == row) {
                out.print("<td style=\"vertical-align: top;background-color:LightGrey;\"><B>" + columns[i] + "</B><br></td>");
                continue;
            }
            out.print("<td style=\"vertical-align: top;background-color:LightBlue;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public void addTableFooter(JspWriter out) throws IOException {
        out.print("</tbody></table>");
    }

    public String getSafeModeText() {
        if (!fsn.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. <em>" + fsn.getSafeModeTip() + "</em><br>";
    }

    public static String getWarningText(FSNamesystem fsn) {
        long missingBlocks = fsn.getMissingBlocksCount();
        if (missingBlocks > 0L) {
            return "<br> WARNING : There are about " + missingBlocks + " missing blocks. Please check the log or run fsck. <br><br>";
        }
        return "";
    }

    public String getInodeLimitText() {
        long inodes = JspHelper.fsn.dir.totalInodes();
        long blocks = fsn.getBlocksTotal();
        long maxobjects = fsn.getMaxObjects();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long used = totalMemory * 100L / maxMemory;
        String str = inodes + " files and directories, " + blocks + " blocks = " + (inodes + blocks) + " total";
        if (maxobjects != 0L) {
            long pct = (inodes + blocks) * 100L / maxobjects;
            str = str + " / " + maxobjects + " (" + pct + "%)";
        }
        str = str + ".  Heap Size is " + StringUtils.byteDesc(totalMemory) + " / " + StringUtils.byteDesc(maxMemory) + " (" + used + "%) <br>";
        return str;
    }

    public String getUpgradeStatusText() {
        String statusText = "";
        try {
            UpgradeStatusReport status = fsn.distributedUpgradeProgress(FSConstants.UpgradeAction.GET_STATUS);
            statusText = status == null ? "There are no upgrades in progress." : status.getStatusText(false);
        }
        catch (IOException e) {
            statusText = "Upgrade status unknown.";
        }
        return statusText;
    }

    public void sortNodeList(ArrayList<DatanodeDescriptor> nodes, String field, String order) {
        class NodeComapare
        implements Comparator<DatanodeDescriptor> {
            static final int FIELD_NAME = 1;
            static final int FIELD_LAST_CONTACT = 2;
            static final int FIELD_BLOCKS = 3;
            static final int FIELD_CAPACITY = 4;
            static final int FIELD_USED = 5;
            static final int FIELD_PERCENT_USED = 6;
            static final int FIELD_NONDFS_USED = 7;
            static final int FIELD_REMAINING = 8;
            static final int FIELD_PERCENT_REMAINING = 9;
            static final int SORT_ORDER_ASC = 1;
            static final int SORT_ORDER_DSC = 2;
            int sortField = 1;
            int sortOrder = 1;

            public NodeComapare(String field, String order) {
                this.sortField = field.equals("lastcontact") ? 2 : (field.equals("capacity") ? 4 : (field.equals("used") ? 5 : (field.equals("nondfsused") ? 7 : (field.equals("remaining") ? 8 : (field.equals("pcused") ? 6 : (field.equals("pcremaining") ? 9 : (field.equals("blocks") ? 3 : 1)))))));
                this.sortOrder = order.equals("DSC") ? 2 : 1;
            }

            @Override
            public int compare(DatanodeDescriptor d1, DatanodeDescriptor d2) {
                int ret = 0;
                switch (this.sortField) {
                    case 2: {
                        ret = (int)(d2.getLastUpdate() - d1.getLastUpdate());
                        break;
                    }
                    case 4: {
                        long dlong = d1.getCapacity() - d2.getCapacity();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 5: {
                        long dlong = d1.getDfsUsed() - d2.getDfsUsed();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 7: {
                        long dlong = d1.getNonDfsUsed() - d2.getNonDfsUsed();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 8: {
                        long dlong = d1.getRemaining() - d2.getRemaining();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 6: {
                        double ddbl = d1.getDfsUsedPercent() - d2.getDfsUsedPercent();
                        ret = ddbl < 0.0 ? -1 : (ddbl > 0.0 ? 1 : 0);
                        break;
                    }
                    case 9: {
                        double ddbl = d1.getRemainingPercent() - d2.getRemainingPercent();
                        ret = ddbl < 0.0 ? -1 : (ddbl > 0.0 ? 1 : 0);
                        break;
                    }
                    case 3: {
                        ret = d1.numBlocks() - d2.numBlocks();
                        break;
                    }
                    case 1: {
                        ret = d1.getHostName().compareTo(d2.getHostName());
                    }
                }
                return this.sortOrder == 2 ? -ret : ret;
            }
        }
        Collections.sort(nodes, new NodeComapare(field, order));
    }

    public static void printPathWithLinks(String dir, JspWriter out, int namenodeInfoPort, String tokenString) throws IOException {
        try {
            String[] parts = dir.split("/");
            StringBuilder tempPath = new StringBuilder(dir.length());
            out.print("<a href=\"browseDirectory.jsp?dir=/&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + "\">" + "/" + "</a>");
            tempPath.append("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                if (parts[i].equals("")) continue;
                tempPath.append(parts[i]);
                out.print("<a href=\"browseDirectory.jsp?dir=" + tempPath.toString() + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString));
                out.print("\">" + parts[i] + "</a>" + "/");
                tempPath.append("/");
            }
            if (parts.length > 0) {
                out.print(parts[parts.length - 1]);
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    public static void printGotoForm(JspWriter out, int namenodeInfoPort, String tokenString, String file) throws IOException {
        out.print("<form action=\"browseDirectory.jsp\" method=\"get\" name=\"goto\">");
        out.print("Goto : ");
        out.print("<input name=\"dir\" type=\"text\" width=\"50\" id\"dir\" value=\"" + file + "\">");
        out.print("<input name=\"go\" type=\"submit\" value=\"go\">");
        out.print("<input name=\"namenodeInfoPort\" type=\"hidden\" value=\"" + namenodeInfoPort + "\">");
        if (UserGroupInformation.isSecurityEnabled()) {
            out.print("<input name=\"delegation\" type=\"hidden\" value=\"" + tokenString + "\">");
        }
        out.print("</form>");
    }

    public static void createTitle(JspWriter out, HttpServletRequest req, String file) throws IOException {
        int start;
        if (file == null) {
            file = "";
        }
        if ((start = Math.max(0, file.length() - 100)) != 0) {
            file = "..." + file.substring(start, file.length());
        }
        out.print("<title>HDFS:" + file + "</title>");
    }

    public static UserGroupInformation getDefaultWebUser(Configuration conf) throws IOException {
        String[] strings = conf.getStrings(WEB_UGI_PROPERTY_NAME);
        if (strings == null || strings.length == 0) {
            throw new IOException("Cannot determine UGI from request or conf");
        }
        return UserGroupInformation.createRemoteUser(strings[0]);
    }

    public static UserGroupInformation getUGI(HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(null, request, conf);
    }

    public static UserGroupInformation getUGI(ServletContext context, HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(context, request, conf, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, true);
    }

    public static UserGroupInformation getUGI(ServletContext context, HttpServletRequest request, Configuration conf, UserGroupInformation.AuthenticationMethod secureAuthMethod, boolean tryUgiParameter) throws IOException {
        UserGroupInformation ugi;
        String usernameFromQuery = JspHelper.getUsernameFromQuery(request, tryUgiParameter);
        String doAsUserFromQuery = request.getParameter("doas");
        if (UserGroupInformation.isSecurityEnabled()) {
            String remoteUser = request.getRemoteUser();
            String tokenString = request.getParameter(DELEGATION_PARAMETER_NAME);
            if (tokenString != null) {
                NameNode nn;
                Token token = new Token();
                token.decodeFromUrlString(tokenString);
                SecurityUtil.setTokenService(token, NameNode.getAddress(conf));
                token.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
                ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
                DataInputStream in = new DataInputStream(buf);
                DelegationTokenIdentifier id = new DelegationTokenIdentifier();
                id.readFields(in);
                if (context != null && (nn = (NameNode)context.getAttribute("name.node")) != null) {
                    nn.getNamesystem().getDelegationTokenSecretManager().verifyToken(id, token.getPassword());
                }
                if ((ugi = id.getUser()).getRealUser() == null) {
                    JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
                    JspHelper.checkUsername(null, doAsUserFromQuery);
                } else {
                    JspHelper.checkUsername(ugi.getRealUser().getShortUserName(), usernameFromQuery);
                    JspHelper.checkUsername(ugi.getShortUserName(), doAsUserFromQuery);
                    ProxyUsers.authorize(ugi, request.getRemoteAddr(), conf);
                }
                ugi.addToken(token);
            } else {
                if (remoteUser == null) {
                    throw new IOException("Security enabled but user not authenticated by filter");
                }
                UserGroupInformation realUgi = UserGroupInformation.createRemoteUser(remoteUser);
                JspHelper.checkUsername(realUgi.getShortUserName(), usernameFromQuery);
                realUgi.setAuthenticationMethod(secureAuthMethod);
                ugi = JspHelper.initUGI(realUgi, doAsUserFromQuery, request, true, conf);
            }
        } else {
            UserGroupInformation realUgi = usernameFromQuery == null ? JspHelper.getDefaultWebUser(conf) : UserGroupInformation.createRemoteUser(usernameFromQuery);
            realUgi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE);
            ugi = JspHelper.initUGI(realUgi, doAsUserFromQuery, request, false, conf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getUGI is returning: " + ugi.getShortUserName());
        }
        return ugi;
    }

    private static UserGroupInformation initUGI(UserGroupInformation realUgi, String doAsUserFromQuery, HttpServletRequest request, boolean isSecurityEnabled, Configuration conf) throws AuthorizationException {
        UserGroupInformation ugi;
        if (doAsUserFromQuery == null) {
            ugi = realUgi;
        } else {
            ugi = UserGroupInformation.createProxyUser(doAsUserFromQuery, realUgi);
            ugi.setAuthenticationMethod(isSecurityEnabled ? UserGroupInformation.AuthenticationMethod.PROXY : UserGroupInformation.AuthenticationMethod.SIMPLE);
            ProxyUsers.authorize(ugi, request.getRemoteAddr(), conf);
        }
        return ugi;
    }

    private static void checkUsername(String expected, String name) throws IOException {
        if (expected == null && name != null) {
            throw new IOException("Usernames not matched: expecting null but name=" + name);
        }
        if (name == null) {
            return;
        }
        KerberosName u = new KerberosName(name);
        String shortName = u.getShortName();
        if (!shortName.equals(expected)) {
            throw new IOException("Usernames not matched: name=" + shortName + " != expected=" + expected);
        }
    }

    private static String getUsernameFromQuery(HttpServletRequest request, boolean tryUgiParameter) {
        String ugiStr;
        String username = request.getParameter("user.name");
        if (username == null && tryUgiParameter && (ugiStr = request.getParameter("ugi")) != null) {
            username = ugiStr.split(",")[0];
        }
        return username;
    }

    public static DFSClient getDFSClient(UserGroupInformation user, final InetSocketAddress addr, final Configuration conf) throws IOException, InterruptedException {
        return user.doAs(new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws IOException {
                return new DFSClient(addr, conf);
            }
        });
    }

    public static String getDelegationTokenUrlParam(String tokenString) {
        if (tokenString == null) {
            return "";
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            return SET_DELEGATION + tokenString;
        }
        return "";
    }

    public static int string2ChunkSizeToView(String s, int defaultValue) {
        int n = s == null ? 0 : Integer.parseInt(s);
        return n > 0 ? n : defaultValue;
    }

    public static int getDefaultChunkSize(Configuration conf) {
        return conf.getInt("dfs.default.chunk.view.size", 32768);
    }

    static String getVersionTable(FSNamesystem fsn) {
        return "<div class='dfstable'><table>\n  <tr><td class='col1'>Started:</td><td>" + fsn.getStartTime() + "</td></tr>\n" + "\n  <tr><td class='col1'>Version:</td><td>" + VersionInfo.getVersion() + ", " + VersionInfo.getRevision() + "</td></tr>\n" + "\n  <tr><td class='col1'>Compiled:</td><td>" + VersionInfo.getDate() + " by " + VersionInfo.getUser() + "</td></tr>\n</table></div>";
    }

    public static String getVersionTable() {
        return "<div id='dfstable'><table>\n  <tr><td id='col1'>Version:</td><td>" + VersionInfo.getVersion() + ", " + VersionInfo.getRevision() + "\n  <tr><td id='col1'>Compiled:</td><td>" + VersionInfo.getDate() + " by " + VersionInfo.getUser() + "\n</table></div>";
    }

    static {
        rand = new Random();
    }
}

