/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http.lib;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;

public class StaticUserWebFilter
extends FilterInitializer {
    private static final String WEB_USERNAME = "Dr.Who";
    private static final Principal WEB_USER = new User("Dr.Who");

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        container.addFilter("static_user_filter", StaticUserFilter.class.getName(), new HashMap<String, String>());
    }

    public static class StaticUserFilter
    implements Filter {
        @Override
        public void destroy() {
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getRemoteUser() != null) {
                chain.doFilter(request, response);
            } else {
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(httpRequest){

                    @Override
                    public Principal getUserPrincipal() {
                        return WEB_USER;
                    }

                    @Override
                    public String getRemoteUser() {
                        return StaticUserWebFilter.WEB_USERNAME;
                    }
                };
                chain.doFilter(wrapper, response);
            }
        }

        @Override
        public void init(FilterConfig conf) throws ServletException {
        }
    }

    static class User
    implements Principal {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            return ((User)other).name.equals(this.name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

