/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.utils.XylemError;
import java.util.LinkedList;
import java.util.Set;

public final class LetChainManager {
    static final Logger s_logger = Logger.getInstance(LetChainManager.class);
    protected Instruction m_baseInstruction;
    protected Instruction m_targetInstruction;
    protected LetInstruction m_outerLet;
    protected LetInstruction m_innerLet;
    protected Type m_baseType;
    protected LiteralInstruction m_baseNull;
    protected LetChainManager m_parent;
    protected Function m_currentFunction;
    protected Instruction m_parentInstruction;
    protected int m_parentIndex;

    public LetChainManager(Instruction instruction, Function function) {
        this(instruction, null, function, null, -1);
    }

    public LetChainManager(Instruction instruction, LetChainManager letChainManager, Function function, Instruction instruction2, int n) {
        this.m_baseInstruction = instruction;
        try {
            this.m_baseType = instruction.getType(function.getTypeEnvironment(), function.getBindingEnvironment()).resolveType(function.getTypeEnvironment());
        }
        catch (Exception exception) {
            throw new XylemError("ERR_SYSTEM", "error getting type for " + instruction + ": " + exception);
        }
        this.m_baseNull = new LiteralInstruction(this.m_baseType, null);
        this.m_parent = letChainManager;
        this.m_currentFunction = function;
        this.m_parentInstruction = instruction2;
        this.m_parentIndex = n;
        this.m_targetInstruction = instruction;
        LetInstruction letInstruction = null;
        while (this.m_targetInstruction instanceof LetInstruction) {
            LetInstruction letInstruction2 = (LetInstruction)this.m_targetInstruction;
            if (letInstruction != null) {
                letInstruction2.m_parent = letInstruction;
            }
            letInstruction2.m_lcm = this;
            this.m_innerLet = letInstruction2;
            if (this.m_outerLet == null) {
                this.m_outerLet = this.m_innerLet;
            }
            this.m_targetInstruction = this.m_innerLet.getBody();
            letInstruction = this.m_innerLet;
        }
    }

    protected void addAndTypeCheckLet(LetInstruction letInstruction, LetInstruction letInstruction2, Set set) throws TypeCheckException {
        if (letInstruction2 != null && letInstruction2.m_lcm != this) {
            letInstruction2.m_lcm.addAndTypeCheckLet(letInstruction, letInstruction2, set);
            return;
        }
        LetInstruction letInstruction3 = this.getLetParent(letInstruction2);
        if (letInstruction.hasBeenTypeChecked()) {
            throw new IllegalArgumentException();
        }
        if (letInstruction.getValue() == null) {
            throw new XylemError("ERR_SYSTEM", "xx" + letInstruction);
        }
        BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
        letInstruction.setBody(this.m_baseNull);
        letInstruction.m_lcm = this;
        if (letInstruction2 == null) {
            if (this.m_outerLet == null) {
                this.m_outerLet = letInstruction;
                if (this.m_parentInstruction != null) {
                    this.m_parentInstruction.setChildInstruction(this.m_parentIndex, this.m_outerLet);
                } else {
                    this.m_currentFunction.setBody(this.m_outerLet);
                }
            }
            Instruction instruction = null;
            if (this.m_innerLet != null) {
                instruction = this.m_innerLet.getBody();
                this.m_innerLet.setBody(letInstruction);
                letInstruction.m_parent = this.m_innerLet;
                letInstruction.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, new LinkedList());
            } else {
                letInstruction.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, new LinkedList());
                instruction = this.m_targetInstruction;
            }
            this.m_innerLet = letInstruction;
            letInstruction.setBody(instruction);
            if (instruction instanceof LetInstruction) {
                LetInstruction letInstruction4 = (LetInstruction)instruction;
                letInstruction4.m_parent = letInstruction;
                letInstruction4.m_lcm = this;
            }
        } else {
            if (letInstruction2 == this.m_outerLet) {
                this.m_outerLet = letInstruction;
                if (this.m_parentInstruction != null) {
                    this.m_parentInstruction.setChildInstruction(this.m_parentIndex, this.m_outerLet);
                } else {
                    this.m_currentFunction.setBody(this.m_outerLet);
                }
            }
            letInstruction.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), bindingEnvironment, new LinkedList());
            if (letInstruction3 != null) {
                letInstruction3.setBody(letInstruction);
                letInstruction.m_parent = letInstruction3;
            }
            letInstruction.setBody(letInstruction2);
            letInstruction2.m_parent = letInstruction;
        }
    }

    public Instruction insertBody2(Instruction instruction, LetInstruction letInstruction) {
        Comparable comparable;
        while (instruction instanceof LetInstruction) {
            comparable = (LetInstruction)instruction.cloneShallow();
            try {
                this.addAndTypeCheckLet((LetInstruction)comparable, letInstruction, null);
            }
            catch (TypeCheckException typeCheckException) {
                s_logger.error("Type error transferring let " + comparable, typeCheckException);
                return null;
            }
            instruction = ((LetInstruction)instruction).getBody();
        }
        if (instruction instanceof IdentifierInstruction) {
            return instruction;
        }
        if (instruction instanceof LiteralInstruction) {
            return instruction;
        }
        comparable = ReductionHelper.generateIntermediateIdentifier2();
        try {
            this.addAndTypeCheckLet(new LetInstruction(comparable, instruction, null), letInstruction, null);
        }
        catch (TypeCheckException typeCheckException) {
            s_logger.error("Type error", typeCheckException);
            return null;
        }
        return new IdentifierInstruction(comparable);
    }

    public Instruction insertBodyWithoutClone(Instruction instruction, LetInstruction letInstruction) {
        Comparable comparable;
        while (instruction instanceof LetInstruction) {
            comparable = (LetInstruction)instruction;
            Instruction instruction2 = comparable.getBody();
            try {
                this.addAndTypeCheckLet((LetInstruction)comparable, letInstruction, null);
            }
            catch (TypeCheckException typeCheckException) {
                s_logger.error("Type error transferring let " + comparable, typeCheckException);
                return null;
            }
            instruction = instruction2;
        }
        if (instruction instanceof IdentifierInstruction) {
            return instruction;
        }
        if (instruction instanceof LiteralInstruction) {
            return instruction;
        }
        comparable = ReductionHelper.generateIntermediateIdentifier2();
        try {
            this.addAndTypeCheckLet(new LetInstruction(comparable, instruction, null), letInstruction, null);
        }
        catch (TypeCheckException typeCheckException) {
            s_logger.error("Type error", typeCheckException);
            return null;
        }
        return new IdentifierInstruction(comparable);
    }

    public IdentifierInstruction insertBody(Instruction instruction, LetInstruction letInstruction) {
        return this.insertBodyWithNameHelper(ReductionHelper.generateIntermediateIdentifier2(), instruction, letInstruction, false);
    }

    public IdentifierInstruction insertBodyWithNameForced(Object object, Instruction instruction, LetInstruction letInstruction) {
        return this.insertBodyWithNameHelper(object, instruction, letInstruction, true);
    }

    public IdentifierInstruction insertBodyWithNameHelper(Object object, Instruction instruction, LetInstruction letInstruction, boolean bl) {
        Set set = null;
        while (instruction instanceof LetInstruction) {
            LetInstruction letInstruction2 = (LetInstruction)instruction.cloneShallow();
            try {
                this.addAndTypeCheckLet(letInstruction2, letInstruction, set);
            }
            catch (TypeCheckException typeCheckException) {
                s_logger.error("Type error transferring let " + letInstruction2, typeCheckException);
                return null;
            }
            instruction = ((LetInstruction)instruction).getBody();
        }
        if (!bl && instruction instanceof IdentifierInstruction) {
            return (IdentifierInstruction)instruction;
        }
        try {
            this.addAndTypeCheckLet(new LetInstruction(object, instruction, null), letInstruction, set);
        }
        catch (TypeCheckException typeCheckException) {
            s_logger.error("Type error", typeCheckException);
            return null;
        }
        return new IdentifierInstruction(object);
    }

    public Instruction lookupBinding(Object object) {
        IBinding iBinding = this.findBinding(object);
        if (iBinding == null) {
            return null;
        }
        if (iBinding.getLet() == null) {
            return null;
        }
        Instruction instruction = iBinding.getLet().getValue();
        if (instruction instanceof IdentifierInstruction) {
            return this.lookupBinding(instruction);
        }
        return instruction;
    }

    public IBinding findBinding(Object object) {
        BindingEnvironment bindingEnvironment = this.m_currentFunction.getBindingEnvironment();
        if (bindingEnvironment == null) {
            throw new RuntimeException();
        }
        IBinding iBinding = bindingEnvironment.getVariableBinding(object);
        if (iBinding != null || this.m_parent == null) {
            return iBinding;
        }
        return this.m_parent.findBinding(object);
    }

    public Instruction lookupBinding(Instruction instruction) {
        if (instruction instanceof IdentifierInstruction) {
            return this.lookupBinding(((IdentifierInstruction)instruction).getVariable());
        }
        if (instruction instanceof LiteralInstruction) {
            return instruction;
        }
        throw new IllegalArgumentException();
    }

    public Instruction graftFinalBody(Instruction instruction) {
        LetInstruction letInstruction = this.m_outerLet;
        if (letInstruction != null) {
            while (true) {
                letInstruction.m_lcm = null;
                letInstruction.m_parent = null;
                Instruction instruction2 = letInstruction.getBody();
                if (!(instruction2 instanceof LetInstruction)) break;
                letInstruction = (LetInstruction)instruction2;
            }
        }
        if (instruction == null) {
            return this.m_outerLet == null ? this.m_baseInstruction : this.m_outerLet;
        }
        if (this.m_innerLet != null) {
            this.m_innerLet.setBody(instruction);
            return this.m_outerLet;
        }
        return instruction;
    }

    protected LetInstruction getLetParent(LetInstruction letInstruction) {
        if (letInstruction == null) {
            return null;
        }
        return letInstruction.m_parent;
    }

    public Function getCurrentFunction() {
        return this.m_currentFunction;
    }

    public Instruction getTargetInstruction() {
        return this.m_targetInstruction;
    }
}

