/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionInstantiation;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.ConventionalFunctionGenerationStyle;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.ExtantGenerationState;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.StreamInADTOptimizedFunctionGenerationStyle;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.StreamOptimizedFunctionGenerationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.ConstructorDataType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FunctionCallInstruction
extends NaryPrimopInstruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction {
    protected String m_function;
    private FunctionInstantiation m_instantiation;
    public Type m_type;
    private static int indent;

    public FunctionCallInstruction() {
    }

    public FunctionCallInstruction(String string, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_function = string;
    }

    public FunctionCallInstruction(String string, List list) {
        super(list);
        this.m_function = string;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (this.m_instantiation != null) {
            return this.m_instantiation.m_returnType;
        }
        return this.m_type;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string) {
        this.m_function = string;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        if (function == null) {
            Program.dumpXylemFile(typeEnvironment.getModule(), new File("."), "FunctionCall.TypeCheck");
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Function " + this.m_function + " is not defined"), this);
        }
        super.typeCheckChildren(typeEnvironment, bindingEnvironment, linkedList);
        this.setInstantiation(function.instantiate(typeEnvironment, bindingEnvironment, this.m_parameters, this, linkedList, false));
        this.m_function = this.getInstantiation().m_function.getName();
        return this.setCachedType(this.getInstantiation().m_returnType);
    }

    @Override
    public void instantiateReducedPolymorphicFunctions(Set set, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, Set set2, Set set3) {
        if (typeEnvironment == null) {
            throw new RuntimeException();
        }
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        this.m_type = function.instantiateReduced(typeEnvironment, bindingEnvironment, this.m_parameters, this, set, set2, set3).resolveType(typeEnvironment);
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        try {
            if (function == null) {
                throw new XylemError("ERR_SYSTEM", "Undefined function " + this.m_function);
            }
            this.m_type = function.instantiateReduced(typeEnvironment, bindingEnvironment, this, linkedList);
            if (this.m_type == null) {
                throw new RuntimeException();
            }
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new FunctionCallInstruction(this.m_function, instructionArray);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new FunctionCallInstruction(this.m_function, instructionArray);
    }

    @Override
    public String innerToString() {
        return "Function call: " + this.m_function;
    }

    @Override
    public void accumulateFunctionsCalled(Set set) {
        set.add(this.m_function);
        super.accumulateFunctionsCalled(set);
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        if (this.m_function.equals(bCELCodeGenerationHelper.getCurrentFunction()) && instructionHandle != null && bCELCodeGenerationHelper.getCurrentFunctionGenerationStyle() instanceof ConventionalFunctionGenerationStyle) {
            int n;
            for (n = this.m_parameters.length - 1; n >= 0; --n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(function.m_parameters[n].getName())) continue;
                codeGenerationTracker.generateConventionally(this.m_parameters[n], bCELCodeGenerationHelper, null, instructionListBuilder);
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(function.m_parameters[n].getName())) continue;
                ExtantGenerationState extantGenerationState = (ExtantGenerationState)codeGenerationTracker.getGenerationState(function.m_parameters[n]);
                instructionListBuilder.appendStore(function.m_parameters[n].getBindingType(), extantGenerationState.getRegister());
            }
            instructionListBuilder.appendGoto(instructionHandle);
            return;
        }
        BranchInstruction branchInstruction = null;
        boolean bl = function.getMemoizeResult();
        if (bl) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (!(this.m_parameters[i] instanceof IdentifierInstruction)) continue;
                codeGenerationTracker.generateConventionallyIntoRegister(this.m_parameters[i], bCELCodeGenerationHelper, instructionListBuilder);
            }
            String string2 = function.getMemoCheckVarName(bCELCodeGenerationHelper);
            bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2);
            branchInstruction = instructionListBuilder.appendIfne();
            bCELCodeGenerationHelper.generateThreadLocalVarStartPut(instructionListBuilder);
            instructionListBuilder.appendConstant(true);
            bCELCodeGenerationHelper.generateThreadLocalVarFinishPut(instructionListBuilder, string2);
            bCELCodeGenerationHelper.generateThreadLocalVarStartPut(instructionListBuilder);
        }
        this.generateStaticThisIfNeeded(bCELCodeGenerationHelper, instructionListBuilder);
        int n = bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? 1 : 0;
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length + n];
        if (n == 1) {
            typeArray[0] = new ObjectType(bCELCodeGenerationHelper.getClassName());
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i + n] = function.m_parameters[i].getBindingType().getImplementationType(bCELCodeGenerationHelper);
        }
        bCELCodeGenerationHelper.requestFunctionGeneration(new ConventionalFunctionGenerationStyle(function));
        instructionListBuilder.append(instructionListBuilder.getClassGenerationHelper().m_if.createInvoke(bCELCodeGenerationHelper.getClassName(), Function.generateFunctionName(bCELCodeGenerationHelper, this.m_function), this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).getImplementationType(bCELCodeGenerationHelper), typeArray, bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? (short)184 : 182));
        if (bl) {
            com.ibm.xtq.bcel.generic.Type type = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).getImplementationType(bCELCodeGenerationHelper);
            String string3 = function.getMemoVarName(bCELCodeGenerationHelper);
            bCELCodeGenerationHelper.generateThreadLocalVarFinishPut(instructionListBuilder, string3);
            branchInstruction.setTarget(bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string3));
        }
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        if (this.m_function.equals(dataFlowCodeGenerationHelper.getCurrentFunction()) && bl && dataFlowCodeGenerationHelper.getCurrentFunctionGenerationStyle() instanceof ConventionalFunctionGenerationStyle) {
            String string3;
            String string4;
            int n;
            dataFlowCodeGenerationHelper.append("// calling self via tail recursion\n");
            String[] stringArray = new String[this.m_parameters.length];
            for (n = 0; n < this.m_parameters.length; ++n) {
                string4 = codeGenerationTracker.generateConventionally(this.m_parameters[n], dataFlowCodeGenerationHelper);
                string3 = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[n], dataFlowCodeGenerationHelper, false);
                if (string3 != string4) {
                    for (int i = 0; i < this.m_parameters.length; ++i) {
                        if (string4 != codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[i], dataFlowCodeGenerationHelper, false)) continue;
                        String string5 = string4;
                        string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                        dataFlowCodeGenerationHelper.appendAssignment(string4, codeGenerationTracker.resolveType(this.m_parameters[i]), string5, codeGenerationTracker);
                        break;
                    }
                }
                stringArray[n] = string4;
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                string4 = stringArray[n];
                string3 = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[n], dataFlowCodeGenerationHelper, false);
                if (string3.equals(string4)) continue;
                dataFlowCodeGenerationHelper.append(string3 + " = " + string4 + ";\n");
            }
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                dataFlowCodeGenerationHelper.append("if (true) {\n");
                dataFlowCodeGenerationHelper.getCurrentFunctionGenerationStyle().generateProfileExitCode(dataFlowCodeGenerationHelper, codeGenerationTracker, null, false, null, null);
                dataFlowCodeGenerationHelper.append("continue __tailrecurse__;\n");
                dataFlowCodeGenerationHelper.append("}\n");
            } else {
                dataFlowCodeGenerationHelper.getCurrentFunctionGenerationStyle().generateProfileExitCode(dataFlowCodeGenerationHelper, codeGenerationTracker, null, false, null, null);
                dataFlowCodeGenerationHelper.append("goto __tailrecurse__;\n");
            }
            return "__tailrecurse_result__";
        }
        String string6 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        StringBuffer stringBuffer = new StringBuffer();
        this.generateStaticThisIfNeeded(dataFlowCodeGenerationHelper, stringBuffer, false);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            string2 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            codeGenerationTracker.resolveType(this.m_parameters[i]).generateParam(stringBuffer, dataFlowCodeGenerationHelper, string2, codeGenerationTracker.getCurrentModule());
            if (i >= this.m_parameters.length - 1) continue;
            stringBuffer.append(", ");
        }
        dataFlowCodeGenerationHelper.requestFunctionGeneration(new ConventionalFunctionGenerationStyle(function));
        if (function.getMemoizeResult()) {
            String string7 = dataFlowCodeGenerationHelper.generateThisVar();
            string2 = dataFlowCodeGenerationHelper.isTargetJava() ? string7 + "." : "";
            String string8 = string2 + function.getMemoVarName(dataFlowCodeGenerationHelper);
            String string9 = function.getMemoCheckVarName(dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("if (!" + string2 + string9 + ") {\n");
            String string10 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            dataFlowCodeGenerationHelper.appendAssignment(string10, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), this.generateFunctionName(dataFlowCodeGenerationHelper) + "(" + stringBuffer.toString() + ")", codeGenerationTracker);
            dataFlowCodeGenerationHelper.append(string8 + " = " + string10 + ";\n" + string2 + string9 + " = true;\n}\n");
            dataFlowCodeGenerationHelper.appendAssignment(string6, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string8, codeGenerationTracker);
        } else {
            Type type = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
            if (type == null) {
                throw new XylemError("ERR_SYSTEM", "type not found for '" + this + "'");
            }
            dataFlowCodeGenerationHelper.appendAssignment(string6, type, this.generateFunctionName(dataFlowCodeGenerationHelper) + "(" + stringBuffer.toString() + ")", codeGenerationTracker);
        }
        return string6;
    }

    protected String generateFunctionName(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        String string = Function.generateFunctionName(dataFlowCodeGenerationHelper, this.m_function);
        if (dataFlowCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
            return dataFlowCodeGenerationHelper.getClassName() + "." + string;
        }
        return string;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        int n;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        NamedType namedType = (NamedType)codeGenerationTracker.resolveType(this);
        if (namedType == null) {
            throw new XylemError("ERR_SYSTEM", "no type resolved for " + this);
        }
        ConstructorDataType constructorDataType = (ConstructorDataType)namedType.resolveName(typeEnvironment);
        String string2 = Binding.generateVariableName(binding, dataFlowCodeGenerationHelper);
        if (this.m_function.equals(dataFlowCodeGenerationHelper.getCurrentFunction()) && bl2 && dataFlowCodeGenerationHelper.getCurrentFunctionGenerationStyle() instanceof StreamInADTOptimizedFunctionGenerationStyle) {
            String string3;
            String string4;
            int n2;
            dataFlowCodeGenerationHelper.append("// calling self via tail recursion\n");
            String[] stringArray = new String[this.m_parameters.length];
            for (n2 = 0; n2 < this.m_parameters.length; ++n2) {
                string4 = codeGenerationTracker.generateConventionally(this.m_parameters[n2], dataFlowCodeGenerationHelper);
                string3 = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[n2], dataFlowCodeGenerationHelper, false);
                if (string3 != string4) {
                    for (int i = 0; i < this.m_parameters.length; ++i) {
                        if (string4 != codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[i], dataFlowCodeGenerationHelper, false)) continue;
                        String string5 = string4;
                        string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                        dataFlowCodeGenerationHelper.appendAssignment(string4, codeGenerationTracker.resolveType(this.m_parameters[i]), string5, codeGenerationTracker);
                        break;
                    }
                }
                stringArray[n2] = string4;
            }
            for (n2 = 0; n2 < this.m_parameters.length; ++n2) {
                string4 = stringArray[n2];
                string3 = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[n2], dataFlowCodeGenerationHelper, false);
                if (string3.equals(string4)) continue;
                dataFlowCodeGenerationHelper.append(string3 + " = " + string4 + ";\n");
            }
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                dataFlowCodeGenerationHelper.append("if (true) continue __tailrecurse__;\n");
            } else {
                dataFlowCodeGenerationHelper.append("goto __tailrecurse__;\n");
            }
            return "null";
        }
        if (function.getMemoizeResult()) {
            String string6 = this.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, null, false);
            AbstractDataType.Constructor constructor = constructorDataType.m_constructors[0];
            if (bl) {
                for (int i = 0; i < constructor.m_parameters.length; ++i) {
                    if (constructor.m_parameters[i] == binding) continue;
                    dataFlowCodeGenerationHelper.appendAssignment(string6 + "_" + constructor.getConstructorQualifiedFieldName(i, dataFlowCodeGenerationHelper), constructor.m_parameters[i].getBindingType(), string6 + "." + constructor.getConstructorQualifiedFieldName(i, dataFlowCodeGenerationHelper), codeGenerationTracker);
                }
            }
            StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, (StreamType)binding.getBindingType(), string6 + ".m_" + dataFlowCodeGenerationHelper.getSafeName(constructor.getName()) + "_" + binding.getName(), -1);
            return string6;
        }
        String string7 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        StringBuffer stringBuffer = new StringBuffer();
        this.generateStaticThisIfNeeded(dataFlowCodeGenerationHelper, stringBuffer, true);
        for (n = 0; n < this.m_parameters.length; ++n) {
            String string8 = codeGenerationTracker.generateConventionally(this.m_parameters[n], dataFlowCodeGenerationHelper);
            codeGenerationTracker.resolveType(this.m_parameters[n]).generateParam(stringBuffer, dataFlowCodeGenerationHelper, string8, codeGenerationTracker.getCurrentModule());
            stringBuffer.append(", ");
        }
        stringBuffer.append(StreamType.generateStreamCallList(string, (StreamType)binding.getBindingType()));
        dataFlowCodeGenerationHelper.requestFunctionGeneration(new StreamInADTOptimizedFunctionGenerationStyle(function, binding, bl));
        if (bl) {
            dataFlowCodeGenerationHelper.append(string + "_stream = " + this.generateFunctionName(dataFlowCodeGenerationHelper) + "_" + string2 + "$objectless(" + stringBuffer.toString() + ");\n");
            for (n = 0; n < constructorDataType.m_constructors[0].m_parameters.length; ++n) {
                if (binding == constructorDataType.m_constructors[0].m_parameters[n]) continue;
                dataFlowCodeGenerationHelper.appendAssignment(string7 + "_" + constructorDataType.m_constructors[0].getConstructorQualifiedFieldName(n, dataFlowCodeGenerationHelper), constructorDataType.m_constructors[0].m_parameters[n].getBindingType(), dataFlowCodeGenerationHelper.generateThreadLocalVarReference(constructorDataType.m_constructors[0].getConstructorQualifiedFieldName(n, dataFlowCodeGenerationHelper)), codeGenerationTracker);
            }
        } else {
            dataFlowCodeGenerationHelper.appendAssignment(string7, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), this.generateFunctionName(dataFlowCodeGenerationHelper) + "_" + string2 + "(" + stringBuffer.toString() + ")", codeGenerationTracker);
            dataFlowCodeGenerationHelper.append(string + "_stream = " + string7 + ".m_" + dataFlowCodeGenerationHelper.getSafeName(constructorDataType.m_constructors[0].getName()) + "_" + string2 + ";\n");
        }
        StreamType.generateStreamFunctionCallSuffix(dataFlowCodeGenerationHelper, string, (StreamType)binding.getBindingType());
        return string7;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        NamedType namedType = (NamedType)codeGenerationTracker.resolveType(this);
        if (namedType == null) {
            throw new XylemError("ERR_SYSTEM", "no type resolved for " + this);
        }
        String string = Binding.generateVariableName(binding, bCELCodeGenerationHelper);
        if (this.m_function.equals(bCELCodeGenerationHelper.getCurrentFunction()) && instructionHandle != null && bCELCodeGenerationHelper.getCurrentFunctionGenerationStyle() instanceof StreamInADTOptimizedFunctionGenerationStyle) {
            int n;
            for (n = this.m_parameters.length - 1; n >= 0; --n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(function.m_parameters[n].getName())) continue;
                codeGenerationTracker.generateConventionally(this.m_parameters[n], bCELCodeGenerationHelper, instructionHandle, instructionListBuilder);
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(function.m_parameters[n].getName())) continue;
                ExtantGenerationState extantGenerationState = (ExtantGenerationState)codeGenerationTracker.getGenerationState(function.m_parameters[n]);
                instructionListBuilder.appendStore(function.m_parameters[n].getBindingType(), extantGenerationState.getRegister());
            }
            instructionListBuilder.appendGoto(instructionHandle);
            return;
        }
        this.generateStaticThisIfNeeded(bCELCodeGenerationHelper, instructionListBuilder);
        int n = bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? 1 : 0;
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length + n + 2];
        if (n == 1) {
            typeArray[0] = new ObjectType(bCELCodeGenerationHelper.getClassName());
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i + n] = function.m_parameters[i].getBindingType().getImplementationType(bCELCodeGenerationHelper);
        }
        StreamType streamType = (StreamType)binding.getBindingType();
        typeArray[this.m_parameters.length + n] = streamType.getImplementationType(bCELCodeGenerationHelper);
        typeArray[this.m_parameters.length + n + 1] = BasicType.INT;
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendILoad(nArray[1]);
        bCELCodeGenerationHelper.requestFunctionGeneration(new StreamInADTOptimizedFunctionGenerationStyle(function, binding, bl));
        if (bl) {
            instructionListBuilder.append(instructionListBuilder.getClassGenerationHelper().m_if.createInvoke(bCELCodeGenerationHelper.getClassName(), Function.generateFunctionName(bCELCodeGenerationHelper, this.m_function) + "_" + string + "$objectless", streamType.getImplementationType(bCELCodeGenerationHelper), typeArray, bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? (short)184 : 182));
            instructionListBuilder.appendAStore(nArray[0]);
            ConstructorDataType constructorDataType = (ConstructorDataType)namedType.resolveNameToADT(typeEnvironment);
            for (int i = 0; i < constructorDataType.m_constructors[0].m_parameters.length; ++i) {
                if (binding == constructorDataType.m_constructors[0].m_parameters[i]) continue;
                com.ibm.xtq.bcel.generic.Type type = constructorDataType.m_constructors[0].m_parameters[i].getBindingType().getImplementationType(bCELCodeGenerationHelper);
                String string2 = constructorDataType.getName() + "_" + constructorDataType.m_constructors[0].getName() + "_" + constructorDataType.m_constructors[0].m_parameters[i].getName();
                bCELCodeGenerationHelper.allocateThreadLocalVariable(string2, type, true);
                bCELCodeGenerationHelper.generateThreadLocalVarGet(instructionListBuilder, string2);
            }
        } else {
            instructionListBuilder.append(instructionListBuilder.getClassGenerationHelper().m_if.createInvoke(bCELCodeGenerationHelper.getClassName(), Function.generateFunctionName(bCELCodeGenerationHelper, this.m_function) + "_" + string, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).getImplementationType(bCELCodeGenerationHelper), typeArray, bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? (short)184 : 182));
            AbstractDataType.Constructor constructor = namedType.resolveNameToADT((Module)typeEnvironment.getModule()).m_constructors[0];
            instructionListBuilder.appendDUP();
            instructionListBuilder.appendGetField(constructor, constructor.findBinding(binding), bCELCodeGenerationHelper);
            instructionListBuilder.appendAStore(nArray[0]);
        }
        StreamType.generateStreamFunctionCallSuffix(bCELCodeGenerationHelper, nArray, (StreamType)binding.getBindingType(), instructionListBuilder);
    }

    @Override
    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        if (this.m_function.equals(bCELCodeGenerationHelper.getCurrentFunction()) && instructionHandle != null && bCELCodeGenerationHelper.getCurrentFunctionGenerationStyle() instanceof StreamOptimizedFunctionGenerationStyle) {
            int n;
            for (n = this.m_parameters.length - 1; n >= 0; --n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(function.m_parameters[n].getName())) continue;
                codeGenerationTracker.generateConventionally(this.m_parameters[n], bCELCodeGenerationHelper, instructionHandle, instructionListBuilder);
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                if (this.m_parameters[n] instanceof IdentifierInstruction && ((IdentifierInstruction)this.m_parameters[n]).getVariable().equals(function.m_parameters[n].getName())) continue;
                ExtantGenerationState extantGenerationState = (ExtantGenerationState)codeGenerationTracker.getGenerationState(function.m_parameters[n]);
                instructionListBuilder.appendStore(function.m_parameters[n].getBindingType(), extantGenerationState.getRegister());
            }
            instructionListBuilder.appendGoto(instructionHandle);
            return;
        }
        this.generateStaticThisIfNeeded(bCELCodeGenerationHelper, instructionListBuilder);
        int n = bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? 1 : 0;
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length + n + 2];
        if (n == 1) {
            typeArray[0] = new ObjectType(bCELCodeGenerationHelper.getClassName());
        }
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i + n] = function.m_parameters[i].getBindingType().getImplementationType(bCELCodeGenerationHelper);
        }
        typeArray[this.m_parameters.length + n] = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).getImplementationType(bCELCodeGenerationHelper);
        typeArray[this.m_parameters.length + n + 1] = BasicType.INT;
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendILoad(nArray[1]);
        bCELCodeGenerationHelper.requestFunctionGeneration(new StreamOptimizedFunctionGenerationStyle(function));
        instructionListBuilder.append(instructionListBuilder.getClassGenerationHelper().m_if.createInvoke(bCELCodeGenerationHelper.getClassName(), Function.generateFunctionName(bCELCodeGenerationHelper, this.m_function) + "$stream", this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).getImplementationType(bCELCodeGenerationHelper), typeArray, bCELCodeGenerationHelper.getSettings().isMakeAllMethodsStatic() ? (short)184 : 182));
        instructionListBuilder.appendAStore(nArray[0]);
        StreamType.generateStreamFunctionCallSuffix(bCELCodeGenerationHelper, nArray, (StreamType)codeGenerationTracker.resolveType(this), instructionListBuilder);
    }

    @Override
    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        if (this.m_function.equals(dataFlowCodeGenerationHelper.getCurrentFunction()) && bl && dataFlowCodeGenerationHelper.getCurrentFunctionGenerationStyle() instanceof StreamOptimizedFunctionGenerationStyle) {
            String string2;
            String string3;
            int n;
            dataFlowCodeGenerationHelper.append("// calling self via tail recursion\n");
            String[] stringArray = new String[this.m_parameters.length];
            for (n = 0; n < this.m_parameters.length; ++n) {
                string3 = codeGenerationTracker.generateConventionally(this.m_parameters[n], dataFlowCodeGenerationHelper);
                string2 = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[n], dataFlowCodeGenerationHelper, false);
                if (string2 != string3) {
                    for (int i = 0; i < this.m_parameters.length; ++i) {
                        if (string3 != codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[i], dataFlowCodeGenerationHelper, false)) continue;
                        String string4 = string3;
                        string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
                        dataFlowCodeGenerationHelper.appendAssignment(string3, codeGenerationTracker.resolveType(this.m_parameters[i]), string4, codeGenerationTracker);
                        break;
                    }
                }
                stringArray[n] = string3;
            }
            for (n = 0; n < this.m_parameters.length; ++n) {
                string3 = stringArray[n];
                string2 = codeGenerationTracker.generateConventionally((IBinding)function.m_parameters[n], dataFlowCodeGenerationHelper, false);
                if (string2.equals(string3)) continue;
                dataFlowCodeGenerationHelper.append(string2 + " = " + string3 + ";\n");
            }
            if (dataFlowCodeGenerationHelper.isTargetJava()) {
                dataFlowCodeGenerationHelper.append("if (true) continue __tailrecurse__;\n");
            } else {
                dataFlowCodeGenerationHelper.append("goto __tailrecurse__;\n");
            }
            return;
        }
        if (function.getMemoizeResult()) {
            String string5 = this.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, null, false);
            StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, (StreamType)this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string5, -1);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.generateStaticThisIfNeeded(dataFlowCodeGenerationHelper, stringBuffer, true);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            String string6 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            codeGenerationTracker.resolveType(this.m_parameters[i]).generateParam(stringBuffer, dataFlowCodeGenerationHelper, string6, codeGenerationTracker.getCurrentModule());
            stringBuffer.append(", ");
        }
        stringBuffer.append(StreamType.generateStreamCallList(string, null));
        dataFlowCodeGenerationHelper.requestFunctionGeneration(new StreamOptimizedFunctionGenerationStyle(function));
        String string7 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        dataFlowCodeGenerationHelper.appendAssignment(string7, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), this.generateFunctionName(dataFlowCodeGenerationHelper) + "$stream(" + stringBuffer.toString() + ")", codeGenerationTracker);
        dataFlowCodeGenerationHelper.append(string + "_stream = " + string7 + ";\n");
        StreamType.generateStreamFunctionCallSuffix(dataFlowCodeGenerationHelper, string, (StreamType)codeGenerationTracker.resolveType(this));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)object;
        return functionCallInstruction.m_function.equals(this.m_function);
    }

    protected void generateStaticThisIfNeeded(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, StringBuffer stringBuffer, boolean bl) {
        if (!dataFlowCodeGenerationHelper.getSettings().isMakeAllMethodsStatic()) {
            return;
        }
        stringBuffer.append("__this__");
        if (bl || this.m_parameters.length > 0) {
            stringBuffer.append(", ");
        }
    }

    protected void generateStaticThisIfNeeded(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder) {
        instructionListBuilder.appendThis();
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            if (function.m_checkedStreamOptimization) {
                return function.m_supportsStreamOptimization;
            }
            if (function.m_inSupportsStreamCall) {
                return true;
            }
            function.m_inSupportsStreamCall = true;
            function.m_supportsStreamOptimization = function.getBody().supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, function.getTypeEnvironment(), function.getBindingEnvironment());
            function.m_inSupportsStreamCall = false;
            return function.m_supportsStreamOptimization;
        }
        if (codeGenerationOptimizationStyle instanceof StreamInADTOptimizationStyle) {
            if (function.m_checkedStreamInADTOptimization) {
                return function.m_supportsStreamInADTOptimization;
            }
            if (function.m_inSupportsStreamInADTCall) {
                return true;
            }
            function.m_inSupportsStreamInADTCall = true;
            function.m_supportsStreamInADTOptimization = function.getBody().supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, function.getTypeEnvironment(), function.getBindingEnvironment());
            if (function.m_supportsStreamInADTOptimization) {
                function.m_supportsStreamInObjectlessADT = ((IStreamInADTOptimizationInstruction)((Object)function.getBody())).canGenerateObjectless(typeEnvironment);
            }
            function.m_inSupportsStreamInADTCall = false;
            return function.m_supportsStreamInADTOptimization;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        Function function = typeEnvironment.getModule().getFunction(this.m_function);
        return function.m_supportsStreamInObjectlessADT;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.m_function, n);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].toString(prettyPrinter, n + 1);
        }
        prettyPrinter.printFormClose(n);
    }

    private boolean tailCallNeeded(boolean bl, Function function, Function function2) {
        return bl && function.equals(function2);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        int n;
        Object object2;
        TypeEnvironment typeEnvironment;
        Function function2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((function2 = (typeEnvironment = function.getTypeEnvironment()).getModule().getFunction(this.m_function)).getMemoizeResult() && (object2 = environment.lookupMemoizedFunction(function2)) != null) {
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
        }
        object2 = function2.m_parameters;
        Object[] objectArray = new Object[((Binding[])object2).length];
        Object[] objectArray2 = new Object[((Binding[])object2).length];
        for (n = 0; n < ((Binding[])object2).length; ++n) {
            objectArray2[n] = object = this.m_parameters[n].evaluate(environment, function, iDebuggerInterceptor, false);
        }
        for (n = 0; n < ((Binding[])object2).length; ++n) {
            objectArray[n] = environment.bind(object2[n], objectArray2[n]);
        }
        if (bl && function2.equals(function)) {
            throw new TailCallEvent(function);
        }
        object = null;
        Debugger.enterContext(iDebuggerInterceptor, function2);
        do {
            n = 0;
            try {
                object = function2.getBody().evaluate(environment, function2, iDebuggerInterceptor, true);
            }
            catch (TailCallEvent tailCallEvent) {
                if (function2.equals(tailCallEvent.f)) {
                    n = 1;
                    continue;
                }
                for (int i = 0; i < ((Binding[])object2).length; ++i) {
                    environment.bind(object2[i], objectArray[i]);
                }
                throw tailCallEvent;
            }
        } while (n != 0);
        Debugger.leaveContext(iDebuggerInterceptor, function2, object);
        if (function2.getMemoizeResult()) {
            environment.memoizeFunction(function2, object);
        }
        for (int i = 0; i < ((Binding[])object2).length; ++i) {
            environment.bind(object2[i], objectArray[i]);
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    @Override
    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        int n;
        TypeEnvironment typeEnvironment = function.getTypeEnvironment();
        Function function2 = typeEnvironment.getModule().getFunction(this.m_function);
        if (function2.getMemoizeResult()) {
            super.evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
            return;
        }
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Binding[] bindingArray = function2.m_parameters;
        Object[] objectArray = new Object[bindingArray.length];
        Object[] objectArray2 = new Object[bindingArray.length];
        for (n = 0; n < bindingArray.length; ++n) {
            Object object;
            objectArray2[n] = object = this.m_parameters[n].evaluate(environment, function, iDebuggerInterceptor, false);
        }
        for (n = 0; n < bindingArray.length; ++n) {
            objectArray[n] = environment.bind(bindingArray[n], objectArray2[n]);
        }
        Debugger.enterContext(iDebuggerInterceptor, function2);
        function2.getBody().evaluate(iAppendableStream, environment, function2, iDebuggerInterceptor);
        Debugger.leaveContext(iDebuggerInterceptor, function2, null);
        for (n = 0; n < bindingArray.length; ++n) {
            environment.bind(bindingArray[n], objectArray[n]);
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
    }

    @Override
    public void clearTypeInformation() {
        super.clearTypeInformation();
        this.setInstantiation(null);
    }

    public boolean fixupPartiallySpecializedFunctions(Function function) throws TypeCheckException {
        Serializable serializable;
        TypeEnvironment typeEnvironment = function.getTypeEnvironment();
        if (this.getInstantiation().m_function.isPolymorphic()) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (this.m_parameters[i].getCachedType().resolveType(typeEnvironment) != null) continue;
                return false;
            }
            serializable = new LinkedList();
            ((LinkedList)serializable).add(function);
            this.setInstantiation(this.getInstantiation().m_function.instantiate(function.getTypeEnvironment(), this.m_bindingEnvironment == null ? function.getBindingEnvironment() : this.m_bindingEnvironment, this.m_parameters, this, (LinkedList)serializable, false));
            this.m_function = this.getInstantiation().m_function.getName();
            if (this.getInstantiation().m_function.isPolymorphic()) {
                throw new RuntimeException();
            }
        }
        serializable = this.getInstantiation().m_function.getReturnType();
        if (this.getInstantiation().m_function.getTypeEnvironment() == null) {
            throw new RuntimeException();
        }
        if ((serializable = ((Type)serializable).resolveType(this.getInstantiation().m_function.getTypeEnvironment())) == null) {
            return false;
        }
        function.getTypeEnvironment().unify((Type)serializable, this.getCachedType(), this);
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    public void setInstantiation(FunctionInstantiation functionInstantiation) {
        this.m_instantiation = functionInstantiation;
    }

    public FunctionInstantiation getInstantiation() {
        return this.m_instantiation;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_function = readObjectFileHelper.readString();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_function);
    }

    public class TailCallEvent
    extends RuntimeException {
        static final long serialVersionUID = 0L;
        public Function f;

        public TailCallEvent(Function function) {
            this.f = function;
        }
    }
}

