/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.parsers.xpath.tempconstructors;

import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.parsers.xpath.Token;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.scontext.XStaticContext;
import javax.xml.namespace.QName;

public class IQNameWrapper
extends SimpleNode {
    QName m_qname;
    public short m_type;
    public String m_ncname;

    public IQNameWrapper(int n) {
        super(n);
    }

    @Override
    public void processValue(ASTBuildingContext aSTBuildingContext, String string) {
        super.processValue(aSTBuildingContext, string);
        if (string.equals("*")) {
            this.m_type = 0;
        } else {
            this.m_qname = IQNameWrapper.resolveQName(aSTBuildingContext, string);
            this.m_type = (short)3;
        }
    }

    @Override
    public void processToken(ASTBuildingContext aSTBuildingContext, Token token) {
        super.processToken(aSTBuildingContext, token);
        switch (this.id) {
            case 191: 
            case 192: {
                String string = token.image.trim();
                this.m_qname = IQNameWrapper.resolveQName(aSTBuildingContext, string);
                this.m_type = (short)3;
                break;
            }
            case 92: {
                this.m_type = 0;
                break;
            }
            case 94: {
                this.m_ncname = token.image.trim();
                this.m_ncname = this.m_ncname.substring(this.m_ncname.indexOf(":") + 1);
                this.m_type = (short)2;
                break;
            }
            case 93: {
                XStaticContext xStaticContext = aSTBuildingContext.getStaticContext();
                this.m_ncname = token.image.trim();
                this.m_ncname = this.m_ncname.substring(0, this.m_ncname.indexOf(":"));
                String string = xStaticContext.getNamespaceURI(this.m_ncname);
                if (string == null) {
                    ASTMsg aSTMsg = new ASTMsg("NAMESPACE_UNDEF_ERR", this.m_ncname);
                    aSTBuildingContext.getReporter().report(3, aSTMsg);
                }
                this.m_type = 1;
                break;
            }
            default: {
                String string = token.image;
                int n = string.lastIndexOf("(");
                if (n > 0) {
                    string = string.substring(0, n);
                }
                this.m_qname = IQNameWrapper.resolveQName(aSTBuildingContext, string);
                this.m_type = (short)3;
            }
        }
    }

    public QName getQName() {
        return this.m_qname;
    }

    public void setQName(QName qName) {
        this.m_qname = qName;
    }

    public static QName resolveQName(ASTBuildingContext aSTBuildingContext, String string) {
        QName qName;
        XStaticContext xStaticContext = aSTBuildingContext.getStaticContext();
        int n = (string = string.trim()).indexOf(":");
        if (n == -1) {
            qName = aSTBuildingContext.getExpressionFactory().createQName(null, string, null);
        } else {
            String string2 = string.substring(0, n);
            String string3 = xStaticContext.getNamespaceURI(string2);
            if (string3 == null || string3.length() == 0) {
                ASTMsg aSTMsg = new ASTMsg("NAMESPACE_UNDEF_ERR", string2);
                aSTBuildingContext.getReporter().report(3, aSTMsg);
            }
            qName = aSTBuildingContext.getExpressionFactory().createQName(string3, string.substring(n + 1), string2);
        }
        return qName;
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node, int n) {
        if (node instanceof IQNameWrapper) {
            this.m_ncname = ((IQNameWrapper)node).m_ncname;
            this.m_qname = ((IQNameWrapper)node).m_qname;
            this.m_type = ((IQNameWrapper)node).m_type;
        }
    }
}

