/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan;

import com.ibm.xml.xlxp.scan.ScannerHelper;
import com.ibm.xml.xlxp.scan.util.AttrList;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.NSDeclList;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.QName;
import com.ibm.xml.xlxp.scan.util.SymbolTable;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLString;

public final class DocumentEntityScanner {
    private static final int STATE_START_ELEMENT = 0;
    private static final int STATE_END_ELEMENT = 1;
    private static final int STATE_CONTENT = 2;
    private static final int STATE_XML_DECL = 0;
    private static final int STATE_START_DOCUMENT = 1;
    private static final int STATE_PROLOG = 2;
    private static final int STATE_TRAILING_MISC = 3;
    private static final int STATE_UNBUFFERED = 4;
    private static final int STATE_UNBUFFERED_START_ELEMENT = 4;
    private static final int STATE_UNBUFFERED_END_ELEMENT = 5;
    private static final int STATE_UNBUFFERED_CONTENT = 6;
    private static final int STATE_FINAL = 7;
    private static final int STATE_BUFFERED = 8;
    private static final int STATE_BUFFERED_START_ELEMENT = 8;
    private static final int STATE_BUFFERED_END_ELEMENT = 9;
    private static final int STATE_BUFFERED_CONTENT = 10;
    private static final int STATE_INT_SUBSET = 11;
    private static final int STATE_EXT_SUBSET = 12;
    private static final int STATE_UNBUFFERED_SCANNING_CDATA_SECT = 13;
    private static final int STATE_BUFFERED_SCANNING_CDATA_SECT = 14;
    private static final int STATE_UNBUFFERED_ENDING_CDATA_SECT = 15;
    private static final int STATE_UNBUFFERED_MARKUP = 16;
    private static final int STATE_CHECKS_BUFFERED = 12;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    private static final byte[] XMLDECL_BYTES = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] VERSION_BYTES = new byte[]{118, 101, 114, 115, 105, 111, 110};
    private static final byte[] VERSION10_BYTES = new byte[]{49, 46, 48};
    private static final byte[] VERSION11_BYTES = new byte[]{49, 46, 49};
    private static final byte[] ENCODING_BYTES = new byte[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final byte[] STANDALONE_BYTES = new byte[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final byte[] YES_BYTES = new byte[]{121, 101, 115};
    private static final byte[] NO_BYTES = new byte[]{110, 111};
    private static final byte[] DOCTYPE_BYTES = new byte[]{68, 79, 67, 84, 89, 80, 69};
    private static final byte[] CDSTART_BYTES = new byte[]{91, 67, 68, 65, 84, 65, 91};
    private static final byte[] CDEND_BYTES = new byte[]{93, 93, 62};
    private static final byte[] COMMENT_START_BYTES = new byte[]{60, 33};
    private static final byte[] PI_START_BYTES = new byte[]{60, 63};
    private static final byte[] PI_END_BYTES = new byte[]{63, 62};
    private static final byte[] contentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] elementContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedElementContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] cdSectMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final byte[] piMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final byte[] commentMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    protected static final byte[] attValueMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] encNameCharMap = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] markupMap = new byte[]{5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final byte[] digitMap = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private ScannerHelper fHelper;
    private int fCurrentState;
    private boolean fActiveContentScan;
    private ParsedEntity fCurrentEntity;
    private boolean fLineBreaksNormalized;
    private DataBuffer fCurrentBuffer;
    private byte[] fData;
    private int fCurrentOffset;
    private int fEndOffset;
    private int fThisByte;
    private boolean fEndOfEntity;
    private boolean fIsXML10 = true;
    private DTDSupport fDTDSupport;
    private boolean fSeenDoctype;
    private XMLString fAttValueChars;
    private QName fTempQName = new QName();
    private int fSkippedElementDepth;

    public DocumentEntityScanner() {
        this.fAttValueChars = new XMLString();
    }

    public void reset(boolean bl) {
        this.fIsXML10 = true;
        this.fActiveContentScan = false;
        this.fSeenDoctype = false;
        this.fCurrentState = 0;
        this.fEndOfEntity = false;
        this.fTempQName.clear();
        this.fAttValueChars.clear();
        this.fCurrentBuffer = null;
        if (this.fCurrentEntity != null) {
            if (this.fDTDSupport == null) {
                this.fCurrentEntity.release();
            }
            this.fCurrentEntity = null;
        }
    }

    public void setScannerHelper(ScannerHelper scannerHelper) {
        this.fHelper = scannerHelper;
    }

    public void setDTDSupport(DTDSupport dTDSupport) {
        this.fDTDSupport = dTDSupport;
    }

    public void parseDocumentEntity(ParsedEntity parsedEntity) {
        this.setDocumentEntity(parsedEntity);
        this.produceEvents();
    }

    public void setDocumentEntity(ParsedEntity parsedEntity) {
        this.fHelper.initialize();
        this.fCurrentState = 0;
        if (this.fDTDSupport != null) {
            this.fDTDSupport.setDocumentEntity(parsedEntity);
        }
        this.setEntityContent(parsedEntity);
    }

    public int currentState() {
        return this.fCurrentState;
    }

    public void setCurrentState(int n) {
        this.fCurrentState = n;
    }

    protected boolean isXML10() {
        return this.fIsXML10;
    }

    protected boolean currentEntityIsXML11AndInternal() {
        return !this.fIsXML10 && this.fCurrentEntity.isInternal;
    }

    protected boolean skippedXML11LineBreak() {
        return !this.fIsXML10 && !this.fLineBreaksNormalized && (this.fThisByte & 0xDF) == 194 && this.skippedXML11EOLChar();
    }

    protected boolean reportFatalError(int n) {
        return this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", n);
    }

    private boolean stateXMLDecl() {
        if (this.scanXMLDecl()) {
            return this.fHelper.produceStartDocumentEvent();
        }
        this.fCurrentState = 1;
        return false;
    }

    private boolean stateStartDocument() {
        this.fCurrentState = 2;
        if (this.fHelper.produceStartDocumentEvent()) {
            return this.scanProlog();
        }
        return false;
    }

    private boolean stateUnbufferedStartElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanStartElementUnbuffered(this.fCurrentEntity);
        if (this.fCurrentBuffer == this.fCurrentEntity.buffer) {
            this.fCurrentOffset = this.fCurrentEntity.offset;
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte == 0) {
                this.checkForLoad();
            }
        } else if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        if (bl && !this.fActiveContentScan) {
            bl = this.stateUnbufferedContent();
        }
        return bl;
    }

    private boolean stateUnbufferedEndElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanEndElementUnbuffered(this.fCurrentEntity);
        if (this.fCurrentBuffer == this.fCurrentEntity.buffer) {
            this.fCurrentOffset = this.fCurrentEntity.offset;
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte == 0) {
                this.checkForLoad();
            }
        } else if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        if (bl && !this.fActiveContentScan) {
            bl = this.stateUnbufferedContent();
        }
        return bl;
    }

    private boolean stateUnbufferedContent() {
        this.fActiveContentScan = true;
        boolean bl = this.fThisByte == 60 ? this.scanMarkupUnbuffered() : this.fHelper.scanContentUnbuffered(this.fCurrentEntity);
        this.fActiveContentScan = false;
        return bl;
    }

    private boolean stateUnbufferedCDSect() {
        this.fCurrentState = 6;
        return this.scanCDSectUnbuffered();
    }

    private boolean stateUnbufferedMarkup() {
        this.fCurrentState = 6;
        return this.scanMarkupUnbuffered();
    }

    private boolean stateUnbufferedEndCDSect() {
        this.fCurrentOffset += 3;
        this.fThisByte = this.fData[this.fCurrentOffset];
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.fCurrentState = 6;
        return this.fHelper.produceEndCDATASectionEvent();
    }

    private boolean stateBufferedStartElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanStartElementBuffered(this.fCurrentEntity);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    private boolean stateBufferedEndElement() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fHelper.scanEndElementBuffered(this.fCurrentEntity);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    private boolean stateBufferedContent() {
        if (this.fThisByte == 60) {
            return this.scanMarkupBuffered();
        }
        return this.fHelper.scanContentBuffered(this.fCurrentEntity);
    }

    private boolean stateBufferedCDSect() {
        this.fCurrentState = 10;
        return this.scanCDSectBuffered();
    }

    private boolean stateIntSubset() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.scanInternalDTDSubset();
        }
        return true;
    }

    private boolean stateExtSubset() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.scanExternalDTDSubset();
        }
        return true;
    }

    public boolean produceEvent() {
        switch (this.fCurrentState) {
            case 0: {
                return this.stateXMLDecl();
            }
            case 1: {
                return this.stateStartDocument();
            }
            case 2: {
                return this.scanProlog();
            }
            case 3: {
                return this.scanTrailingMisc();
            }
            case 4: {
                return this.stateUnbufferedStartElement();
            }
            case 5: {
                return this.stateUnbufferedEndElement();
            }
            case 6: {
                return this.stateUnbufferedContent();
            }
            case 8: {
                return this.stateBufferedStartElement();
            }
            case 9: {
                return this.stateBufferedEndElement();
            }
            case 10: {
                return this.stateBufferedContent();
            }
            case 11: {
                return this.stateIntSubset();
            }
            case 12: {
                return this.stateExtSubset();
            }
            case 16: {
                return this.stateUnbufferedMarkup();
            }
            case 13: {
                return this.stateUnbufferedCDSect();
            }
            case 15: {
                return this.stateUnbufferedEndCDSect();
            }
            case 14: {
                return this.stateBufferedCDSect();
            }
        }
        return false;
    }

    public boolean produceEvents() {
        while (this.produceEvent()) {
        }
        return true;
    }

    private int invalidCharParameter() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.fCurrentEntity.decodeCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    protected void setInvalidCharParameter(int n) {
        int n2 = this.invalidCharParameter();
        this.fHelper.setInvalidCharParameter(n, n2);
    }

    public boolean endDocument() {
        this.fCurrentState = 7;
        return this.fHelper.produceEndDocumentEvent();
    }

    protected int scanNCName(XMLString xMLString) {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.fHelper.scanNCName(this.fCurrentEntity, xMLString);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    protected int scanNmtoken(XMLString xMLString, SymbolTable symbolTable) {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = symbolTable.scanNmtoken(this.fCurrentEntity, xMLString);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    protected int scanQName(QName qName) {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.fHelper.scanQName(this.fCurrentEntity, qName);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return n;
    }

    public boolean hasDefaultAttributes() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.hasDefaultAttributes();
        }
        return false;
    }

    public boolean addDefaultAttributes(QName qName, NSDeclList nSDeclList, AttrList attrList, boolean bl) {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.addDefaultAttributes(qName, nSDeclList, attrList, bl);
        }
        return true;
    }

    public void finishStartElementBuffered() {
        this.fCurrentState = 10;
    }

    public void finishStartElementUnbuffered() {
        this.fCurrentState = 6;
    }

    public void finishStartElement() {
        if (this.fCurrentEntity.unbuffered) {
            this.finishStartElementUnbuffered();
        } else {
            this.finishStartElementBuffered();
        }
    }

    public void finishEmptyElementBuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 10;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    public void finishEmptyElementUnbuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 6;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    public void finishEmptyElement(int n) {
        if (this.fCurrentEntity.unbuffered) {
            this.finishEmptyElementUnbuffered(n);
        } else {
            this.finishEmptyElementBuffered(n);
        }
    }

    public void finishEndElementBuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 10;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    public void finishEndElementUnbuffered(int n) {
        if (n > 0) {
            this.fCurrentState = 6;
        } else {
            this.fActiveContentScan = true;
            this.fCurrentState = 3;
        }
    }

    private void setMark(int n) {
        this.fCurrentEntity.offset = n;
        this.fCurrentEntity.setMark();
    }

    private void resetToMark() {
        this.fCurrentEntity.resetToMark();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
    }

    private void checkForLoad() {
        if (this.fCurrentOffset == this.fEndOffset) {
            if (!this.fCurrentEntity.unbuffered) {
                this.loadMore();
            } else {
                this.fEndOfEntity = true;
            }
        }
    }

    private int loadMore() {
        ParsedEntity parsedEntity = this.fCurrentEntity;
        while (parsedEntity != null) {
            parsedEntity.offset = this.fCurrentOffset;
            this.fEndOfEntity = parsedEntity.load();
            if (parsedEntity.error == null) {
                if (this.setEntityLocals(parsedEntity) != 0 || this.fEndOfEntity) {
                    return this.fThisByte;
                }
                this.fThisByte = 0;
                continue;
            }
            this.fThisByte = 0;
            return 0;
        }
        this.fThisByte = 0;
        return 0;
    }

    protected boolean skippedValidChar() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fCurrentEntity.skippedValidCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    private boolean skippedXML11EOLChar() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fCurrentEntity.skippedXML11EOLCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    protected boolean skippedNameChar() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        boolean bl = this.fCurrentEntity.skippedNameCharacter();
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        return bl;
    }

    protected void nextStateProlog() {
        this.fCurrentState = 2;
        this.fCurrentEntity.offset = this.fCurrentOffset;
    }

    protected void nextStateIntSubset() {
        this.fCurrentState = 11;
        this.fCurrentEntity.offset = this.fCurrentOffset;
    }

    protected void nextStateExtSubset() {
        this.fCurrentState = 12;
        this.fCurrentEntity.offset = this.fCurrentOffset;
    }

    public void setEntityContent(ParsedEntity parsedEntity) {
        if (this.fCurrentEntity == parsedEntity) {
            this.setEntityLocals(parsedEntity);
        } else {
            if (this.fCurrentEntity != null && this.fCurrentEntity.offset != this.fCurrentOffset) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
            }
            this.fCurrentEntity = parsedEntity;
            this.fLineBreaksNormalized = parsedEntity.lineBreaksNormalized;
            this.fCurrentBuffer = parsedEntity.buffer;
            this.fData = parsedEntity.bytes;
            this.fEndOffset = parsedEntity.endOffset;
            this.fCurrentOffset = parsedEntity.offset;
            this.fEndOfEntity = false;
            this.fThisByte = this.fData[this.fCurrentOffset];
            if (this.fThisByte == 0) {
                this.checkForLoad();
            }
        }
    }

    private int setEntityLocals(ParsedEntity parsedEntity) {
        if (this.fCurrentBuffer == parsedEntity.buffer) {
            if (this.fData != parsedEntity.bytes || this.fEndOffset != parsedEntity.endOffset) {
                UntestedCode.needTest("yikes");
            }
        } else {
            this.fCurrentBuffer = parsedEntity.buffer;
            this.fData = parsedEntity.bytes;
            this.fEndOffset = parsedEntity.endOffset;
        }
        this.fCurrentOffset = parsedEntity.offset;
        this.fThisByte = this.fData[this.fCurrentOffset];
        return this.fThisByte;
    }

    protected boolean atEndOfEntity() {
        return this.fEndOfEntity;
    }

    protected int currentByte() {
        return this.fThisByte;
    }

    protected boolean lineBreaksNormalized() {
        return this.fLineBreaksNormalized;
    }

    protected int nextByte() {
        ++this.fCurrentOffset;
        this.fThisByte = this.fData[this.fCurrentOffset];
        if (this.fThisByte != 0 || this.fCurrentOffset < this.fEndOffset) {
            return this.fThisByte;
        }
        return this.loadMore();
    }

    protected boolean skippedByte(int n) {
        if (this.fThisByte == n) {
            this.nextByte();
            return true;
        }
        return false;
    }

    protected boolean skippedBytes(byte[] byArray) {
        return this.skippedBytesInRange(byArray, 0, byArray.length);
    }

    private boolean skippedBytesInRange(byte[] byArray, int n, int n2) {
        if (this.fThisByte == byArray[n] && this.fCurrentOffset + (n2 - n) <= this.fEndOffset) {
            int n3 = this.fCurrentOffset++;
            int n4 = this.fData[this.fCurrentOffset];
            while (++n < n2) {
                if (n4 == byArray[n]) {
                    ++this.fCurrentOffset;
                    n4 = this.fData[this.fCurrentOffset];
                    continue;
                }
                this.fCurrentOffset = n3;
                return false;
            }
            if (n4 != 0 || this.fCurrentOffset < this.fEndOffset) {
                this.fThisByte = n4;
            } else {
                this.loadMore();
            }
            return true;
        }
        return this.skippedBytesBuffered(byArray, n, n2);
    }

    private boolean skippedBytesBuffered(byte[] byArray, int n, int n2) {
        if (this.fThisByte == byArray[n]) {
            boolean bl = false;
            int n3 = this.fCurrentOffset++;
            int n4 = n + 1;
            int n5 = this.fData[this.fCurrentOffset];
            while (n4 < n2) {
                if (n5 == byArray[n4]) {
                    ++this.fCurrentOffset;
                    ++n4;
                    n5 = this.fData[this.fCurrentOffset];
                    continue;
                }
                if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                    if (bl) {
                        this.resetToMark();
                    } else {
                        this.fCurrentOffset = n3;
                    }
                    return false;
                }
                if (!bl) {
                    this.setMark(n3);
                    bl = true;
                }
                if (this.loadMore() == 0) {
                    this.resetToMark();
                    return false;
                }
                n5 = this.fThisByte;
            }
            if (bl) {
                this.fCurrentEntity.clearMark();
            }
            if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                this.fThisByte = n5;
            } else {
                this.loadMore();
            }
            return true;
        }
        return false;
    }

    private boolean skippedBytesBuffered2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = dataBuffer.endOffset;
        if (this.fThisByte == byArray[n]) {
            boolean bl = false;
            int n4 = this.fCurrentOffset++;
            int n5 = this.fData[this.fCurrentOffset];
            ++n;
            while (true) {
                if (n == n3) {
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    int n6 = n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                }
                if (n5 == byArray[n]) {
                    ++this.fCurrentOffset;
                    ++n;
                    n5 = this.fData[this.fCurrentOffset];
                    continue;
                }
                if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                    if (bl) {
                        this.resetToMark();
                    } else {
                        this.fCurrentOffset = n4;
                    }
                    return false;
                }
                if (!bl) {
                    this.setMark(n4);
                    bl = true;
                }
                if (this.loadMore() == 0) {
                    this.resetToMark();
                    return false;
                }
                n5 = this.fThisByte;
            }
            if (bl) {
                this.fCurrentEntity.clearMark();
            }
            if (n5 != 0 || this.fCurrentOffset < this.fEndOffset) {
                this.fThisByte = n5;
            } else {
                this.loadMore();
            }
            return true;
        }
        return false;
    }

    protected boolean skippedSpace() {
        int n = this.fThisByte;
        if (n == 32 || n == 10 || n == 9 || n == 13) {
            this.nextByte();
            return true;
        }
        return !this.fIsXML10 && (n & 0xDF) == 194 && this.skippedXML11EOLChar();
    }

    protected void skipSpaces() {
        while (true) {
            int n;
            if ((n = this.fThisByte) == 32 || n == 10 || n == 9 || n == 13) {
                this.nextByte();
                continue;
            }
            if (this.fIsXML10 || (n & 0xDF) != 194 || !this.skippedXML11EOLChar()) break;
        }
    }

    protected boolean skippedSpaces() {
        int n = this.fThisByte;
        if (n == 32 || n == 10 || n == 9 || n == 13) {
            while ((n = this.nextByte()) == 32 || n == 10 || n == 9 || n == 13) {
            }
            if (!this.fIsXML10 && (n & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                this.skipSpaces();
            }
            return true;
        }
        if (!this.fIsXML10 && (n & 0xDF) == 194 && this.skippedXML11EOLChar()) {
            this.skipSpaces();
            return true;
        }
        return false;
    }

    private boolean skipToChar(int n) {
        int n2 = this.fThisByte;
        while (n2 != n) {
            n2 = this.nextByte();
            if (n2 != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean skippedValidXMLBytesUsingMapForXMLString(byte[] byArray, int n, XMLString xMLString) {
        if (!this.fLineBreaksNormalized) {
            return this.skippedValidXMLBytesUsingMapForXMLString2(byArray, n, xMLString);
        }
        return this.skippedNormalizedValidXMLBytesUsingMap(byArray, n);
    }

    private boolean skippedValidXMLBytesUsingMapForXMLString2(byte[] byArray, int n, XMLString xMLString) {
        boolean bl;
        if (byArray[this.fThisByte & 0xFF] == n) {
            ++this.fCurrentOffset;
            bl = true;
            while (byArray[this.fData[this.fCurrentOffset] & 0xFF] == n) {
                ++this.fCurrentOffset;
            }
            this.fThisByte = this.fData[this.fCurrentOffset];
        } else {
            bl = false;
        }
        if (this.fThisByte >= 32) {
            return bl;
        }
        return this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, n, xMLString, bl);
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipMoreValidXMLBytesUsingMapForXMLString(byte[] var1_1, int var2_2, XMLString var3_3, boolean var4_4) {
        block10: {
            block9: {
                block8: {
                    if (this.fThisByte == 0 && (this.fCurrentOffset < this.fEndOffset || this.loadMore() == 0)) {
                        return var4_4;
                    }
                    if (var1_1[this.fThisByte & 255] != var2_2) break block8;
                    ++this.fCurrentOffset;
                    ** GOTO lbl21
                }
                if (this.fThisByte != 13) break block9;
                var3_3.flags |= 4;
                ++this.fCurrentOffset;
                ** GOTO lbl21
            }
            if (this.fThisByte > 0) {
                return var4_4;
            }
            if (this.fIsXML10 || (this.fThisByte & 223) != 194 || !this.skippedXML11EOLChar()) break block10;
            var3_3.flags |= 8;
            ** GOTO lbl21
        }
        if (this.skippedValidChar()) ** GOTO lbl21
        return var4_4;
        {
            ++this.fCurrentOffset;
lbl21:
            // 5 sources

            while (true) {
                if (var1_1[this.fData[this.fCurrentOffset] & 255] == var2_2) continue block0;
                this.fThisByte = this.fData[this.fCurrentOffset];
                if (this.fThisByte > 0) {
                    if (this.fThisByte != 13) {
                        return true;
                    }
                    var3_3.flags |= 4;
                    ++this.fCurrentOffset;
                    continue;
                }
                if (this.fThisByte < 0) {
                    if (!this.fIsXML10 && (this.fThisByte & 223) == 194 && this.skippedXML11EOLChar()) {
                        var3_3.flags |= 8;
                        continue;
                    }
                    if (this.skippedValidChar()) continue;
                    return true;
                }
                if (this.fCurrentOffset < this.fEndOffset || this.loadMore() == 0) break block0;
            }
        }
        return true;
    }

    private boolean skippedNormalizedValidXMLBytesUsingMap(byte[] byArray, int n) {
        boolean bl;
        if (byArray[this.fThisByte & 0xFF] == n) {
            ++this.fCurrentOffset;
            bl = true;
            while (byArray[this.fData[this.fCurrentOffset] & 0xFF] == n) {
                ++this.fCurrentOffset;
            }
            this.fThisByte = this.fData[this.fCurrentOffset];
        } else {
            bl = false;
        }
        if (this.fThisByte >= 32) {
            return bl;
        }
        return this.skipMoreNormalizedValidXMLBytesUsingMap(byArray, n, bl);
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipMoreNormalizedValidXMLBytesUsingMap(byte[] var1_1, int var2_2, boolean var3_3) {
        block6: {
            block5: {
                if (this.fThisByte == 0 && (this.fCurrentOffset < this.fEndOffset || this.loadMore() == 0)) {
                    return var3_3;
                }
                if (var1_1[this.fThisByte & 255] != var2_2) break block5;
                ++this.fCurrentOffset;
                ** GOTO lbl14
            }
            if (this.fThisByte != 13) break block6;
            ++this.fCurrentOffset;
            ** GOTO lbl14
        }
        if (this.fThisByte <= 0 && this.skippedValidChar()) ** GOTO lbl14
        return var3_3;
        {
            ++this.fCurrentOffset;
lbl14:
            // 4 sources

            while (true) {
                if (var1_1[this.fData[this.fCurrentOffset] & 255] == var2_2) continue block0;
                this.fThisByte = this.fData[this.fCurrentOffset];
                if (this.fThisByte > 0) {
                    if (this.fThisByte != 13) {
                        return true;
                    }
                    ++this.fCurrentOffset;
                    continue;
                }
                if (this.fThisByte < 0 ? this.skippedValidChar() == false : this.fCurrentOffset < this.fEndOffset || this.loadMore() == 0) break block0;
            }
        }
        return true;
    }

    protected boolean skippedBytesUsingMap(byte[] byArray, int n) {
        boolean bl = false;
        do {
            if (byArray[this.fThisByte & 0xFF] != n) continue;
            bl = true;
            do {
                ++this.fCurrentOffset;
            } while (byArray[this.fData[this.fCurrentOffset] & 0xFF] == n);
            this.fThisByte = this.fData[this.fCurrentOffset];
        } while (this.fThisByte == 0 && this.fCurrentOffset == this.fEndOffset && this.loadMore() != 0);
        return bl;
    }

    protected void startString(XMLString xMLString) {
        xMLString.setStartPos(this.fCurrentBuffer, this.fCurrentOffset);
        xMLString.flags = 0;
    }

    protected void endString(XMLString xMLString) {
        xMLString.setEndPos(this.fCurrentBuffer, this.fCurrentOffset, 0);
    }

    protected void endStringWithFlags(XMLString xMLString, int n) {
        xMLString.setEndPos(this.fCurrentBuffer, this.fCurrentOffset, n);
    }

    protected void endStringUndo(XMLString xMLString) {
        xMLString.clearEndPos();
    }

    private void setValues(XMLString xMLString, int n, int n2, int n3) {
        xMLString.setValues(this.fCurrentBuffer, n, n2, n3);
    }

    public boolean scanAttrValueBuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueBuffered(xMLString, n, this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0)) {
            bl = this.fHelper.saveSpecifiedAttValue();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    public boolean scanAttrValueUnbuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueUnbuffered(xMLString, n)) {
            bl = this.fHelper.saveSpecifiedAttValue();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    public boolean scanNamespaceURIBuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueBuffered(xMLString, n, this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0)) {
            bl = this.fHelper.saveSpecifiedNamespaceURI();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    public boolean scanNamespaceURIUnbuffered(XMLString xMLString, int n) {
        boolean bl;
        ParsedEntity parsedEntity = this.fCurrentEntity;
        if (this.setEntityLocals(parsedEntity) == 0) {
            this.checkForLoad();
        }
        if (bl = this.scanAttValueUnbuffered(xMLString, n)) {
            bl = this.fHelper.saveSpecifiedNamespaceURI();
        }
        if (this.fCurrentEntity == parsedEntity) {
            parsedEntity.offset = this.fCurrentOffset;
        }
        return bl;
    }

    private boolean scanXMLDecl() {
        this.fCurrentState = 2;
        this.setMark(this.fCurrentOffset);
        if (!this.skippedBytes(XMLDECL_BYTES) || !this.skippedSpaces()) {
            this.resetToMark();
            return true;
        }
        this.fCurrentEntity.clearMark();
        return this.scanXMLDeclOrTextDecl(true);
    }

    protected boolean scanTextDecl() {
        this.setMark(this.fCurrentOffset);
        if (!this.skippedBytes(XMLDECL_BYTES) || !this.skippedSpaces()) {
            this.resetToMark();
            return true;
        }
        this.fCurrentEntity.clearMark();
        return this.scanXMLDeclOrTextDecl(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanXMLDeclOrTextDecl(boolean bl) {
        int n;
        XMLString xMLString = this.fHelper.versionToProduce();
        XMLString xMLString2 = this.fHelper.encNameToProduce();
        XMLString xMLString3 = this.fHelper.standaloneToProduce();
        int n2 = 0;
        boolean bl2 = true;
        do {
            int n3;
            if (bl) {
                if (n2 == 0) {
                    if (!this.skippedBytes(VERSION_BYTES)) return this.reportFatalError(10);
                    n2 = 1;
                    n3 = 28;
                } else if (n2 != 1 || !this.skippedBytes(ENCODING_BYTES)) {
                    if (!this.skippedBytes(STANDALONE_BYTES)) break;
                    if (n2 == 1) {
                        xMLString2.clear();
                    }
                    n2 = 3;
                    n3 = 30;
                } else {
                    n2 = 2;
                    n3 = 29;
                }
            } else if (n2 == 0 && this.skippedBytes(VERSION_BYTES)) {
                n2 = 1;
                n3 = 28;
            } else {
                if (!this.skippedBytes(ENCODING_BYTES)) return this.reportFatalError(45);
                if (n2 == 0) {
                    xMLString.clear();
                }
                n2 = 2;
                n3 = 29;
            }
            this.skipSpaces();
            if (!this.skippedByte(61)) {
                int n4 = bl ? 7 : 41;
                this.fHelper.setParameter(0, n3);
                return this.reportFatalError(n4);
            }
            this.skipSpaces();
            if (this.skippedByte(34)) {
                n = 34;
            } else if (this.skippedByte(39)) {
                n = 39;
            } else {
                int n5 = bl ? 8 : 42;
                this.fHelper.setParameter(0, n3);
                return this.reportFatalError(n5);
            }
            switch (n2) {
                case 1: {
                    boolean bl3;
                    this.startString(xMLString);
                    if (this.skippedBytes(VERSION10_BYTES)) {
                        bl2 = true;
                        bl3 = true;
                    } else if ((bl || !this.fIsXML10) && this.skippedBytes(VERSION11_BYTES)) {
                        bl2 = false;
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                    if (!bl3 || this.fThisByte != n) {
                        if (!this.skipToChar(n)) {
                            int n6 = bl ? 8 : 42;
                            this.fHelper.setParameter(0, n3);
                            return this.reportFatalError(n6);
                        }
                        this.endString(xMLString);
                        this.fHelper.setParameter(0, xMLString);
                        return this.reportFatalError(34);
                    }
                    this.endString(xMLString);
                    this.nextByte();
                    if (this.skippedSpaces()) break;
                    if (!bl) return this.reportFatalError(43);
                    xMLString2.clear();
                    xMLString3.clear();
                    n2 = 4;
                    break;
                }
                case 2: {
                    this.startString(xMLString2);
                    if (!this.skipToChar(n)) {
                        int n7 = bl ? 8 : 42;
                        this.fHelper.setParameter(0, n3);
                        return this.reportFatalError(n7);
                    }
                    this.endString(xMLString2);
                    if (!DocumentEntityScanner.validEncName(xMLString2)) {
                        this.fHelper.setParameter(0, xMLString2);
                        return this.reportFatalError(46);
                    }
                    this.nextByte();
                    if (!this.skippedSpaces()) {
                        if (bl) {
                            xMLString3.clear();
                        }
                        n2 = 4;
                        break;
                    }
                    if (bl) break;
                    n2 = 4;
                    break;
                }
                case 3: {
                    this.startString(xMLString3);
                    if (!this.skippedBytes(YES_BYTES) && !this.skippedBytes(NO_BYTES) || this.fThisByte != n) {
                        if (!this.skipToChar(n)) {
                            this.fHelper.setParameter(0, n3);
                            return this.reportFatalError(8);
                        }
                        this.endString(xMLString3);
                        this.fHelper.setParameter(0, xMLString3);
                        return this.reportFatalError(13);
                    }
                    this.endString(xMLString3);
                    this.nextByte();
                    this.skipSpaces();
                    n2 = 4;
                }
            }
        } while (n2 != 4);
        if (!this.skippedByte(63) || !this.skippedByte(62)) {
            n = bl ? 9 : 44;
            return this.reportFatalError(n);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        if (bl) {
            this.fIsXML10 = bl2;
            this.fCurrentEntity.isXML10 = bl2;
            if (this.fDTDSupport == null || xMLString3.length != 3) return this.fHelper.produceXMLDeclEvent();
            this.fDTDSupport.setStandalone();
            return this.fHelper.produceXMLDeclEvent();
        }
        this.fCurrentEntity.isXML10 = this.fIsXML10;
        return this.fHelper.produceTextDeclEvent();
    }

    private static boolean validEncName(XMLString xMLString) {
        byte[] byArray = xMLString.bytes;
        int n = xMLString.startOffset;
        int n2 = xMLString.endOffset;
        if (byArray != null) {
            if (n < n2) {
                byte by = byArray[n];
                ++n;
                if (encNameCharMap[by & 0xFF] == 1) {
                    while (n < n2) {
                        by = byArray[n];
                        ++n;
                        if (encNameCharMap[by & 0xFF] != 0) continue;
                        return false;
                    }
                    return true;
                }
            }
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            byArray = dataBuffer.bytes;
            byte by = byArray[n];
            ++n;
            if (encNameCharMap[by & 0xFF] == 1) {
                int n3 = dataBuffer.endOffset;
                while (true) {
                    if (n < n3) {
                        by = byArray[n];
                        ++n;
                        if (encNameCharMap[by & 0xFF] != 0) continue;
                        return false;
                    }
                    if (dataBuffer == null) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    if (dataBuffer == xMLString.lastBuffer) {
                        n3 = n2;
                        dataBuffer = null;
                        continue;
                    }
                    n3 = dataBuffer.endOffset;
                }
            }
        }
        return false;
    }

    private boolean scanProlog() {
        block6: {
            block7: {
                block8: {
                    while (true) {
                        this.skipSpaces();
                        if (this.fThisByte != 60) break block6;
                        if (!this.skippedBytes(COMMENT_START_BYTES)) {
                            if (!this.skippedBytes(PI_START_BYTES)) {
                                return this.scanRootElement();
                            }
                            if (this.scanPI()) continue;
                            return false;
                        }
                        if (!this.skippedByte(45)) break block7;
                        if (!this.skippedByte(45)) break block8;
                        if (!this.scanComment()) break;
                    }
                    return false;
                }
                return this.reportFatalError(27);
            }
            if (!this.fSeenDoctype && this.skippedBytes(DOCTYPE_BYTES)) {
                this.fSeenDoctype = true;
                return this.scanDoctypeDecl();
            }
            return this.reportFatalError(11);
        }
        if (this.fThisByte == 38) {
            return this.reportFatalError(11);
        }
        if (this.fEndOfEntity) {
            return this.reportFatalError(0);
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(4);
    }

    private boolean scanDoctypeDecl() {
        if (this.fDTDSupport != null) {
            this.fCurrentEntity.offset = this.fCurrentOffset;
            return this.fDTDSupport.scanDoctypeDecl(this.fCurrentEntity);
        }
        return this.skipDoctypeDecl();
    }

    private boolean skipDoctypeDecl() {
        if (!this.skippedSpaces()) {
            return this.reportFatalError(11);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        int n = this.scanQName(this.fTempQName);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        if (n == 0) {
            return this.reportFatalError(11);
        }
        do {
            if (this.skippedByte(91)) {
                do {
                    if (!this.skippedByte(93)) continue;
                    this.skipSpaces();
                    if (!this.skippedByte(62)) continue;
                    return true;
                } while (this.skippedValidChar());
                if (this.fEndOfEntity) {
                    return this.reportFatalError(11);
                }
                this.setInvalidCharParameter(0);
                return this.reportFatalError(4);
            }
            if (!this.skippedByte(62)) continue;
            return true;
        } while (this.skippedValidChar());
        if (this.fEndOfEntity) {
            return this.reportFatalError(11);
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(4);
    }

    private boolean scanRootElement() {
        int n = this.fData[this.fCurrentOffset + 1];
        if (this.fCurrentEntity.unbuffered) {
            this.fCurrentState = 4;
            if (markupMap[n & 0xFF] == 1) {
                return this.stateUnbufferedStartElement();
            }
        } else {
            this.fCurrentState = 8;
            if (n == 0 && this.fCurrentOffset + 1 >= this.fEndOffset) {
                this.setMark(this.fCurrentOffset);
                n = this.nextByte();
                this.resetToMark();
            }
            if (markupMap[n & 0xFF] == 1) {
                return true;
            }
        }
        return this.reportFatalError(19);
    }

    public boolean scanContentBuffered(XMLString xMLString) {
        boolean bl = false;
        this.startString(xMLString);
        block10: while (true) {
            if (this.skippedValidXMLBytesUsingMapForXMLString(contentMap, 1, xMLString)) {
                bl = true;
            }
            if (bl) {
                this.endStringWithFlags(xMLString, xMLString.flags);
                this.fCurrentEntity.offset = this.fCurrentOffset;
                this.fCurrentState = 10;
                if (!this.fHelper.produceCharactersEvent()) {
                    return false;
                }
                bl = false;
            }
            switch (contentMap[this.fThisByte & 0xFF]) {
                case 2: {
                    return this.scanMarkupBuffered();
                }
                case 3: {
                    this.nextByte();
                    this.fCurrentState = 10;
                    if (!this.checkReferenceInContent()) {
                        return false;
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    continue block10;
                }
                case 4: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        return this.reportFatalError(5);
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block10;
                }
                case 5: {
                    continue block10;
                }
                case 6: {
                    UntestedCode.needTest("not reached");
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block10;
                }
                case 7: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 8: {
                    if (this.fEndOfEntity) {
                        if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                            int n = this.fCurrentState & 0xC;
                            if (n != 0 && this.fCurrentEntity.unbuffered != ((n & 8) == 0)) {
                                this.fCurrentState ^= 0xC;
                            }
                            return this.fHelper.continueAfterEndOfEntity();
                        }
                        return this.reportFatalError(19);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 9: {
                    if (!this.fIsXML10) break;
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block10;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            xMLString = this.fHelper.contentToProduce();
            this.startString(xMLString);
            this.nextByte();
            bl = true;
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    public boolean scanElementContentBuffered(XMLString xMLString) {
        byte[] byArray = this.fLineBreaksNormalized ? normalizedElementContentMap : elementContentMap;
        this.startString(xMLString);
        while (this.skippedBytesUsingMap(byArray, 5)) {
            if (this.fThisByte == 13) {
                this.nextByte();
                xMLString.flags |= 4;
                if (this.fIsXML10) {
                    byArray = normalizedElementContentMap;
                    continue;
                }
                if ((this.fThisByte & 0xDF) != 194 || !this.skippedXML11EOLChar()) continue;
                xMLString.flags |= 8;
                continue;
            }
            this.endStringWithFlags(xMLString, xMLString.flags | 2);
            this.fCurrentEntity.offset = this.fCurrentOffset;
            this.fCurrentState = 10;
            if (!this.fHelper.produceWhitespaceEvent()) {
                return false;
            }
            if (this.fThisByte == 60) {
                return this.scanMarkupBuffered();
            }
            xMLString = this.fHelper.contentToProduce();
            this.startString(xMLString);
            break;
        }
        if (this.fThisByte != 60) {
            return this.scanElementContentBuffered2(xMLString);
        }
        return this.scanMarkupBuffered();
    }

    private boolean scanElementContentBuffered2(XMLString xMLString) {
        boolean bl = false;
        block9: while (true) {
            if (this.skippedBytesUsingMap(elementContentMap, 5)) {
                bl = true;
            }
            switch (elementContentMap[this.fThisByte & 0xFF]) {
                case 1: {
                    if (bl) {
                        this.skippedBytesUsingMap(contentMap, 1);
                        xMLString.flags &= 0xFFFFFFFD;
                        xMLString.flags |= 1;
                        this.endStringWithFlags(xMLString, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 10;
                        if (!this.fHelper.produceCharactersEvent()) {
                            return false;
                        }
                        xMLString = this.fHelper.contentToProduce();
                    }
                    return this.scanContentBuffered(xMLString);
                }
                case 2: {
                    if (bl) {
                        xMLString.flags &= 0xFFFFFFFE;
                        xMLString.flags |= 2;
                        this.endStringWithFlags(xMLString, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 10;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            return false;
                        }
                    }
                    return this.scanMarkupBuffered();
                }
                case 3: {
                    if (bl) {
                        xMLString.flags &= 0xFFFFFFFE;
                        xMLString.flags |= 2;
                        this.endStringWithFlags(xMLString, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 10;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            return false;
                        }
                        xMLString = this.fHelper.contentToProduce();
                    }
                    this.nextByte();
                    this.fCurrentState = 10;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    bl = false;
                    continue block9;
                }
                case 4: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.reportFatalError(5);
                    }
                    this.nextByte();
                    this.skippedBytesUsingMap(contentMap, 1);
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.endStringWithFlags(xMLString, xMLString.flags);
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fCurrentState = 10;
                    if (!this.fHelper.produceCharactersEvent()) {
                        return false;
                    }
                    this.fCurrentState = 10;
                    xMLString = this.fHelper.contentToProduce();
                    return this.scanContentBuffered(xMLString);
                }
                case 5: 
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    this.nextByte();
                    bl = true;
                    continue block9;
                }
                case 7: {
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && (this.fThisByte & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                        xMLString.flags |= 8;
                        bl = true;
                        continue block9;
                    }
                    if (!this.skippedValidChar()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.setInvalidCharParameter(0);
                        return this.reportFatalError(2);
                    }
                    this.skippedBytesUsingMap(contentMap, 1);
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.endStringWithFlags(xMLString, xMLString.flags);
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fCurrentState = 10;
                    if (!this.fHelper.produceCharactersEvent()) {
                        return false;
                    }
                    this.fCurrentState = 10;
                    xMLString = this.fHelper.contentToProduce();
                    return this.scanContentBuffered(xMLString);
                }
                case 8: {
                    if (!this.fEndOfEntity) break block9;
                    if (bl) {
                        xMLString.flags &= 0xFFFFFFFE;
                        xMLString.flags |= 2;
                        this.endStringWithFlags(xMLString, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 10;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            return false;
                        }
                    }
                    if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                        int n = this.fCurrentState & 0xC;
                        if (n != 0 && this.fCurrentEntity.unbuffered != ((n & 8) == 0)) {
                            this.fCurrentState ^= 0xC;
                        }
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.fHelper.continueAfterEndOfEntity();
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.reportFatalError(19);
                }
            }
            break;
        }
        if (this.fIsXML10 && elementContentMap[this.fThisByte & 0xFF] == 9 || !this.fIsXML10 && this.fCurrentEntity.isInternal && elementContentMap[this.fThisByte & 0xFF] == 0) {
            this.nextByte();
            this.skippedBytesUsingMap(contentMap, 1);
            xMLString.flags &= 0xFFFFFFFD;
            xMLString.flags |= 1;
            this.endStringWithFlags(xMLString, xMLString.flags);
            this.fCurrentEntity.offset = this.fCurrentOffset;
            this.fCurrentState = 10;
            if (!this.fHelper.produceCharactersEvent()) {
                return false;
            }
            this.fCurrentState = 10;
            xMLString = this.fHelper.contentToProduce();
            return this.scanContentBuffered(xMLString);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    private boolean scanMarkupBuffered() {
        int n = this.fData[this.fCurrentOffset + 1];
        if (n == 0 && this.fCurrentOffset + 1 == this.fEndOffset) {
            this.setMark(this.fCurrentOffset);
            n = this.nextByte();
            this.resetToMark();
        }
        switch (markupMap[n & 0xFF]) {
            case 1: {
                this.fCurrentState = 8;
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return true;
            }
            case 2: {
                this.fCurrentState = 9;
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return true;
            }
            case 3: {
                this.nextByte();
                this.nextByte();
                this.fCurrentState = 10;
                boolean bl = this.scanPI();
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return bl;
            }
            case 4: {
                this.nextByte();
                this.nextByte();
                if (this.skippedByte(45)) {
                    if (this.skippedByte(45)) {
                        this.fCurrentState = 10;
                        boolean bl = this.scanComment();
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return bl;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.reportFatalError(27);
                }
                if (this.skippedBytes(CDSTART_BYTES)) {
                    this.fCurrentState = 10;
                    boolean bl = this.scanStartCDSectBuffered();
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return bl;
                }
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return this.reportFatalError(19);
            }
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        return this.reportFatalError(19);
    }

    /*
     * Unable to fully structure code
     */
    public boolean scanStartElementBuffered() {
        var1_1 = this.fHelper.setupStartElement();
        this.nextByte();
        this.fCurrentEntity.offset = this.fCurrentOffset;
        var2_2 = this.fHelper.scanQName(this.fCurrentEntity, var1_1);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        switch (var2_2) {
            case 4: {
                this.nextByte();
                var4_3 = false;
                var3_4 = true;
                ** GOTO lbl82
            }
            case 5: {
                this.nextByte();
                var4_3 = false;
                var3_4 = false;
                ** GOTO lbl82
            }
            case 6: {
                this.skipSpaces();
                var3_4 = this.skippedByte(47);
                if (!var3_4 && !this.skippedByte(62)) ** GOTO lbl27
                var4_3 = false;
                ** GOTO lbl82
lbl27:
                // 1 sources

                var4_3 = true;
                if (true) ** GOTO lbl82
            }
            case 2: 
            case 7: {
                this.fHelper.setParameter(0, var1_1);
                return this.reportFatalError(15);
            }
            default: {
                return this.reportFatalError(19);
            }
            case 1: {
                return this.reportFatalError(49);
            }
        }
        do {
            var5_5 = this.fHelper.currentAttributeName();
            this.fCurrentEntity.offset = this.fCurrentOffset;
            var2_2 = this.fHelper.scanQName(this.fCurrentEntity, var5_5);
            if (this.setEntityLocals(this.fCurrentEntity) == 0) {
                this.checkForLoad();
            }
            switch (var2_2) {
                case 7: {
                    this.nextByte();
                    this.skipSpaces();
                    break;
                }
                case 6: {
                    this.skipSpaces();
                    if (this.skippedByte(61)) {
                        this.skipSpaces();
                        break;
                    }
                }
                case 2: 
                case 4: 
                case 5: {
                    this.fHelper.setParameter(0, var1_1);
                    this.fHelper.setParameter(1, var5_5);
                    return this.reportFatalError(16);
                }
                default: {
                    this.fHelper.setParameter(0, var1_1);
                    return this.reportFatalError(15);
                }
                case 1: {
                    return this.reportFatalError(49);
                }
            }
            var6_6 = this.fHelper.setupSpecifiedAttribute();
            if (this.skippedByte(34)) {
                var8_8 = 34;
            } else if (this.skippedByte(39)) {
                var8_8 = 39;
            } else {
                this.fHelper.setParameter(0, var1_1);
                this.fHelper.setParameter(1, var5_5);
                return this.reportFatalError(24);
            }
            if (!this.scanAttValueBuffered(var6_6, var8_8, this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0)) {
                return false;
            }
            if (!this.fHelper.addSpecifiedAttribute()) {
                return false;
            }
            var7_7 = this.skippedSpaces();
            var3_4 = this.skippedByte(47);
            if (var3_4 || this.skippedByte(62)) break;
            if (var7_7) continue;
            this.fHelper.setParameter(0, var1_1);
            return this.reportFatalError(15);
lbl82:
            // 5 sources

        } while (var4_3);
        if (var3_4) {
            if (this.skippedByte(62)) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return this.fHelper.finishEmptyElement();
            }
            this.fHelper.setParameter(0, var1_1);
            return this.reportFatalError(15);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        return this.fHelper.finishStartElement();
    }

    private boolean scanAttValueBuffered(XMLString xMLString, int n, int n2) {
        boolean bl = false;
        boolean bl2 = true;
        int n3 = 0;
        this.startString(xMLString);
        block10: while (true) {
            if (this.skippedBytesUsingMap(attValueMap, 1)) {
                bl = true;
            }
            switch (attValueMap[this.fThisByte & 0xFF]) {
                case 2: {
                    if ((n2 == 0 || this.fDTDSupport != null && this.fDTDSupport.entityDepth() == n2) && this.fThisByte == n) {
                        if (bl) {
                            this.endStringWithFlags(xMLString, n3);
                            this.fHelper.attributeValueCharacters(xMLString, bl2);
                        }
                        if (xMLString == this.fAttValueChars) {
                            this.fAttValueChars.clear();
                        }
                        this.nextByte();
                        return true;
                    }
                    this.nextByte();
                    bl = true;
                    continue block10;
                }
                case 3: {
                    if (bl) {
                        this.endStringWithFlags(xMLString, n3);
                        this.fHelper.attributeValueCharacters(xMLString, bl2);
                        if (xMLString != this.fAttValueChars) {
                            this.fAttValueChars.clear();
                            this.fHelper.attributeValueCharacters(this.fAttValueChars, true);
                        }
                    }
                    this.nextByte();
                    if (!this.checkReferenceInAttValue()) {
                        return false;
                    }
                    xMLString = this.fAttValueChars;
                    this.startString(xMLString);
                    bl = false;
                    bl2 = true;
                    n3 = 0;
                    continue block10;
                }
                case 4: {
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    return this.reportFatalError(25);
                }
                case 5: {
                    this.nextByte();
                    bl = true;
                    bl2 = false;
                    continue block10;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        n3 |= 4;
                    }
                    bl = true;
                    bl2 = false;
                    do {
                        this.nextByte();
                    } while (this.fThisByte == 32 || this.fThisByte == 10 || this.fThisByte == 9 || this.fThisByte == 13);
                    continue block10;
                }
                case 7: {
                    if (this.fIsXML10 && this.skippedValidChar()) {
                        bl = true;
                        continue block10;
                    }
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && (this.fThisByte & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                        n3 |= 8;
                        bl2 = false;
                    } else if (this.fIsXML10 || !this.skippedValidChar()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fHelper.setParameter(0, this.fHelper.currentElementType());
                        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                        this.setInvalidCharParameter(2);
                        return this.reportFatalError(21);
                    }
                    bl = true;
                    continue block10;
                }
                case 8: {
                    if (this.fEndOfEntity) {
                        if (bl) {
                            this.endStringWithFlags(xMLString, n3);
                            this.fHelper.attributeValueCharacters(xMLString, bl2);
                        }
                        if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                            xMLString = this.fAttValueChars;
                            this.startString(xMLString);
                            bl = false;
                            bl2 = true;
                            n3 = 0;
                            continue block10;
                        }
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fHelper.setParameter(0, this.fHelper.currentElementType());
                        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                        return this.reportFatalError(26);
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    this.setInvalidCharParameter(2);
                    return this.reportFatalError(21);
                }
                case 9: {
                    if (!this.fIsXML10) break;
                    this.nextByte();
                    bl = true;
                    continue block10;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.nextByte();
            bl = true;
        }
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.fHelper.setParameter(0, this.fHelper.currentElementType());
        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
        this.setInvalidCharParameter(2);
        return this.reportFatalError(21);
    }

    public boolean scanEndElementBuffered() {
        QName qName = this.fHelper.popElement();
        this.nextByte();
        this.nextByte();
        if (qName != null) {
            boolean bl = qName.bytes != null ? this.skippedBytesInRange(qName.bytes, qName.startOffset, qName.endOffset) : this.skippedBytesBuffered2(qName.firstBuffer, qName.lastBuffer, qName.startOffset, qName.endOffset);
            if (bl) {
                if (this.skippedByte(62) || this.skippedSpaces() && this.skippedByte(62)) {
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.finishEndElementBuffered(this.fHelper.elementDepth());
                    return this.fHelper.produceEndElementEvent(qName);
                }
                this.fHelper.setParameter(0, qName);
                return this.reportFatalError(18);
            }
            return this.scanEndElementNoMatch(qName);
        }
        this.fHelper.setParameter(0, this.fHelper.topElement());
        return this.reportFatalError(20);
    }

    private boolean scanStartCDSectBuffered() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.fCurrentState = 14;
        if (!this.fHelper.produceStartCDATASectionEvent()) {
            return false;
        }
        return this.scanCDSectBuffered();
    }

    private boolean scanCDSectBuffered() {
        boolean bl = false;
        XMLString xMLString = this.fHelper.contentToProduce();
        this.startString(xMLString);
        block7: while (true) {
            if (this.skippedValidXMLBytesUsingMapForXMLString(cdSectMap, 1, xMLString)) {
                bl = true;
            }
            if (bl) {
                this.endStringWithFlags(xMLString, xMLString.flags);
                this.fCurrentEntity.offset = this.fCurrentOffset;
                if (!this.fHelper.produceCharactersEvent()) {
                    return false;
                }
                bl = false;
            }
            switch (cdSectMap[this.fThisByte & 0xFF]) {
                case 2: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.fCurrentState = 10;
                        return this.fHelper.produceEndCDATASectionEvent();
                    }
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block7;
                }
                case 3: {
                    UntestedCode.needTest("not reached");
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block7;
                }
                case 4: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(1);
                }
                case 5: {
                    if (this.fEndOfEntity) {
                        return this.reportFatalError(6);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(1);
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    xMLString = this.fHelper.contentToProduce();
                    this.startString(xMLString);
                    this.nextByte();
                    bl = true;
                    continue block7;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            xMLString = this.fHelper.contentToProduce();
            this.startString(xMLString);
            this.nextByte();
            bl = true;
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(1);
    }

    public boolean scanContentUnbuffered(XMLString xMLString) {
        boolean bl;
        int n;
        block15: {
            block16: {
                byte[] byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
                n = this.fCurrentOffset;
                xMLString.flags = 0;
                while (byArray[this.fData[n] & 0xFF] == 1) {
                    ++n;
                }
                if (this.fData[n] == 60) break block15;
                if (!this.fIsXML10 || this.fData[n] != 13) break block16;
                ++n;
                xMLString.flags |= 4;
                while (normalizedContentMap[this.fData[n] & 0xFF] == 1) {
                    ++n;
                }
                if (this.fData[n] == 60) break block15;
            }
            ParsedEntity parsedEntity = this.fCurrentEntity;
            boolean bl2 = this.scanContentUnbuffered2(xMLString, n);
            if (this.fCurrentEntity == parsedEntity) {
                parsedEntity.offset = this.fCurrentOffset;
            }
            return bl2;
        }
        if (n > this.fCurrentOffset) {
            xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
            this.fCurrentOffset = n;
            this.fCurrentEntity.offset = n;
            this.fThisByte = this.fData[n];
            this.fCurrentState = 6;
            bl = this.fHelper.produceCharactersEvent();
        } else {
            bl = true;
        }
        switch (markupMap[this.fData[n + 1] & 0xFF]) {
            case 1: {
                this.fCurrentState = 4;
                if (bl) {
                    return this.stateUnbufferedStartElement();
                }
                return false;
            }
            case 2: {
                this.fCurrentState = 5;
                if (bl) {
                    return this.stateUnbufferedEndElement();
                }
                return false;
            }
        }
        if (bl) {
            return this.scanMarkupUnbuffered();
        }
        this.fCurrentState = 16;
        return false;
    }

    private boolean scanContentUnbuffered2(XMLString xMLString, int n) {
        byte[] byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
        byte[] byArray2 = this.fData;
        block16: while (true) {
            if (byArray[byArray2[n] & 0xFF] == 1) {
                ++n;
                continue;
            }
            switch (byArray[byArray2[n] & 0xFF]) {
                case 2: {
                    if (n > this.fCurrentOffset) {
                        xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset = n;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            return false;
                        }
                    }
                    switch (markupMap[byArray2[n + 1] & 0xFF]) {
                        case 1: {
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            this.fCurrentState = 4;
                            return this.stateUnbufferedStartElement();
                        }
                        case 2: {
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            this.fCurrentState = 5;
                            return this.stateUnbufferedEndElement();
                        }
                        case 3: {
                            this.fCurrentOffset = n + 2;
                            this.fThisByte = this.fData[this.fCurrentOffset];
                            if (this.scanPI()) break;
                            return false;
                        }
                        case 4: {
                            if (byArray2[n + 2] == 45) {
                                if (byArray2[n + 3] == 45) {
                                    this.fCurrentOffset = n + 4;
                                    this.fThisByte = this.fData[this.fCurrentOffset];
                                    if (this.scanComment()) break;
                                    return false;
                                }
                                this.fCurrentOffset = n;
                                this.fThisByte = this.fData[this.fCurrentOffset];
                                return this.reportFatalError(27);
                            }
                            if (byArray2[n + 2] == 91 && byArray2[n + 3] == 67 && byArray2[n + 4] == 68 && byArray2[n + 5] == 65 && byArray2[n + 6] == 84 && byArray2[n + 7] == 65 && byArray2[n + 8] == 91) {
                                this.fCurrentOffset = n + 9;
                                if (this.scanStartCDSectUnbuffered()) break;
                                return false;
                            }
                            this.fCurrentOffset = n;
                            return this.reportFatalError(19);
                        }
                        default: {
                            this.fCurrentOffset = n;
                            return this.reportFatalError(19);
                        }
                    }
                    byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
                    xMLString = this.fHelper.contentToProduce();
                    xMLString.flags = 0;
                    n = this.fCurrentOffset;
                    continue block16;
                }
                case 3: {
                    if (n > this.fCurrentOffset) {
                        xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset = n;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceCharactersEvent()) {
                            return false;
                        }
                    }
                    this.fCurrentOffset = n + 1;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    this.fCurrentState = 6;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    if (this.fCurrentEntity.unbuffered) {
                        byArray = this.fLineBreaksNormalized ? normalizedContentMap : contentMap;
                        xMLString = this.fHelper.contentToProduce();
                        xMLString.flags = 0;
                        byArray2 = this.fData;
                        n = this.fCurrentOffset;
                        continue block16;
                    }
                    this.fCurrentState = 10;
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return true;
                }
                case 4: {
                    if (byArray2[++n] != 93 || byArray2[n + 1] != 62) continue block16;
                    this.fCurrentEntity.offset = this.fCurrentOffset = --n;
                    return this.reportFatalError(5);
                }
                case 5: {
                    continue block16;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    if (this.fIsXML10) {
                        byArray = normalizedContentMap;
                    }
                    ++n;
                    continue block16;
                }
                case 7: {
                    int n2 = this.fCurrentOffset;
                    this.fCurrentOffset = n;
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && (byArray2[n] & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                        n = this.fCurrentOffset;
                        this.fCurrentOffset = n2;
                        xMLString.flags |= 8;
                        continue block16;
                    }
                    if (this.skippedValidChar()) {
                        n = this.fCurrentOffset;
                        this.fCurrentOffset = n2;
                        continue block16;
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 8: {
                    if (n == this.fEndOffset) {
                        if (n > this.fCurrentOffset) {
                            xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
                            this.fCurrentEntity.offset = this.fCurrentOffset = n;
                            this.fCurrentState = 6;
                            if (!this.fHelper.produceCharactersEvent()) {
                                return false;
                            }
                        }
                        if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                            int n3 = this.fCurrentState & 0xC;
                            if (n3 != 0 && this.fCurrentEntity.unbuffered != ((n3 & 8) == 0)) {
                                this.fCurrentState ^= 0xC;
                            }
                            return this.fHelper.continueAfterEndOfEntity();
                        }
                        return this.reportFatalError(19);
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset = n;
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 9: {
                    if (!this.fIsXML10) break;
                    ++n;
                    continue block16;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            ++n;
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = n;
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    public boolean scanElementContentUnbuffered(XMLString xMLString) {
        int n = this.fCurrentOffset;
        xMLString.flags = 2;
        while (normalizedElementContentMap[this.fData[n] & 0xFF] == 5) {
            if (this.fData[n] == 13) {
                ++n;
                if (this.fLineBreaksNormalized) continue;
                xMLString.flags |= 4;
                if (this.fIsXML10 || (this.fData[n] & 0xFF) != 194 || (this.fData[n + 1] & 0xFF) != 133) continue;
                xMLString.flags |= 8;
                n += 2;
                continue;
            }
            while (elementContentMap[this.fData[++n] & 0xFF] == 5) {
            }
        }
        this.fThisByte = this.fData[n];
        if (n > this.fCurrentOffset) {
            xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
            this.fCurrentOffset = n;
            this.fCurrentEntity.offset = n;
            this.fCurrentState = 6;
            if (!this.fHelper.produceWhitespaceEvent()) {
                if (this.fThisByte == 60) {
                    switch (markupMap[this.fData[n + 1] & 0xFF]) {
                        case 1: {
                            this.fCurrentState = 4;
                            break;
                        }
                        case 2: {
                            this.fCurrentState = 5;
                            break;
                        }
                        default: {
                            this.fCurrentState = 16;
                            break;
                        }
                    }
                } else {
                    this.fCurrentState = 6;
                }
                return false;
            }
            if (this.fData[n] != 60) {
                xMLString = this.fHelper.contentToProduce();
                xMLString.flags = 0;
            }
        }
        if (this.fData[n] == 60) {
            return this.scanMarkupUnbuffered();
        }
        return this.scanElementContentUnbuffered2(xMLString);
    }

    private boolean scanElementContentUnbuffered2(XMLString xMLString) {
        byte[] byArray = this.fLineBreaksNormalized ? normalizedElementContentMap : elementContentMap;
        byte[] byArray2 = this.fData;
        int n = this.fCurrentOffset;
        xMLString.flags = 2;
        block11: while (true) {
            if (byArray[byArray2[n] & 0xFF] == 5) {
                ++n;
                continue;
            }
            switch (byArray[byArray2[n] & 0xFF]) {
                case 1: {
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 6;
                    return this.scanContentUnbuffered2(xMLString, n);
                }
                case 2: {
                    if (n > this.fCurrentOffset) {
                        xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset = n;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            return false;
                        }
                    }
                    this.fCurrentState = 16;
                    return this.scanMarkupUnbuffered();
                }
                case 3: {
                    if (n > this.fCurrentOffset) {
                        xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
                        this.fCurrentOffset = n;
                        this.fCurrentEntity.offset = n;
                        this.fCurrentState = 6;
                        if (!this.fHelper.produceWhitespaceEvent()) {
                            return false;
                        }
                    }
                    this.fCurrentOffset = n + 1;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    this.fCurrentState = 6;
                    if (!this.checkReferenceInContent()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return false;
                    }
                    if (this.fCurrentEntity.unbuffered) {
                        xMLString = this.fHelper.contentToProduce();
                        xMLString.flags = 0;
                        byArray2 = this.fData;
                        n = this.fCurrentOffset;
                        continue block11;
                    }
                    this.fCurrentState = 10;
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return true;
                }
                case 4: {
                    if (byArray2[++n] == 93 && byArray2[n + 1] == 62) {
                        this.fCurrentEntity.offset = this.fCurrentOffset = --n;
                        return this.reportFatalError(5);
                    }
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 6;
                    return this.scanContentUnbuffered2(xMLString, n);
                }
                case 5: {
                    continue block11;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    if (this.fIsXML10) {
                        byArray = normalizedElementContentMap;
                    }
                    ++n;
                    continue block11;
                }
                case 7: {
                    int n2 = this.fCurrentOffset;
                    this.fCurrentOffset = n;
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && (byArray2[n] & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                        n = this.fCurrentOffset;
                        this.fCurrentOffset = n2;
                        xMLString.flags |= 8;
                        continue block11;
                    }
                    if (this.skippedValidChar()) {
                        n = this.fCurrentOffset;
                        this.fCurrentOffset = n2;
                        xMLString.flags &= 0xFFFFFFFD;
                        xMLString.flags |= 1;
                        this.fCurrentState = 6;
                        return this.scanContentUnbuffered2(xMLString, n);
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 8: {
                    if (n == this.fEndOffset) {
                        if (n > this.fCurrentOffset) {
                            xMLString.setValues(this.fCurrentBuffer, this.fCurrentOffset, n, xMLString.flags);
                            this.fCurrentEntity.offset = this.fCurrentOffset = n;
                            this.fCurrentState = 6;
                            if (!this.fHelper.produceWhitespaceEvent()) {
                                return false;
                            }
                        }
                        if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                            int n3 = this.fCurrentState & 0xC;
                            if (n3 != 0 && this.fCurrentEntity.unbuffered != ((n3 & 8) == 0)) {
                                this.fCurrentState ^= 0xC;
                            }
                            return this.fHelper.continueAfterEndOfEntity();
                        }
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        return this.reportFatalError(19);
                    }
                    this.fCurrentEntity.offset = this.fCurrentOffset = n;
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(2);
                }
                case 9: {
                    if (!this.fIsXML10) break block11;
                    xMLString.flags &= 0xFFFFFFFD;
                    xMLString.flags |= 1;
                    this.fCurrentState = 6;
                    return this.scanContentUnbuffered2(xMLString, n + 1);
                }
            }
            break;
        }
        if (!this.fIsXML10 && this.fCurrentEntity.isInternal) {
            xMLString.flags &= 0xFFFFFFFD;
            xMLString.flags |= 1;
            this.fCurrentState = 6;
            return this.scanContentUnbuffered2(xMLString, n + 1);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = n;
        this.setInvalidCharParameter(0);
        return this.reportFatalError(2);
    }

    private boolean scanMarkupUnbuffered() {
        byte by = this.fData[this.fCurrentOffset + 1];
        switch (markupMap[by & 0xFF]) {
            case 1: {
                this.fCurrentState = 4;
                return this.stateUnbufferedStartElement();
            }
            case 2: {
                this.fCurrentState = 5;
                return this.stateUnbufferedEndElement();
            }
            case 3: {
                this.nextByte();
                this.nextByte();
                this.fCurrentState = 6;
                return this.scanPI();
            }
            case 4: {
                this.nextByte();
                this.nextByte();
                if (this.skippedByte(45)) {
                    if (this.skippedByte(45)) {
                        this.fCurrentState = 6;
                        return this.scanComment();
                    }
                    return this.reportFatalError(27);
                }
                if (this.skippedBytes(CDSTART_BYTES)) {
                    this.fCurrentState = 6;
                    return this.scanStartCDSectUnbuffered();
                }
                return this.reportFatalError(19);
            }
        }
        return this.reportFatalError(19);
    }

    /*
     * Unable to fully structure code
     */
    public boolean scanStartElementUnbuffered() {
        var1_1 = this.fHelper.setupStartElement();
        this.fCurrentEntity.offset = this.fCurrentOffset + 1;
        var4_2 = this.fHelper.scanQName(this.fCurrentEntity, var1_1);
        if (this.setEntityLocals(this.fCurrentEntity) == 0) {
            this.checkForLoad();
        }
        var2_3 = this.fData;
        var3_4 = this.fCurrentOffset;
        switch (var4_2) {
            case 4: {
                var7_5 = false;
                var6_6 = true;
                ** GOTO lbl125
            }
            case 5: {
                var7_5 = false;
                var6_6 = false;
                ** GOTO lbl125
            }
            case 6: {
                while (true) {
                    if ((var5_7 = var2_3[var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                        ++var3_4;
                        continue;
                    }
                    v0 = var6_6 = var5_7 == 47;
                    if (!var6_6 && var5_7 != 62) ** GOTO lbl26
                    var7_5 = false;
                    ** GOTO lbl125
lbl26:
                    // 1 sources

                    if (!this.fIsXML10) ** GOTO lbl29
                    var7_5 = true;
                    ** GOTO lbl125
lbl29:
                    // 1 sources

                    if ((var5_7 & 255) == 194 && (var2_3[var3_4 + 1] & 255) == 133) {
                        var3_4 += 2;
                        continue;
                    }
                    if ((var5_7 & 255) != 226 || (var2_3[var3_4 + 1] & 255) != 128 || (var2_3[var3_4 + 2] & 255) != 168) break;
                    var3_4 += 3;
                }
                var7_5 = true;
                if (true) ** GOTO lbl125
            }
            case 2: 
            case 7: {
                this.fHelper.setParameter(0, var1_1);
                return this.reportFatalError(15);
            }
            default: {
                return this.reportFatalError(19);
            }
            case 1: {
                return this.reportFatalError(49);
            }
        }
        do {
            var8_8 = this.fHelper.currentAttributeName();
            this.fCurrentEntity.offset = this.fCurrentOffset = var3_4;
            var4_2 = this.fHelper.scanQName(this.fCurrentEntity, var8_8);
            if (this.setEntityLocals(this.fCurrentEntity) == 0) {
                this.checkForLoad();
            }
            var2_3 = this.fData;
            var3_4 = this.fCurrentOffset;
            block7 : switch (var4_2) {
                case 6: {
                    while (true) {
                        if ((var5_7 = var2_3[var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                            ++var3_4;
                            continue;
                        }
                        if (var5_7 == 61) ** GOTO lbl68
                        if (!this.fIsXML10 && (var5_7 & 255) == 194 && (var2_3[var3_4 + 1] & 255) == 133) {
                            var3_4 += 2;
                            continue;
                        }
                        if (this.fIsXML10 || (var5_7 & 255) != 226 || (var2_3[var3_4 + 1] & 255) != 128 || (var2_3[var3_4 + 2] & 255) != 168) break;
                        var3_4 += 3;
                    }
                    this.fHelper.setParameter(0, var1_1);
                    this.fHelper.setParameter(1, var8_8);
                    return this.reportFatalError(16);
                }
lbl68:
                // 2 sources

                case 7: {
                    ++var3_4;
                    while (true) {
                        if ((var5_7 = var2_3[var3_4]) == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                            ++var3_4;
                            continue;
                        }
                        if (var5_7 == 34 || var5_7 == 39) {
                            var11_11 = var5_7;
                            break block7;
                        }
                        if (!this.fIsXML10 && (var5_7 & 255) == 194 && (var2_3[var3_4 + 1] & 255) == 133) {
                            var3_4 += 2;
                            continue;
                        }
                        if (this.fIsXML10 || (var5_7 & 255) != 226 || (var2_3[var3_4 + 1] & 255) != 128 || (var2_3[var3_4 + 2] & 255) != 168) break;
                        var3_4 += 3;
                    }
                    this.fHelper.setParameter(0, var1_1);
                    this.fHelper.setParameter(1, var8_8);
                    return this.reportFatalError(24);
                }
                case 2: 
                case 4: 
                case 5: {
                    this.fHelper.setParameter(0, var1_1);
                    this.fHelper.setParameter(1, var8_8);
                    return this.reportFatalError(16);
                }
                default: {
                    this.fHelper.setParameter(0, var1_1);
                    return this.reportFatalError(15);
                }
                case 1: {
                    return this.reportFatalError(49);
                }
            }
            var9_9 = this.fHelper.setupSpecifiedAttribute();
            this.fCurrentOffset = var3_4 + 1;
            if (!this.scanAttValueUnbuffered(var9_9, var11_11)) {
                return false;
            }
            var2_3 = this.fData;
            var3_4 = this.fCurrentOffset;
            if (!this.fHelper.addSpecifiedAttribute()) {
                return false;
            }
            var10_10 = false;
            while (true) {
                v1 = var6_6 = (var5_7 = var2_3[var3_4]) == 47;
                if (var6_6 || var5_7 == 62) {
                    var7_5 = false;
                    break;
                }
                if (var5_7 == 32 || var5_7 == 10 || var5_7 == 9 || var5_7 == 13) {
                    var10_10 = true;
                    ++var3_4;
                    continue;
                }
                if (this.fIsXML10) break;
                if (!this.fIsXML10 && (var5_7 & 255) == 194 && (var2_3[var3_4 + 1] & 255) == 133) {
                    var10_10 = true;
                    var3_4 += 2;
                    continue;
                }
                if (this.fIsXML10 || (var5_7 & 255) != 226 || (var2_3[var3_4 + 1] & 255) != 128 || (var2_3[var3_4 + 2] & 255) != 168) break;
                var10_10 = true;
                var3_4 += 3;
            }
            if (!var7_5 || var10_10) continue;
            this.fHelper.setParameter(0, var1_1);
            return this.reportFatalError(15);
lbl125:
            // 6 sources

        } while (var7_5);
        if (var6_6) {
            if (var2_3[var3_4 + 1] == 62) {
                this.fCurrentEntity.offset = this.fCurrentOffset = var3_4 + 2;
                return this.fHelper.finishEmptyElement();
            }
            this.fHelper.setParameter(0, var1_1);
            return this.reportFatalError(15);
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = var3_4 + 1;
        return this.fHelper.finishStartElement();
    }

    private boolean scanAttValueUnbuffered(XMLString xMLString, int n) {
        int n2;
        byte[] byArray = attValueMap;
        byte[] byArray2 = this.fData;
        int n3 = n2 = this.fCurrentOffset;
        boolean bl = true;
        int n4 = this.fDTDSupport != null ? this.fDTDSupport.entityDepth() : 0;
        int n5 = 0;
        block10: while (true) {
            if (byArray[byArray2[n2] & 0xFF] == 1) {
                ++n2;
                continue;
            }
            switch (byArray[byArray2[n2] & 0xFF]) {
                case 2: {
                    if ((n4 == 0 || this.fDTDSupport != null && this.fDTDSupport.entityDepth() == n4) && byArray2[n2] == n) {
                        if (n2 > n3) {
                            this.setValues(xMLString, n3, n2, n5);
                            this.fHelper.attributeValueCharacters(xMLString, bl);
                        }
                        if (xMLString == this.fAttValueChars) {
                            this.fAttValueChars.clear();
                        }
                        this.fCurrentOffset = n2 + 1;
                        return true;
                    }
                    ++n2;
                    continue block10;
                }
                case 3: {
                    this.fCurrentOffset = n2;
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n5);
                        this.fHelper.attributeValueCharacters(xMLString, bl);
                        if (xMLString != this.fAttValueChars) {
                            this.fAttValueChars.clear();
                            this.fHelper.attributeValueCharacters(this.fAttValueChars, true);
                        }
                        xMLString = this.fAttValueChars;
                        bl = true;
                        n5 = 0;
                    }
                    ++this.fCurrentOffset;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    if (!this.checkReferenceInAttValue()) {
                        return false;
                    }
                    if (this.fCurrentEntity.unbuffered) {
                        byArray2 = this.fData;
                        n3 = n2 = this.fCurrentOffset;
                        continue block10;
                    }
                    return this.scanAttValueBuffered(xMLString, n, n4);
                }
                case 4: {
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n5);
                        this.fHelper.attributeValueCharacters(xMLString, bl);
                    }
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    return this.reportFatalError(25);
                }
                case 5: {
                    bl = false;
                    ++n2;
                    continue block10;
                }
                case 6: {
                    if (!this.fLineBreaksNormalized) {
                        n5 |= 4;
                    }
                    bl = false;
                    ++n2;
                    continue block10;
                }
                case 7: {
                    this.fCurrentOffset = n2;
                    if (this.fIsXML10 && this.skippedValidChar()) {
                        n2 = this.fCurrentOffset;
                        continue block10;
                    }
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && (byArray2[n2] & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                        n5 |= 8;
                        bl = false;
                    } else if (this.fIsXML10 || !this.skippedValidChar()) {
                        if (n2 > n3) {
                            this.setValues(xMLString, n3, n2, n5);
                            this.fHelper.attributeValueCharacters(xMLString, bl);
                        }
                        this.fHelper.setParameter(0, this.fHelper.currentElementType());
                        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                        this.setInvalidCharParameter(2);
                        return this.reportFatalError(21);
                    }
                    n2 = this.fCurrentOffset;
                    continue block10;
                }
                case 8: {
                    if (n2 > n3) {
                        this.setValues(xMLString, n3, n2, n5);
                        this.fHelper.attributeValueCharacters(xMLString, bl);
                        xMLString = this.fAttValueChars;
                        bl = true;
                        n5 = 0;
                    }
                    if (n2 == this.fEndOffset) {
                        this.fCurrentOffset = n2;
                        if (this.fDTDSupport != null && this.fDTDSupport.endOfEntity(1)) {
                            int n6 = this.fCurrentState & 0xC;
                            if (n6 != 0 && this.fCurrentEntity.unbuffered != ((n6 & 8) == 0)) {
                                this.fCurrentState ^= 0xC;
                            }
                            byArray2 = this.fData;
                            n3 = n2 = this.fCurrentOffset;
                            continue block10;
                        }
                        this.fHelper.setParameter(0, this.fHelper.currentElementType());
                        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                        return this.reportFatalError(26);
                    }
                    this.fCurrentOffset = n2;
                    this.fHelper.setParameter(0, this.fHelper.currentElementType());
                    this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
                    this.setInvalidCharParameter(2);
                    return this.reportFatalError(21);
                }
                case 9: {
                    if (!this.fIsXML10) break;
                    ++n2;
                    continue block10;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            ++n2;
        }
        this.fCurrentOffset = n2;
        this.fHelper.setParameter(0, this.fHelper.currentElementType());
        this.fHelper.setParameter(1, this.fHelper.currentAttributeName());
        this.setInvalidCharParameter(2);
        return this.reportFatalError(21);
    }

    public boolean scanEndElementUnbuffered() {
        QName qName = this.fHelper.popElement();
        this.fCurrentOffset += 2;
        this.fThisByte = this.fData[this.fCurrentOffset];
        if (qName != null) {
            int n;
            byte[] byArray;
            block8: {
                byArray = this.fData;
                int n2 = this.fCurrentOffset;
                byte[] byArray2 = qName.bytes;
                int n3 = qName.length;
                n = n2 + n3;
                int n4 = qName.endOffset - 1;
                int n5 = n - 1;
                if (byArray2 != null && n <= this.fEndOffset) {
                    while (byArray2[n4] == byArray[n5]) {
                        if (n5-- > n2) {
                            --n4;
                            continue;
                        }
                        break block8;
                    }
                    return this.scanEndElementNoMatch(qName);
                }
                return this.scanEndElementUnbuffered2(qName);
            }
            while (true) {
                byte by;
                if ((by = byArray[n]) == 62) {
                    this.fCurrentOffset = n + 1;
                    this.fThisByte = this.fData[this.fCurrentOffset];
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.finishEndElementUnbuffered(this.fHelper.elementDepth());
                    return this.fHelper.produceEndElementEvent(qName);
                }
                if (by == 32 || by == 10 || by == 9 || by == 13) {
                    ++n;
                    continue;
                }
                if (!this.fIsXML10 && (by & 0xFF) == 194 && (byArray[n + 1] & 0xFF) == 133) {
                    n += 2;
                    continue;
                }
                if (this.fIsXML10 || (by & 0xFF) != 226 || (byArray[n + 1] & 0xFF) != 128 || (byArray[n + 2] & 0xFF) != 168) break;
                n += 3;
            }
            this.fHelper.setParameter(0, qName);
            return this.reportFatalError(18);
        }
        this.fHelper.setParameter(0, this.fHelper.topElement());
        return this.reportFatalError(20);
    }

    private boolean scanEndElementUnbuffered2(QName qName) {
        boolean bl = qName.bytes != null ? this.skippedBytesInRange(qName.bytes, qName.startOffset, qName.endOffset) : this.skippedBytesBuffered2(qName.firstBuffer, qName.lastBuffer, qName.startOffset, qName.endOffset);
        int n = this.fCurrentOffset;
        while (bl) {
            byte by = this.fData[n];
            if (by == 62) {
                this.fCurrentOffset = n + 1;
                this.fThisByte = this.fData[this.fCurrentOffset];
                this.fCurrentEntity.offset = this.fCurrentOffset;
                this.finishEndElementUnbuffered(this.fHelper.elementDepth());
                return this.fHelper.produceEndElementEvent(qName);
            }
            if (by == 32 || by == 10 || by == 9 || by == 13) {
                ++n;
                continue;
            }
            if (!this.fIsXML10 && (by & 0xFF) == 194 && (this.fData[n + 1] & 0xFF) == 133) {
                n += 2;
                continue;
            }
            if (!this.fIsXML10 && (by & 0xFF) == 226 && (this.fData[n + 1] & 0xFF) == 128 && (this.fData[n + 2] & 0xFF) == 168) {
                n += 3;
                continue;
            }
            this.fHelper.setParameter(0, qName);
            return this.reportFatalError(18);
        }
        return this.scanEndElementNoMatch(qName);
    }

    private boolean scanEndElementNoMatch(QName qName) {
        this.scanQName(this.fTempQName);
        this.fHelper.setParameter(0, this.fTempQName);
        this.fHelper.setParameter(1, qName);
        return this.reportFatalError(14);
    }

    private boolean scanStartCDSectUnbuffered() {
        this.fCurrentEntity.offset = this.fCurrentOffset;
        this.fCurrentState = 13;
        if (!this.fHelper.produceStartCDATASectionEvent()) {
            return false;
        }
        return this.scanCDSectUnbuffered();
    }

    private boolean scanCDSectUnbuffered() {
        int n;
        byte[] byArray = cdSectMap;
        byte[] byArray2 = this.fData;
        int n2 = n = this.fCurrentOffset;
        XMLString xMLString = this.fHelper.contentToProduce();
        xMLString.flags = 0;
        byte by = byArray2[n];
        block6: while (true) {
            if (byArray[by & 0xFF] == 1) {
                by = byArray2[++n];
                continue;
            }
            switch (byArray[by & 0xFF]) {
                case 2: {
                    by = byArray2[++n];
                    do {
                        if (by != 93) continue block6;
                    } while ((by = byArray2[++n]) != 62);
                    this.fCurrentOffset = n - 2;
                    if (this.fCurrentOffset > n2) {
                        xMLString.setValues(this.fCurrentBuffer, n2, this.fCurrentOffset, xMLString.flags);
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        if (!this.fHelper.produceCharactersEvent()) {
                            this.fCurrentState = 15;
                            return false;
                        }
                    }
                    return this.stateUnbufferedEndCDSect();
                }
                case 3: {
                    if (!this.fLineBreaksNormalized) {
                        xMLString.flags |= 4;
                    }
                    by = byArray2[++n];
                    continue block6;
                }
                case 4: {
                    this.fCurrentOffset = n;
                    if (this.fIsXML10 && this.skippedValidChar()) {
                        n = this.fCurrentOffset;
                        by = byArray2[n];
                        continue block6;
                    }
                    if (!this.fIsXML10 && !this.fLineBreaksNormalized && (byArray2[n] & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                        xMLString.flags |= 8;
                    } else if (this.fIsXML10 || !this.skippedValidChar()) {
                        this.fCurrentEntity.offset = this.fCurrentOffset;
                        this.setInvalidCharParameter(0);
                        return this.reportFatalError(1);
                    }
                    n = this.fCurrentOffset;
                    by = byArray2[n];
                    continue block6;
                }
                case 5: {
                    if (n != this.fEndOffset) break;
                    this.fCurrentEntity.offset = this.fCurrentOffset = n;
                    return this.reportFatalError(6);
                }
            }
            if ((!this.fIsXML10 || byArray[by & 0xFF] != 6) && (this.fIsXML10 || !this.fCurrentEntity.isInternal || byArray[by & 0xFF] != 0)) break;
            by = byArray2[++n];
        }
        this.fCurrentEntity.offset = this.fCurrentOffset = n;
        this.setInvalidCharParameter(0);
        return this.reportFatalError(1);
    }

    private boolean scanTrailingMisc() {
        while (true) {
            if (this.fEndOfEntity) {
                if (this.fDTDSupport != null) {
                    this.fDTDSupport.endOfEntity(0);
                    this.fCurrentEntity = null;
                } else if (this.fCurrentEntity != null) {
                    this.fCurrentEntity.release();
                    this.fCurrentEntity = null;
                }
                return this.endDocument();
            }
            if (this.skippedSpaces()) continue;
            if (this.skippedByte(60)) {
                if (this.skippedByte(63)) {
                    if (this.scanPI()) continue;
                    return false;
                }
                if (this.skippedByte(33)) {
                    if (this.skippedByte(45)) {
                        if (this.skippedByte(45)) {
                            if (this.scanComment()) continue;
                            return false;
                        }
                        return this.reportFatalError(27);
                    }
                    return this.reportFatalError(12);
                }
                return this.reportFatalError(12);
            }
            if (this.skippedByte(38)) {
                return this.reportFatalError(12);
            }
            if (!this.fEndOfEntity) break;
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(3);
    }

    private boolean scanPI() {
        XMLString xMLString = this.fHelper.targetToProduce();
        int n = this.scanNCName(xMLString);
        switch (n) {
            case 0: {
                return this.reportFatalError(30);
            }
            case 2: 
            case 6: {
                if (!DocumentEntityScanner.reservedPITarget(xMLString)) {
                    XMLString xMLString2 = this.fHelper.contentToProduce();
                    if (n == 6) {
                        this.skipSpaces();
                        if (this.scanPIData(xMLString2)) {
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            return this.fHelper.produceProcessingInstructionEvent();
                        }
                        return false;
                    }
                    if (!this.skippedBytes(PI_END_BYTES)) break;
                    this.startString(xMLString2);
                    this.endString(xMLString2);
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return this.fHelper.produceProcessingInstructionEvent();
                }
                return this.reportFatalError(33);
            }
        }
        return this.reportFatalError(31);
    }

    protected static boolean reservedPITarget(XMLString xMLString) {
        if (xMLString.length == 3) {
            byte[] byArray = xMLString.bytes;
            int n = xMLString.startOffset;
            if (byArray != null) {
                return !(byArray[n + 0] != 120 && byArray[n + 0] != 88 || byArray[n + 1] != 109 && byArray[n + 1] != 77 || byArray[n + 2] != 108 && byArray[n + 2] != 76);
            }
            int n2 = xMLString.firstBuffer.endOffset;
            byArray = xMLString.firstBuffer.bytes;
            if (byArray[n] == 120 || byArray[n] == 88) {
                if (++n == n2) {
                    byArray = xMLString.lastBuffer.bytes;
                    n = xMLString.lastBuffer.startOffset;
                    n2 = xMLString.endOffset;
                }
                if (byArray[n] == 109 || byArray[n] == 77) {
                    if (++n == n2) {
                        byArray = xMLString.lastBuffer.bytes;
                        n = xMLString.lastBuffer.startOffset;
                        n2 = xMLString.endOffset;
                    }
                    return byArray[n] == 108 || byArray[n] == 76;
                }
            }
        }
        return false;
    }

    protected boolean scanPIData(XMLString xMLString) {
        this.startString(xMLString);
        block7: while (true) {
            this.skippedValidXMLBytesUsingMapForXMLString(piMap, 1, xMLString);
            switch (piMap[this.fThisByte & 0xFF]) {
                case 2: {
                    this.endStringWithFlags(xMLString, xMLString.flags);
                    this.nextByte();
                    if (this.skippedByte(62)) {
                        return true;
                    }
                    this.endStringUndo(xMLString);
                    continue block7;
                }
                case 3: {
                    UntestedCode.needTest("not reached");
                    this.nextByte();
                    continue block7;
                }
                case 4: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(23);
                }
                case 5: {
                    if (this.fEndOfEntity) {
                        return this.reportFatalError(32);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(23);
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.nextByte();
                    continue block7;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(23);
    }

    private boolean scanComment() {
        if (this.scanComment(this.fHelper.contentToProduce())) {
            this.fCurrentEntity.offset = this.fCurrentOffset;
            return this.fHelper.produceCommentEvent();
        }
        return false;
    }

    protected boolean scanComment(XMLString xMLString) {
        this.startString(xMLString);
        block7: while (true) {
            this.skippedValidXMLBytesUsingMapForXMLString(commentMap, 1, xMLString);
            switch (commentMap[this.fThisByte & 0xFF]) {
                case 2: {
                    this.endStringWithFlags(xMLString, xMLString.flags);
                    this.nextByte();
                    if (this.skippedByte(45)) {
                        if (this.skippedByte(62)) {
                            return true;
                        }
                        return this.reportFatalError(28);
                    }
                    this.endStringUndo(xMLString);
                    continue block7;
                }
                case 3: {
                    this.nextByte();
                    continue block7;
                }
                case 4: {
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(22);
                }
                case 5: {
                    if (this.fEndOfEntity) {
                        return this.reportFatalError(29);
                    }
                    this.setInvalidCharParameter(0);
                    return this.reportFatalError(22);
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.nextByte();
                    continue block7;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.nextByte();
        }
        this.setInvalidCharParameter(0);
        return this.reportFatalError(22);
    }

    protected int scanCharacterReference() {
        int n;
        boolean bl = false;
        this.startString(this.fHelper.entityNameToProduce());
        if (this.skippedByte(120)) {
            int n2 = digitMap[this.fThisByte & 0xFF];
            if (n2 < 0) {
                this.reportFatalError(36);
                return -1;
            }
            this.nextByte();
            n = n2;
            while (!this.skippedByte(59)) {
                n2 = digitMap[this.fThisByte & 0xFF];
                if (n2 < 0) {
                    this.reportFatalError(37);
                    return -1;
                }
                this.nextByte();
                if ((n = (n << 4) + n2) <= 0x10FFFF) continue;
                bl = true;
                n = 0;
            }
        } else {
            int n3 = digitMap[this.fThisByte & 0xFF];
            if (n3 < 0 || n3 > 9) {
                this.reportFatalError(35);
                return -1;
            }
            this.nextByte();
            n = n3;
            while (!this.skippedByte(59)) {
                n3 = digitMap[this.fThisByte & 0xFF];
                if (n3 < 0 || n3 > 9) {
                    this.reportFatalError(37);
                    return -1;
                }
                this.nextByte();
                if ((n = n * 10 + n3) <= 0x10FFFF) continue;
                bl = true;
                n = 0;
            }
        }
        if (!bl) {
            if (n < 55296) {
                bl = n < 32 && n != 10 && n != 9 && n != 13;
            } else {
                boolean bl2 = bl = n < 57344 || n >= 65534 && n < 65536 || n >= 0x110000;
            }
            if (!bl || !this.fIsXML10 && n < 32 && n != 0) {
                this.fHelper.entityNameToProduce().clear();
                return n;
            }
        }
        this.endString(this.fHelper.entityNameToProduce());
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        this.reportFatalError(38);
        return -1;
    }

    private static int checkPredefinedEntities(XMLString xMLString) {
        byte[] byArray = xMLString.firstBuffer.bytes;
        int n = xMLString.startOffset;
        int n2 = xMLString.length;
        switch (byArray[n] + n2) {
            case 110: {
                if (byArray[n + 1] != 116) break;
                return 60;
            }
            case 105: {
                if (byArray[n + 1] != 116) break;
                return 62;
            }
            case 100: {
                if (byArray[n + 1] != 109 || byArray[n + 2] != 112) break;
                return 38;
            }
            case 101: {
                if (byArray[n + 1] != 112 || byArray[n + 2] != 111 || byArray[n + 3] != 115) break;
                return 39;
            }
            case 117: {
                if (byArray[n + 1] != 117 || byArray[n + 2] != 111 || byArray[n + 3] != 116) break;
                return 34;
            }
            default: {
                return -1;
            }
        }
        if (n2 >= 2 && n2 <= 4 && xMLString.bytes == null) {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            switch (byArray[n] + n2) {
                case 110: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 116) break;
                    return 60;
                }
                case 105: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 116) break;
                    return 62;
                }
                case 100: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 109) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 112) break;
                    return 38;
                }
                case 101: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 112) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 111) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 115) break;
                    return 39;
                }
                case 117: {
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 117) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 111) break;
                    if (dataBuffer.bytes[++n] == 0) {
                        dataBuffer = dataBuffer.next;
                        n = dataBuffer.startOffset;
                    }
                    if (dataBuffer.bytes[n] != 116) break;
                    return 34;
                }
            }
        }
        return -1;
    }

    private boolean checkReferenceInContent() {
        if (this.skippedByte(35)) {
            int n = this.scanCharacterReference();
            if (n != -1) {
                this.fCurrentEntity.offset = this.fCurrentOffset;
                return this.fHelper.produceCharacterEvent(n);
            }
            return false;
        }
        int n = this.scanNCName(this.fHelper.entityNameToProduce());
        if (n == 8) {
            this.nextByte();
            return this.entityReferenceInContent();
        }
        if (n == 0) {
            return this.reportFatalError(39);
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        return this.reportFatalError(40);
    }

    private boolean entityReferenceInContent() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.entityReferenceInContent();
        }
        int n = DocumentEntityScanner.checkPredefinedEntities(this.fHelper.entityNameToProduce());
        if (n != -1) {
            this.fCurrentEntity.offset = this.fCurrentOffset;
            return this.fHelper.producePredefinedEntityEvent(n);
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        return this.reportFatalError(47);
    }

    private boolean checkReferenceInAttValue() {
        if (this.skippedByte(35)) {
            int n = this.scanCharacterReference();
            if (n != -1) {
                this.fHelper.attributeValueCharacter(n, false);
                return true;
            }
            return false;
        }
        int n = this.scanNCName(this.fHelper.entityNameToProduce());
        if (n == 8) {
            this.nextByte();
            return this.entityReferenceInAttValue();
        }
        if (n == 0) {
            this.reportFatalError(39);
            return false;
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        this.reportFatalError(40);
        return false;
    }

    private boolean entityReferenceInAttValue() {
        if (this.fDTDSupport != null) {
            return this.fDTDSupport.entityReferenceInAttValue();
        }
        int n = DocumentEntityScanner.checkPredefinedEntities(this.fHelper.entityNameToProduce());
        if (n != -1) {
            this.fHelper.attributeValueCharacter(n, true);
            return true;
        }
        this.fHelper.setParameter(0, this.fHelper.entityNameToProduce());
        return this.reportFatalError(47);
    }

    public boolean skipContentBuffered(XMLString xMLString) {
        this.fSkippedElementDepth = 0;
        this.startString(xMLString);
        xMLString.flags = 0;
        this.setMark(this.fCurrentOffset);
        block6: while (true) {
            if (this.fThisByte == 60) {
                int n = this.fData[this.fCurrentOffset + 1];
                if (n == 0 && this.fCurrentOffset + 1 == this.fEndOffset) {
                    this.setMark(this.fCurrentOffset);
                    n = this.nextByte();
                    this.resetToMark();
                }
                switch (markupMap[n & 0xFF]) {
                    case 1: {
                        this.nextByte();
                        if (this.skipStartElementBuffered(xMLString)) continue block6;
                        this.resetToMark();
                        return false;
                    }
                    case 2: {
                        if (this.fSkippedElementDepth == 0) {
                            this.endStringWithFlags(xMLString, xMLString.flags);
                            this.fCurrentEntity.offset = this.fCurrentOffset;
                            this.fCurrentEntity.clearMark();
                            return true;
                        }
                        this.nextByte();
                        this.nextByte();
                        if (this.skipEndElementBuffered(xMLString)) continue block6;
                        this.resetToMark();
                        return false;
                    }
                    case 3: {
                        this.nextByte();
                        this.nextByte();
                        if (this.skipPIBuffered(xMLString)) continue block6;
                        this.resetToMark();
                        return false;
                    }
                    case 4: {
                        this.nextByte();
                        this.nextByte();
                        if (!(this.skippedByte(45) ? this.skippedByte(45) && this.skipCommentBuffered(xMLString) : this.skippedBytes(CDSTART_BYTES) && this.skipCDSectBuffered(xMLString))) break;
                        continue block6;
                    }
                }
                this.resetToMark();
                return false;
            }
            if (!this.fLineBreaksNormalized) {
                if (this.fThisByte == 13) {
                    xMLString.flags |= 4;
                    this.nextByte();
                    continue;
                }
                if (!this.fIsXML10 && (this.fThisByte & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                    xMLString.flags |= 8;
                    continue;
                }
            }
            if (this.fThisByte == 0) break;
            this.nextByte();
        }
        this.resetToMark();
        return false;
    }

    private boolean skipStartElementBuffered(XMLString xMLString) {
        while (true) {
            int n;
            if ((n = this.fThisByte) == 62) {
                ++this.fSkippedElementDepth;
                return true;
            }
            if (n == 47) {
                this.nextByte();
                return this.skippedByte(62);
            }
            if (n == 34 || n == 39) {
                this.nextByte();
                if (this.skipToChar(n)) {
                    this.nextByte();
                    continue;
                }
                return false;
            }
            if (!this.fLineBreaksNormalized) {
                if (this.fThisByte == 13) {
                    xMLString.flags |= 4;
                    this.nextByte();
                    continue;
                }
                if (!this.fIsXML10 && (this.fThisByte & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                    xMLString.flags |= 8;
                    continue;
                }
            }
            if (n == 0) break;
            this.nextByte();
        }
        return false;
    }

    private boolean skipEndElementBuffered(XMLString xMLString) {
        while (true) {
            if (this.fThisByte == 62) {
                --this.fSkippedElementDepth;
                return true;
            }
            if (!this.fLineBreaksNormalized) {
                if (this.fThisByte == 13) {
                    xMLString.flags |= 4;
                    this.nextByte();
                    continue;
                }
                if (!this.fIsXML10 && (this.fThisByte & 0xDF) == 194 && this.skippedXML11EOLChar()) {
                    xMLString.flags |= 8;
                    continue;
                }
            }
            if (this.fThisByte == 0) break;
            this.nextByte();
        }
        return false;
    }

    private boolean skipPIBuffered(XMLString xMLString) {
        block6: while (true) {
            this.skippedValidXMLBytesUsingMapForXMLString(piMap, 1, xMLString);
            switch (piMap[this.fThisByte & 0xFF]) {
                case 2: {
                    this.nextByte();
                    if (!this.skippedByte(62)) continue block6;
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    return true;
                }
                case 3: {
                    UntestedCode.needTest("not reached");
                    this.nextByte();
                    continue block6;
                }
                case 4: 
                case 5: {
                    return false;
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.nextByte();
                    continue block6;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.nextByte();
        }
        return false;
    }

    private boolean skipCommentBuffered(XMLString xMLString) {
        block6: while (true) {
            this.skippedValidXMLBytesUsingMapForXMLString(commentMap, 1, xMLString);
            switch (commentMap[this.fThisByte & 0xFF]) {
                case 2: {
                    this.nextByte();
                    if (!this.skippedByte(45)) continue block6;
                    return this.skippedByte(62);
                }
                case 3: {
                    UntestedCode.needTest("not reached");
                    this.nextByte();
                    continue block6;
                }
                case 4: 
                case 5: {
                    return false;
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.nextByte();
                    continue block6;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.nextByte();
        }
        return false;
    }

    private boolean skipCDSectBuffered(XMLString xMLString) {
        block6: while (true) {
            this.skippedValidXMLBytesUsingMapForXMLString(cdSectMap, 1, xMLString);
            switch (cdSectMap[this.fThisByte & 0xFF]) {
                case 2: {
                    if (this.skippedBytes(CDEND_BYTES)) {
                        return true;
                    }
                    this.nextByte();
                    continue block6;
                }
                case 3: {
                    UntestedCode.needTest("not reached");
                    this.nextByte();
                    continue block6;
                }
                case 4: 
                case 5: {
                    return false;
                }
                case 6: {
                    if (!this.fIsXML10) break;
                    this.nextByte();
                    continue block6;
                }
            }
            if (this.fIsXML10 || !this.fCurrentEntity.isInternal) break;
            this.nextByte();
        }
        return false;
    }

    public boolean skipContentUnbuffered(XMLString xMLString) {
        this.fSkippedElementDepth = 0;
        this.startString(xMLString);
        this.setMark(this.fCurrentOffset);
        byte[] byArray = this.fData;
        int n = this.fCurrentOffset;
        byte by = byArray[n];
        while (true) {
            if (by == 60) {
                if ((by = byArray[++n]) == 47 && this.fSkippedElementDepth == 0) {
                    this.fCurrentOffset = n - 1;
                    this.endStringWithFlags(xMLString, xMLString.flags);
                    this.fCurrentEntity.offset = this.fCurrentOffset;
                    this.fCurrentEntity.clearMark();
                    return true;
                }
                if ((n = this.skipMarkupUnbuffered(byArray, n, by, xMLString)) == 0) {
                    this.resetToMark();
                    return false;
                }
                by = byArray[n];
                continue;
            }
            if (!this.fLineBreaksNormalized) {
                if (by == 13) {
                    xMLString.flags |= 4;
                    by = byArray[++n];
                    continue;
                }
                if (!this.fIsXML10) {
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        by = byArray[n += 2];
                        continue;
                    }
                    if ((by & 0xFF) == 226 && byArray[n + 1] == 128 && byArray[n + 2] == 168) {
                        xMLString.flags |= 8;
                        by = byArray[n += 3];
                        continue;
                    }
                }
            }
            if (by == 0) break;
            by = byArray[++n];
        }
        return false;
    }

    private int skipMarkupUnbuffered(byte[] byArray, int n, int n2, XMLString xMLString) {
        byte[] byArray2 = markupMap;
        byte by = n2 >= 0 ? byArray2[n2] : (byte)1;
        switch (by) {
            case 1: {
                return this.skipStartElementUnbuffered(byArray, n, xMLString);
            }
            case 2: {
                return this.skipEndElementUnbuffered(byArray, n + 1, xMLString);
            }
            case 3: {
                return this.skipPIUnbuffered(byArray, n + 1, xMLString);
            }
            case 4: {
                n2 = byArray[n + 1];
                if (n2 == 45) {
                    if (byArray[n + 2] != 45) {
                        return 0;
                    }
                    return this.skipCommentUnbuffered(byArray, n + 3, xMLString);
                }
                if (n2 == 91 && byArray[n + 2] == 67 && byArray[n + 3] == 68 && byArray[n + 4] == 65 && byArray[n + 5] == 84 && byArray[n + 6] == 65 && byArray[n + 7] == 91) {
                    return this.skipCDSectUnbuffered(byArray, n + 8, xMLString);
                }
                return 0;
            }
        }
        return 0;
    }

    private int skipStartElementUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (true) {
            if (by == 62) {
                ++this.fSkippedElementDepth;
                return n + 1;
            }
            if (by == 47) {
                if (byArray[n + 1] == 62) {
                    return n + 2;
                }
                return 0;
            }
            if (by == 34 || by == 39) {
                byte by2 = by;
                while ((by = byArray[++n]) != by2) {
                    if (by == 0) {
                        return 0;
                    }
                    if (this.fLineBreaksNormalized) continue;
                    if (by == 13) {
                        xMLString.flags |= 4;
                        continue;
                    }
                    if (this.fIsXML10) continue;
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        ++n;
                        continue;
                    }
                    if ((by & 0xFF) != 226 || byArray[n + 1] != 128 || byArray[n + 2] != 168) continue;
                    xMLString.flags |= 8;
                    n += 2;
                }
            } else if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized) {
                if (by == 13) {
                    xMLString.flags |= 4;
                } else if (!this.fIsXML10) {
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        ++n;
                    } else if ((by & 0xFF) == 226 && byArray[n + 1] == 128 && byArray[n + 2] == 168) {
                        xMLString.flags |= 8;
                        n += 2;
                    }
                }
            }
            by = byArray[++n];
        }
    }

    private int skipEndElementUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (true) {
            if (by == 62) {
                --this.fSkippedElementDepth;
                return n + 1;
            }
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized) {
                if (by == 13) {
                    xMLString.flags |= 4;
                } else if (!this.fIsXML10) {
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        ++n;
                    } else if ((by & 0xFF) == 226 && byArray[n + 1] == 128 && byArray[n + 2] == 168) {
                        xMLString.flags |= 8;
                        n += 2;
                    }
                }
            }
            by = byArray[++n];
        }
    }

    private int skipPIUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (by != 63 || byArray[n + 1] != 62) {
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized) {
                if (by == 13) {
                    xMLString.flags |= 4;
                } else if (!this.fIsXML10) {
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        ++n;
                    } else if ((by & 0xFF) == 226 && byArray[n + 1] == 128 && byArray[n + 2] == 168) {
                        xMLString.flags |= 8;
                        n += 2;
                    }
                }
            }
            by = byArray[++n];
        }
        return n + 2;
    }

    private int skipCommentUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (true) {
            if (by == 45 && byArray[n + 1] == 45) {
                if (byArray[n + 2] == 62) {
                    return n + 3;
                }
                return 0;
            }
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized) {
                if (by == 13) {
                    xMLString.flags |= 4;
                } else if (!this.fIsXML10) {
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        ++n;
                    } else if ((by & 0xFF) == 226 && byArray[n + 1] == 128 && byArray[n + 2] == 168) {
                        xMLString.flags |= 8;
                        n += 2;
                    }
                }
            }
            by = byArray[++n];
        }
    }

    private int skipCDSectUnbuffered(byte[] byArray, int n, XMLString xMLString) {
        byte by = byArray[n];
        while (by != 93 || byArray[n + 1] != 93 || byArray[n + 2] != 62) {
            if (by == 0) {
                return 0;
            }
            if (!this.fLineBreaksNormalized) {
                if (by == 13) {
                    xMLString.flags |= 4;
                } else if (!this.fIsXML10) {
                    if ((by & 0xFF) == 194 && byArray[n + 1] == 133) {
                        xMLString.flags |= 8;
                        ++n;
                    } else if ((by & 0xFF) == 226 && byArray[n + 1] == 128 && byArray[n + 2] == 168) {
                        xMLString.flags |= 8;
                        n += 2;
                    }
                }
            }
            by = byArray[++n];
        }
        return n + 3;
    }

    public static interface DTDSupport {
        public void setDocumentEntity(ParsedEntity var1);

        public void setStandalone();

        public boolean endOfEntity(int var1);

        public int entityDepth();

        public boolean scanDoctypeDecl(ParsedEntity var1);

        public boolean scanInternalDTDSubset();

        public boolean scanExternalDTDSubset();

        public boolean hasDefaultAttributes();

        public boolean addDefaultAttributes(QName var1, NSDeclList var2, AttrList var3, boolean var4);

        public boolean entityReferenceInContent();

        public boolean entityReferenceInAttValue();
    }
}

