/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.lang.ref.SoftReference;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderManager {
    private static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final XMLReaderManager m_singletonManager = new XMLReaderManager();
    private static SAXParserFactory m_parserFactory;
    private ThreadLocal m_readers;

    private XMLReaderManager() {
    }

    public static XMLReaderManager getInstance() {
        return m_singletonManager;
    }

    public synchronized XMLReader getXMLReader() throws SAXException {
        boolean bl;
        XMLReader xMLReader = this.acquireThisThreadsReader();
        boolean bl2 = bl = xMLReader != null;
        if (!bl) {
            try {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader();
                }
                catch (Exception exception) {
                    if (m_parserFactory == null) {
                        m_parserFactory = SAXParserFactory.newInstance();
                        m_parserFactory.setNamespaceAware(true);
                    }
                    xMLReader = m_parserFactory.newSAXParser().getXMLReader();
                }
                try {
                    xMLReader.setFeature(NAMESPACES_FEATURE, true);
                    xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                }
                catch (SAXException sAXException) {}
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (this.getThisThreadsReader() == null) {
                this.setThisThreadsReader(xMLReader);
            }
        }
        return xMLReader;
    }

    public synchronized void releaseXMLReader(XMLReader xMLReader) {
        if (xMLReader != null && this.getThisThreadsReader() == xMLReader) {
            ((ReservableSoftReference)this.m_readers.get()).release();
        }
    }

    private XMLReader getThisThreadsReader() {
        XMLReader xMLReader = null;
        if (this.m_readers == null) {
            this.m_readers = new ThreadLocal();
        } else {
            ReservableSoftReference reservableSoftReference = (ReservableSoftReference)this.m_readers.get();
            if (reservableSoftReference != null) {
                xMLReader = (XMLReader)reservableSoftReference.get();
            }
        }
        return xMLReader;
    }

    private XMLReader acquireThisThreadsReader() {
        XMLReader xMLReader = null;
        if (this.m_readers == null) {
            this.m_readers = new ThreadLocal();
        } else {
            ReservableSoftReference reservableSoftReference = (ReservableSoftReference)this.m_readers.get();
            if (reservableSoftReference != null && reservableSoftReference.isAvailable()) {
                xMLReader = (XMLReader)reservableSoftReference.get();
                reservableSoftReference.reserve();
            }
        }
        return xMLReader;
    }

    private void setThisThreadsReader(XMLReader xMLReader) {
        if (xMLReader != null) {
            ReservableSoftReference reservableSoftReference = new ReservableSoftReference(xMLReader);
            this.m_readers.set(reservableSoftReference);
        }
    }

    private static class ReservableSoftReference
    extends SoftReference {
        private boolean m_inUse = true;

        public ReservableSoftReference(Object object) {
            super(object);
        }

        public boolean isAvailable() {
            return !this.m_inUse;
        }

        public void reserve() {
            this.m_inUse = true;
        }

        public void release() {
            this.m_inUse = false;
        }
    }
}

