/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.Duration2;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.Duration;
import org.apache.xerces.jaxp.datatype.AbstractDurationImpl;
import org.apache.xerces.jaxp.datatype.SerializedDuration;
import org.apache.xerces.util.DatatypeMessageFormatter;

final class LightweightDurationImpl
extends AbstractDurationImpl
implements Serializable {
    private static final long serialVersionUID = -1423382419642387690L;
    private final int sign;
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;

    private static int getSign(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!(n != Integer.MIN_VALUE && n != 0 || n2 != Integer.MIN_VALUE && n2 != 0 || n3 != Integer.MIN_VALUE && n3 != 0 || n4 != Integer.MIN_VALUE && n4 != 0 || n5 != Integer.MIN_VALUE && n5 != 0 || n6 != Integer.MIN_VALUE && n6 != 0)) {
            return 0;
        }
        return bl ? 1 : -1;
    }

    public LightweightDurationImpl(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        this(LightweightDurationImpl.getSign(bl, n, n2, n3, n4, n5, n6), n, n2, n3, n4, n5, n6);
    }

    public LightweightDurationImpl(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.sign = LightweightDurationImpl.getSign(bl, n, n2, n3, n4, n5, n6);
        this.years = n;
        this.months = n2;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = n6;
    }

    public LightweightDurationImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.sign = n;
        if (n2 != Integer.MIN_VALUE && n2 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{Integer.toString(n2)}));
        }
        this.years = n2;
        if (n3 != Integer.MIN_VALUE && n3 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{Integer.toString(n3)}));
        }
        this.months = n3;
        if (n4 != Integer.MIN_VALUE && n4 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{Integer.toString(n4)}));
        }
        this.days = n4;
        if (n5 != Integer.MIN_VALUE && n5 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{Integer.toString(n5)}));
        }
        this.hours = n5;
        if (n6 != Integer.MIN_VALUE && n6 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{Integer.toString(n6)}));
        }
        this.minutes = n6;
        if (n7 != Integer.MIN_VALUE && n7 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{Integer.toString(n7)}));
        }
        this.seconds = n7;
    }

    BigInteger getYearsField() {
        return this.years != Integer.MIN_VALUE ? BigInteger.valueOf(this.years) : null;
    }

    BigInteger getMonthsField() {
        return this.months != Integer.MIN_VALUE ? BigInteger.valueOf(this.months) : null;
    }

    BigInteger getDaysField() {
        return this.days != Integer.MIN_VALUE ? BigInteger.valueOf(this.days) : null;
    }

    BigInteger getHoursField() {
        return this.hours != Integer.MIN_VALUE ? BigInteger.valueOf(this.hours) : null;
    }

    BigInteger getMinutesField() {
        return this.minutes != Integer.MIN_VALUE ? BigInteger.valueOf(this.minutes) : null;
    }

    BigDecimal getSecondsField() {
        return this.seconds != Integer.MIN_VALUE ? BigDecimal.valueOf(this.seconds) : null;
    }

    public int getYears() {
        return this.years != Integer.MIN_VALUE ? this.years : 0;
    }

    public int getMonths() {
        return this.months != Integer.MIN_VALUE ? this.months : 0;
    }

    public int getDays() {
        return this.days != Integer.MIN_VALUE ? this.days : 0;
    }

    public int getHours() {
        return this.hours != Integer.MIN_VALUE ? this.hours : 0;
    }

    public int getMinutes() {
        return this.minutes != Integer.MIN_VALUE ? this.minutes : 0;
    }

    public int getSeconds() {
        return this.seconds != Integer.MIN_VALUE ? this.seconds : 0;
    }

    public int getSign() {
        return this.sign;
    }

    boolean isYearsSet() {
        return this.years != Integer.MIN_VALUE;
    }

    boolean isMonthsSet() {
        return this.months != Integer.MIN_VALUE;
    }

    boolean isDaysSet() {
        return this.days != Integer.MIN_VALUE;
    }

    boolean isHoursSet() {
        return this.hours != Integer.MIN_VALUE;
    }

    boolean isMinutesSet() {
        return this.minutes != Integer.MIN_VALUE;
    }

    boolean isSecondsSet() {
        return this.seconds != Integer.MIN_VALUE;
    }

    public Duration multiply(int n) {
        int n2;
        int n3 = Math.abs(n);
        int n4 = n2 = n3 != 0 ? Integer.MAX_VALUE / n3 : Integer.MAX_VALUE;
        if (!(this.years != Integer.MIN_VALUE && this.years > n2 || this.months != Integer.MIN_VALUE && this.months > n2 || this.days != Integer.MIN_VALUE && this.days > n2 || this.hours != Integer.MIN_VALUE && this.hours > n2 || this.minutes != Integer.MIN_VALUE && this.minutes > n2 || this.seconds != Integer.MIN_VALUE && this.seconds > n2)) {
            int n5 = n > 0 ? 1 : (n < 0 ? -1 : 0);
            return new LightweightDurationImpl(this.sign * n5, this.years != Integer.MIN_VALUE ? this.years * n3 : Integer.MIN_VALUE, this.months != Integer.MIN_VALUE ? this.months * n3 : Integer.MIN_VALUE, this.days != Integer.MIN_VALUE ? this.days * n3 : Integer.MIN_VALUE, this.hours != Integer.MIN_VALUE ? this.hours * n3 : Integer.MIN_VALUE, this.minutes != Integer.MIN_VALUE ? this.minutes * n3 : Integer.MIN_VALUE, this.seconds != Integer.MIN_VALUE ? this.seconds * n3 : Integer.MIN_VALUE);
        }
        return super.multiply(n);
    }

    public Duration negate() {
        return new LightweightDurationImpl(-this.sign, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public Duration normalizeWith(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, this.sign * this.getYears());
        calendar2.add(2, this.sign * this.getMonths());
        calendar2.add(5, this.sign * this.getDays());
        long l = calendar2.getTime().getTime() - calendar.getTime().getTime();
        int n = (int)(l / 86400000L);
        int n2 = 1;
        if (!(n != 0 || this.hours != Integer.MIN_VALUE && this.hours != 0 || this.minutes != Integer.MIN_VALUE && this.minutes != 0 || this.seconds != Integer.MIN_VALUE && this.seconds != 0)) {
            n2 = 0;
        } else if (n < 0) {
            n2 = -1;
        }
        return new LightweightDurationImpl(n2, Integer.MIN_VALUE, Integer.MIN_VALUE, Math.abs(n), this.hours, this.minutes, this.seconds);
    }

    public String toString() {
        char[] cArray = new char[16];
        int n = 0;
        if (this.sign == -1) {
            cArray[n++] = 45;
        }
        cArray[n++] = 80;
        if (this.years != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n += LightweightDurationImpl.getCharLength(this.years)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n, this.years);
            cArray[n++] = 89;
        }
        if (this.months != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n += LightweightDurationImpl.getCharLength(this.months)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n, this.months);
            cArray[n++] = 77;
        }
        if (this.days != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n += LightweightDurationImpl.getCharLength(this.days)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n, this.days);
            cArray[n++] = 68;
        }
        if (this.hours != Integer.MIN_VALUE || this.minutes != Integer.MIN_VALUE || this.seconds != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, n + 1);
            cArray[n++] = 84;
            if (this.hours != Integer.MIN_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n += LightweightDurationImpl.getCharLength(this.hours)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n, this.hours);
                cArray[n++] = 72;
            }
            if (this.minutes != Integer.MIN_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n += LightweightDurationImpl.getCharLength(this.minutes)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n, this.minutes);
                cArray[n++] = 77;
            }
            if (this.seconds != Integer.MIN_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n += LightweightDurationImpl.getCharLength(this.seconds)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n, this.seconds);
                cArray[n++] = 83;
            }
        }
        return new String(cArray, 0, n);
    }

    private static void writeIntToBuffer(char[] cArray, int n, int n2) {
        do {
            int n3 = n2 / 10;
            int n4 = n2 - (n3 << 3) - (n3 << 1);
            n2 = n3;
            cArray[--n] = (char)(n4 + 48);
        } while (n2 > 0);
    }

    private static void writeLongToBuffer(char[] cArray, int n, long l) {
        do {
            long l2 = l / 10L;
            long l3 = l - (l2 << 3) - (l2 << 1);
            l = l2;
            cArray[--n] = (char)(l3 + 48L);
        } while (l > 0L);
    }

    private static int getCharLength(int n) {
        if (n < 10) {
            return 1;
        }
        if (n < 100) {
            return 2;
        }
        if (n < 1000) {
            return 3;
        }
        if (n < 10000) {
            return 4;
        }
        if (n < 100000) {
            return 5;
        }
        if (n < 1000000) {
            return 6;
        }
        if (n < 10000000) {
            return 7;
        }
        if (n < 100000000) {
            return 8;
        }
        if (n < 1000000000) {
            return 9;
        }
        return 10;
    }

    private static char[] ensureBufferCapacity(char[] cArray, int n) {
        if (n > cArray.length) {
            char[] cArray2 = new char[n << 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            return cArray2;
        }
        return cArray;
    }

    BigDecimal[] createBigDecimalArray() {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this.years != Integer.MIN_VALUE ? BigDecimal.valueOf(this.years) : AbstractDurationImpl.ZERO, this.months != Integer.MIN_VALUE ? BigDecimal.valueOf(this.months) : AbstractDurationImpl.ZERO, this.days != Integer.MIN_VALUE ? BigDecimal.valueOf(this.days) : AbstractDurationImpl.ZERO, this.hours != Integer.MIN_VALUE ? BigDecimal.valueOf(this.hours) : AbstractDurationImpl.ZERO, this.minutes != Integer.MIN_VALUE ? BigDecimal.valueOf(this.minutes) : AbstractDurationImpl.ZERO, this.seconds != Integer.MIN_VALUE ? BigDecimal.valueOf(this.seconds) : AbstractDurationImpl.ZERO};
        return bigDecimalArray;
    }

    private Object writeReplace() throws IOException {
        return new SerializedDuration(this.toString());
    }

    public boolean areFieldsPrimitive() {
        return true;
    }

    public boolean hasFractionalSeconds() {
        return false;
    }

    public Duration2 asDurationYearMonth() {
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return AbstractDurationImpl.ZERO_MONTHS;
        }
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return this;
        }
        return new LightweightDurationImpl(this.sign >= 0, this.years, this.months, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public Duration2 asDurationDayTime() {
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return AbstractDurationImpl.ZERO_SECONDS;
        }
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return this;
        }
        return new LightweightDurationImpl(this.sign >= 0, Integer.MIN_VALUE, Integer.MIN_VALUE, this.days, this.hours, this.minutes, this.seconds);
    }

    public String toFOFormat() {
        int n;
        int n2;
        long l;
        int n3;
        int n4;
        if (this.sign == 0) {
            return this.toZeroDurationFOStringFormat();
        }
        if (this.seconds != Integer.MIN_VALUE) {
            n4 = this.seconds % 60;
            n3 = this.seconds / 60;
        } else {
            n4 = 0;
            n3 = 0;
        }
        int n5 = 0;
        int n6 = 0;
        if (this.minutes != Integer.MIN_VALUE) {
            if (this.minutes > Integer.MAX_VALUE - n3) {
                long l2 = (long)this.minutes + (long)n3;
                n5 = (int)(l2 % 60L);
                n6 = (int)(l2 / 60L);
            } else {
                int n7 = this.minutes + n3;
                n5 = n7 % 60;
                n6 = n7 / 60;
            }
        } else if (n3 > 0) {
            n5 = n3 % 60;
            n6 = n3 / 60;
        }
        int n8 = 0;
        int n9 = 0;
        if (this.hours != Integer.MIN_VALUE) {
            if (this.hours > Integer.MAX_VALUE - n6) {
                l = (long)this.hours + (long)n6;
                n8 = (int)(l % 24L);
                n9 = (int)(l / 24L);
            } else {
                int n10 = this.hours + n6;
                n8 = n10 % 24;
                n9 = n10 / 24;
            }
        } else if (n6 > 0) {
            n8 = n6 % 24;
            n9 = n6 / 24;
        }
        l = 0L;
        l = this.days != Integer.MIN_VALUE ? (long)this.days + (long)n9 : (long)n9;
        if (this.months != Integer.MIN_VALUE) {
            n2 = this.months % 12;
            n = this.months / 12;
        } else {
            n2 = 0;
            n = 0;
        }
        long l3 = this.years != Integer.MIN_VALUE ? (long)this.years + (long)n : (long)n;
        char[] cArray = new char[16];
        int n11 = 0;
        if (this.sign == -1) {
            cArray[n11++] = 45;
        }
        cArray[n11++] = 80;
        if (l3 > 0L) {
            if (l3 <= Integer.MAX_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += LightweightDurationImpl.getCharLength((int)l3)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n11, (int)l3);
            } else {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += 10) + 1);
                LightweightDurationImpl.writeLongToBuffer(cArray, n11, l3);
            }
            cArray[n11++] = 89;
        }
        if (n2 > 0) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += LightweightDurationImpl.getCharLength(n2)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n11, n2);
            cArray[n11++] = 77;
        }
        if (l > 0L) {
            if (l <= Integer.MAX_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += LightweightDurationImpl.getCharLength((int)l)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n11, (int)l);
            } else {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += 10) + 1);
                LightweightDurationImpl.writeLongToBuffer(cArray, n11, l);
            }
            cArray[n11++] = 68;
        }
        if (n8 > 0 || n5 > 0 || n4 > 0) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, n11 + 1);
            cArray[n11++] = 84;
            if (n8 > 0) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += LightweightDurationImpl.getCharLength(n8)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n11, n8);
                cArray[n11++] = 72;
            }
            if (n5 > 0) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += LightweightDurationImpl.getCharLength(n5)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n11, n5);
                cArray[n11++] = 77;
            }
            if (n4 > 0) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n11 += LightweightDurationImpl.getCharLength(n4)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n11, n4);
                cArray[n11++] = 83;
            }
        }
        return new String(cArray, 0, n11);
    }
}

