/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xalan.xslt.SecuritySupport;

final class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xalan.properties";
    private static final String SERVICES_PATH = "META-INF/services/";
    private static final boolean DEBUG = false;
    private static Properties fXalanProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        Class clazz = ObjectFactory.lookUpFactoryClass(string, string2, string3);
        if (clazz == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        try {
            Object t = clazz.newInstance();
            return t;
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider for factory " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Class lookUpFactoryClass(String string) throws ConfigurationError {
        return ObjectFactory.lookUpFactoryClass(string, null, null);
    }

    static Class lookUpFactoryClass(String string, String string2, String string3) throws ConfigurationError {
        String string4 = ObjectFactory.lookUpFactoryClassName(string, string2, string3);
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        if (string4 == null) {
            string4 = string3;
        }
        try {
            Class clazz = ObjectFactory.findProviderClass(string4, classLoader, true);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string4 + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string4 + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String lookUpFactoryClassName(String string, String string2, String string3) {
        String string4;
        try {
            string4 = SecuritySupport.getSystemProperty(string);
            if (string4 != null) {
                return string4;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string4 = null;
        if (string2 == null) {
            Object object;
            File file = null;
            boolean bl = false;
            try {
                object = SecuritySupport.getSystemProperty("java.home");
                string2 = (String)object + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                file = new File(string2);
                bl = SecuritySupport.getFileExists(file);
            }
            catch (SecurityException securityException) {
                fLastModified = -1L;
                fXalanProperties = null;
            }
            object = ObjectFactory.class;
            synchronized (ObjectFactory.class) {
                boolean bl2 = false;
                FileInputStream fileInputStream = null;
                try {
                    if (fLastModified >= 0L) {
                        if (bl && fLastModified < (fLastModified = SecuritySupport.getLastModified(file))) {
                            bl2 = true;
                        } else if (!bl) {
                            fLastModified = -1L;
                            fXalanProperties = null;
                        }
                    } else if (bl) {
                        bl2 = true;
                        fLastModified = SecuritySupport.getLastModified(file);
                    }
                    if (bl2) {
                        fXalanProperties = new Properties();
                        fileInputStream = SecuritySupport.getFileInputStream(file);
                        fXalanProperties.load(fileInputStream);
                    }
                }
                catch (Exception exception) {
                    fXalanProperties = null;
                    fLastModified = -1L;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                // ** MonitorExit[var6_12] (shouldn't be in output)
                if (fXalanProperties != null) {
                    string4 = fXalanProperties.getProperty(string);
                }
            }
        } else {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = SecuritySupport.getFileInputStream(new File(string2));
                Properties properties = new Properties();
                properties.load(fileInputStream);
                string4 = properties.getProperty(string);
            }
            catch (Exception exception) {
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        {
            if (string4 != null) {
                return string4;
            }
            return ObjectFactory.findJarServiceProviderName(string);
        }
    }

    private static void debugPrintln(String string) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        ClassLoader classLoader2 = SecuritySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = SecuritySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                ClassLoader classLoader4 = ObjectFactory.class.getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n = string.lastIndexOf(".");
            String string2 = string;
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            securityManager.checkPackageAccess(string2);
        }
        if (classLoader == null) {
            clazz = Class.forName(string);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    ClassLoader classLoader2 = ObjectFactory.class.getClassLoader();
                    if (classLoader2 == null) {
                        clazz = Class.forName(string);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findJarServiceProviderName(String string) {
        Object object;
        String string2 = SERVICES_PATH + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null && classLoader != (object = ObjectFactory.class.getClassLoader())) {
            classLoader = object;
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            String string4 = null;
            return string4;
        }
        finally {
            try {
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
        }
        if (string3 != null && !"".equals(string3)) {
            return string3;
        }
        return null;
    }

    static class ConfigurationError
    extends Error {
        static final long serialVersionUID = 2276082712114762609L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

