/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.AutomatonInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import java.util.HashSet;

public class InliningOptimizer
extends Optimizer {
    @Override
    protected Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            Function function = functionCallInstruction.getInstantiation().m_function;
            if (InliningOptimizer.isCandidateForInline(function)) {
                Instruction instruction2 = OptimizerUtilities.replaceDeconstructionBindings(functionCallInstruction.m_parameters, function.m_parameters, function.getBody());
                return this.doTypeCheck(instruction, instruction2.cloneWithoutTypeInformation(), instruction.getBindingEnvironment());
            }
        }
        return instruction;
    }

    public static boolean isCandidateForInline(Function function) {
        if (!(function.getBody() instanceof AutomatonInstruction)) {
            if (function.m_parameters.length == 1) {
                return true;
            }
            HashSet hashSet = new HashSet();
            function.getBody().accumulateFunctionsCalled(hashSet);
            hashSet.remove(function.getName());
            if (hashSet.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

