/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.xslt.jaxp.StAX2SAX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class STAXStream2SAX
extends StAX2SAX {
    private XMLStreamReader m_streamReader = null;

    public STAXStream2SAX(XMLStreamReader xMLStreamReader) {
        this.m_streamReader = xMLStreamReader;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            if (this.m_streamReader != null && this.m_streamReader.hasNext()) {
                this.parse(this.m_streamReader, this.m_streamReader.getEventType());
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    private void parse(XMLStreamReader xMLStreamReader, int n) throws IOException, SAXException {
        try {
            switch (n) {
                case 7: {
                    this.setLocation(xMLStreamReader.getLocation());
                    this.getContentHandler().setDocumentLocator(this);
                    this.getContentHandler().startDocument();
                    while (xMLStreamReader.hasNext()) {
                        this.parse(xMLStreamReader, xMLStreamReader.next());
                    }
                    this.getContentHandler().endDocument();
                    break;
                }
                case 4: 
                case 6: {
                    String string = xMLStreamReader.getText();
                    this.getContentHandler().characters(string.toCharArray(), 0, string.length());
                    break;
                }
                case 12: {
                    int n2 = xMLStreamReader.getTextLength();
                    char[] cArray = new char[n2];
                    xMLStreamReader.getTextCharacters(xMLStreamReader.getTextStart(), cArray, 0, n2);
                    if (this.getLexicalHandler() != null) {
                        this.getLexicalHandler().startCDATA();
                        this.getContentHandler().characters(cArray, 0, cArray.length);
                        this.getLexicalHandler().endCDATA();
                        break;
                    }
                    this.getContentHandler().characters(cArray, 0, cArray.length);
                    break;
                }
                case 1: {
                    int n3;
                    String string;
                    String string2;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    AttributesImpl attributesImpl = new AttributesImpl();
                    int n4 = xMLStreamReader.getNamespaceCount();
                    for (int i = 0; i < n4; ++i) {
                        string2 = xMLStreamReader.getNamespaceURI(i);
                        string = xMLStreamReader.getNamespacePrefix(i);
                        if (!this.startPrefixMapping(string, string2)) continue;
                        arrayList.add(string);
                    }
                    String string3 = xMLStreamReader.getNamespaceURI();
                    string2 = xMLStreamReader.getLocalName();
                    string = xMLStreamReader.getPrefix();
                    if (string3 != null && !string3.equals("") && this.startPrefixMapping(string, string3)) {
                        arrayList.add(string);
                    }
                    String string4 = string == null || string.equals("") ? string2 : string + ":" + string2;
                    this.getContentHandler().startElement(string3, string2, string4, this);
                    while (xMLStreamReader.hasNext() && (n3 = xMLStreamReader.next()) != 2) {
                        this.parse(xMLStreamReader, n3);
                    }
                    this.getContentHandler().endElement(string3, string2, string4);
                    int n5 = arrayList.size();
                    for (int i = 0; i < n5; ++i) {
                        this.endPrefixMapping((String)arrayList.get(i));
                    }
                    break;
                }
                case 5: {
                    if (this.getLexicalHandler() == null) break;
                    int n6 = xMLStreamReader.getTextLength();
                    char[] cArray = new char[n6];
                    xMLStreamReader.getTextCharacters(xMLStreamReader.getTextStart(), cArray, 0, n6);
                    this.getLexicalHandler().comment(cArray, 0, n6);
                    break;
                }
                case 3: {
                    this.getContentHandler().processingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                    break;
                }
                case 11: {
                    if (this.getDTDHandler() == null) break;
                    List list = (List)xMLStreamReader.getProperty("javax.xml.stream.entities");
                    for (XMLEvent xMLEvent : list) {
                        if (xMLEvent.getEventType() != 15) continue;
                        EntityDeclaration entityDeclaration = (EntityDeclaration)xMLEvent;
                        this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
                    }
                    break;
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    @Override
    public int getIndex(String string) {
        for (int i = 0; i < this.getLength(); ++i) {
            String string2;
            String string3 = this.m_streamReader.getAttributeLocalName(i);
            String string4 = this.m_streamReader.getAttributePrefix(i);
            String string5 = string2 = string4 == null || string4.equals("") ? string3 : string4 + ":" + string3;
            if (string2 == null || !string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String string, String string2) {
        for (int i = 0; i < this.getLength(); ++i) {
            String string3 = this.m_streamReader.getAttributeLocalName(i);
            String string4 = this.m_streamReader.getAttributeNamespace(i);
            if (string == null && string4 == null && string2 != null && string2.equals(string3)) {
                return i;
            }
            if (string4 == null || !string4.equals(string) || string3 == null || !string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.m_streamReader.getAttributeCount();
    }

    @Override
    public String getLocalName(int n) {
        return this.m_streamReader.getAttributeLocalName(n);
    }

    @Override
    public String getQName(int n) {
        String string = this.m_streamReader.getAttributePrefix(n);
        String string2 = this.m_streamReader.getAttributeLocalName(n);
        return string == null || string.equals("") ? string2 : string + ":" + string2;
    }

    @Override
    public String getType(int n) {
        return this.m_streamReader.getAttributeType(n);
    }

    @Override
    public String getType(String string) {
        int n = this.getIndex(string);
        return n > 0 ? this.getType(n) : null;
    }

    @Override
    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n > 0 ? this.getType(n) : null;
    }

    @Override
    public String getURI(int n) {
        return this.m_streamReader.getAttributeNamespace(n);
    }

    @Override
    public String getValue(int n) {
        return this.m_streamReader.getAttributeValue(n);
    }

    @Override
    public String getValue(String string) {
        int n = this.getIndex(string);
        return n > 0 ? this.getValue(n) : null;
    }

    @Override
    public String getValue(String string, String string2) {
        return this.m_streamReader.getAttributeValue(string, string2);
    }
}

