/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.common.utils.DOM2Helper;
import com.ibm.xtq.common.utils.TreeWalker;
import com.ibm.xtq.xml.dtm.DTMManager;
import com.ibm.xtq.xml.utils.StopParseException;
import com.ibm.xtq.xml.utils.StylesheetPIHandler;
import com.ibm.xtq.xml.utils.XMLReaderManager;
import com.ibm.xtq.xml.xdm.dtm.DTMClassCache;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.jaxp.AbstractTemplatesHandler;
import com.ibm.xtq.xslt.jaxp.DefaultErrorListener;
import com.ibm.xtq.xslt.jaxp.HandledRuntimeException;
import com.ibm.xtq.xslt.jaxp.ResultURIResolver;
import com.ibm.xtq.xslt.jaxp.ResultURIResolverDefaultImpl;
import com.ibm.xtq.xslt.jaxp.TemplatesImpl;
import com.ibm.xtq.xslt.jaxp.TrAXFilter;
import com.ibm.xtq.xslt.jaxp.TransformerHandlerImpl;
import com.ibm.xtq.xslt.jaxp.TransformerImpl;
import com.ibm.xtq.xslt.jaxp.Util;
import com.ibm.xtq.xslt.res.ErrorMsg;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXSource;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public abstract class AbstractTransformerFactory
extends SAXTransformerFactory
implements SourceLoader,
DTMClassCache {
    private HashMap _attributeValidators = new HashMap();
    private HashMap _attributeSettings = new HashMap();
    private ErrorListener _errorListener;
    private URIResolver _uriResolver = null;
    private ResultURIResolver _resultURIResolver = new ResultURIResolverDefaultImpl();
    protected static final String DEFAULT_TRANSLET_NAME = "GregorSamsa";
    private Hashtable _piParams = null;
    private boolean _isSecureProcessing = false;
    private Class m_DTMManagerClass = null;
    private Class m_schemaAwareDTMManagerClass = null;

    public AbstractTransformerFactory() {
        this.configureCommonAttributes();
        this._errorListener = new DefaultErrorListener();
    }

    private void configureCommonAttributes() {
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/debug", new BooleanAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/debug", false), Boolean.FALSE);
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/indent-number", new IntegerAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/indent-number", false), new Integer(-1));
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/xslt-version", new EnumerationAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/xslt-version", false, new Object[]{"1.0", "2.0"}), "1.0");
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/static-typing", new BooleanAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/static-typing", false), Boolean.FALSE);
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/stream-result-only", new BooleanAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/stream-result-only", false), Boolean.FALSE);
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/generate_bcel", new BooleanAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/generate_bcel", false), Boolean.TRUE);
        this.addAttribute("http://www.ibm.com/xmlns/xltxe-j/disable-setparameter", new BooleanAttrValidator("http://www.ibm.com/xmlns/xltxe-j/disable-setparameter", false), Boolean.FALSE);
        this.addAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/xml10-only", new BooleanAttrValidator("http://www.ibm.com/xmlns/prod/xltxe-j/xml10-only", false), Boolean.FALSE);
        this.addAttribute("debug", new BooleanAttrValidator("debug", true), Boolean.FALSE);
        this.addAttribute("indent-number", new IntegerAttrValidator("indent-number", true), new Integer(-1));
        this.addAttribute("xslt-version", new EnumerationAttrValidator("xslt-version", true, new Object[]{"1.0", "2.0"}), "1.0");
        this.addAttribute("static-typing", new BooleanAttrValidator("static-typing", true), Boolean.FALSE);
        this.addAttribute("stream-result-only", new BooleanAttrValidator("stream-result-only", true), Boolean.FALSE);
        this.addAttribute("generate_bcel", new BooleanAttrValidator("generate_bcel", true), Boolean.TRUE);
    }

    protected void addAttribute(String string, AttrValidator attrValidator, Object object) {
        this._attributeValidators.put(string, attrValidator);
        this._attributeSettings.put(attrValidator.validateName(string), object);
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERROR_LISTENER_NULL_ERR", "TransformerFactory");
            throw new IllegalArgumentException(errorMsg.toString());
        }
        this._errorListener = errorListener;
    }

    @Override
    public ErrorListener getErrorListener() {
        return this._errorListener;
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        AttrValidator attrValidator = (AttrValidator)this._attributeValidators.get(string);
        if (attrValidator != null) {
            return this._attributeSettings.get(attrValidator.validateName(string));
        }
        ErrorMsg errorMsg = new ErrorMsg("JAXP_INVALID_ATTR_ERR", string);
        throw new IllegalArgumentException(errorMsg.toString());
    }

    public boolean getBooleanAttribute(String string) throws IllegalArgumentException {
        return (Boolean)this.getAttribute(string);
    }

    public String getStringAttribute(String string) throws IllegalArgumentException {
        return (String)this.getAttribute(string);
    }

    public int getIntAttribute(String string) throws IllegalArgumentException {
        return (Integer)this.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        AttrValidator attrValidator = (AttrValidator)this._attributeValidators.get(string);
        if (attrValidator != null) {
            this._attributeSettings.put(attrValidator.validateName(string), attrValidator.validate(object));
            return;
        }
        ErrorMsg errorMsg = new ErrorMsg("JAXP_INVALID_ATTR_ERR", string);
        throw new IllegalArgumentException(errorMsg.toString());
    }

    @Override
    public boolean getFeature(String string) {
        if (string == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_GET_FEATURE_NULL_NAME");
            throw new NullPointerException(errorMsg.toString());
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this._isSecureProcessing;
        }
        String[] stringArray = new String[]{"http://javax.xml.transform.dom.DOMSource/feature", "http://javax.xml.transform.dom.DOMResult/feature", "http://javax.xml.transform.sax.SAXSource/feature", "http://javax.xml.transform.sax.SAXResult/feature", "http://javax.xml.transform.stream.StreamSource/feature", "http://javax.xml.transform.stream.StreamResult/feature", "http://javax.xml.transform.stax.StAXSource/feature", "http://javax.xml.transform.stax.StAXResult/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature", "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        if (string == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_SET_FEATURE_NULL_NAME");
            throw new NullPointerException(errorMsg.toString());
        }
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_UNSUPPORTED_FEATURE", string);
            throw new TransformerConfigurationException(errorMsg.toString());
        }
        this._isSecureProcessing = bl;
    }

    @Override
    public URIResolver getURIResolver() {
        return this._uriResolver;
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver;
    }

    public void setResultURIResolver(ResultURIResolver resultURIResolver) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        String string4;
        Object object;
        if (this._piParams == null) {
            this._piParams = new Hashtable();
        }
        this._piParams.put(source, new PIParamWrapper(string, string2, string3));
        InputSource inputSource = null;
        Node node = null;
        XMLReader xMLReader = null;
        if (source instanceof DOMSource) {
            object = (DOMSource)source;
            node = ((DOMSource)object).getNode();
            string4 = ((DOMSource)object).getSystemId();
        } else if (source instanceof StAXSource) {
            object = (StAXSource)source;
            string4 = ((StAXSource)object).getSystemId();
        } else {
            inputSource = SAXSource.sourceToInputSource(source);
            string4 = inputSource.getSystemId();
        }
        object = new StylesheetPIHandler(string4, string, string2, string3);
        if (this._uriResolver != null) {
            ((StylesheetPIHandler)object).setURIResolver(this._uriResolver);
        }
        try {
            if (null != node) {
                TreeWalker treeWalker = new TreeWalker((ContentHandler)object, new DOM2Helper(), string4);
                treeWalker.traverse(node);
            } else if (!(source instanceof StAXSource)) {
                xMLReader = XMLReaderManager.getInstance().getXMLReader(this._isSecureProcessing);
                xMLReader.setContentHandler((ContentHandler)object);
                xMLReader.parse(inputSource);
            } else {
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(source);
                while (true) {
                    int n;
                    if ((n = xMLStreamReader.next()) == 8) {
                        xMLStreamReader.close();
                        break;
                    }
                    if (n != 3) continue;
                    ((StylesheetPIHandler)object).processingInstruction(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                }
            }
            XMLReaderManager.getInstance().releaseXMLReader(xMLReader);
            return ((StylesheetPIHandler)object).getAssociatedStylesheet();
        }
        catch (StopParseException stopParseException) {
            return ((StylesheetPIHandler)object).getAssociatedStylesheet();
            catch (SAXException sAXException) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", sAXException);
                catch (IOException iOException) {
                    throw new TransformerConfigurationException("getAssociatedStylesheets failed", iOException);
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new TransformerConfigurationException("getAssociatedStylesheets failed", xMLStreamException);
                }
            }
        }
        finally {
            XMLReaderManager.getInstance().releaseXMLReader(xMLReader);
        }
    }

    protected PIParamWrapper getPIParams(Source source) {
        if (this._piParams != null) {
            PIParamWrapper pIParamWrapper = (PIParamWrapper)this._piParams.get(source);
            return pIParamWrapper;
        }
        return null;
    }

    @Override
    public Transformer newTransformer() throws TransformerConfigurationException {
        TransformerImpl transformerImpl = new TransformerImpl(this.getIntAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/indent-number"), this);
        if (this._uriResolver != null) {
            transformerImpl.setURIResolver(this._uriResolver);
        }
        return transformerImpl;
    }

    @Override
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = null;
        try {
            Templates templates = this.createTemplates(source);
            Transformer transformer = templates.newTransformer();
            if (this._uriResolver != null) {
                transformer.setURIResolver(this._uriResolver);
            }
            return transformer;
        }
        catch (HandledRuntimeException handledRuntimeException) {
            TransformerException transformerException = handledRuntimeException.getTransformerException();
            if (transformerException != null) {
                if (transformerException instanceof TransformerConfigurationException) {
                    throw (TransformerConfigurationException)transformerException;
                }
                throw new TransformerConfigurationException(transformerException);
            }
            transformerConfigurationException = new TransformerConfigurationException(handledRuntimeException);
        }
        catch (TransformerConfigurationException transformerConfigurationException2) {
            try {
                transformerConfigurationException = transformerConfigurationException2;
                this.getErrorListener().fatalError(transformerConfigurationException2);
            }
            catch (TransformerConfigurationException transformerConfigurationException3) {
                throw transformerConfigurationException3;
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        catch (Exception exception) {
            try {
                transformerConfigurationException = new TransformerConfigurationException(exception);
                this.getErrorListener().fatalError(transformerConfigurationException);
            }
            catch (TransformerConfigurationException transformerConfigurationException4) {
                throw transformerConfigurationException4;
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        throw transformerConfigurationException;
    }

    @Override
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = null;
        try {
            return this.createTemplates(source);
        }
        catch (HandledRuntimeException handledRuntimeException) {
            TransformerException transformerException = handledRuntimeException.getTransformerException();
            if (transformerException != null) {
                if (transformerException instanceof TransformerConfigurationException) {
                    throw (TransformerConfigurationException)transformerException;
                }
                throw new TransformerConfigurationException(transformerException);
            }
            transformerConfigurationException = new TransformerConfigurationException(handledRuntimeException);
        }
        catch (TransformerConfigurationException transformerConfigurationException2) {
            try {
                transformerConfigurationException = transformerConfigurationException2;
                this.getErrorListener().fatalError(transformerConfigurationException2);
                throw transformerConfigurationException2;
            }
            catch (TransformerConfigurationException transformerConfigurationException3) {
                throw transformerConfigurationException3;
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        catch (Exception exception) {
            try {
                transformerConfigurationException = new TransformerConfigurationException(exception);
                this.getErrorListener().fatalError(transformerConfigurationException);
                throw transformerConfigurationException;
            }
            catch (TransformerConfigurationException transformerConfigurationException4) {
                throw transformerConfigurationException4;
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
        }
        throw transformerConfigurationException;
    }

    public abstract Templates createTemplates(Source var1) throws Exception;

    @Override
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        AbstractTemplatesHandler abstractTemplatesHandler = this.createTemplatesHandler();
        if (this.getURIResolver() != null) {
            abstractTemplatesHandler.setURIResolver(this.getURIResolver());
        }
        return abstractTemplatesHandler;
    }

    public abstract AbstractTemplatesHandler createTemplatesHandler() throws TransformerConfigurationException;

    public abstract TemplatesImpl createTemplates(XSLTCompiler var1, String var2) throws TransformerConfigurationException;

    protected void passWarningsToListener(Vector vector) throws TransformerException {
        if (this._errorListener == null || vector == null) {
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = vector.elementAt(i).toString();
            this._errorListener.error(new TransformerConfigurationException(string));
        }
    }

    protected void passErrorsToListener(Vector vector) {
        try {
            if (this._errorListener == null || vector == null) {
                return;
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = vector.elementAt(i).toString();
                this._errorListener.error(new TransformerException(string));
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    @Override
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer();
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    @Override
    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Transformer transformer = this.newTransformer(source);
        if (this._uriResolver != null) {
            transformer.setURIResolver(this._uriResolver);
        }
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        TransformerImpl transformerImpl = (TransformerImpl)transformer;
        return new TransformerHandlerImpl(transformerImpl);
    }

    @Override
    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    @Override
    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this._errorListener != null) {
                try {
                    this._errorListener.fatalError(transformerConfigurationException);
                    return null;
                }
                catch (TransformerException transformerException) {
                    new TransformerConfigurationException(transformerException);
                }
            }
            throw transformerConfigurationException;
        }
    }

    @Override
    public InputSource loadSource(String string, String string2, XSLTParser xSLTParser) {
        try {
            Source source;
            if (this._uriResolver != null && (source = this._uriResolver.resolve(string, string2)) != null) {
                return Util.getInputSource(xSLTParser, source);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public synchronized XMLReader getXMLReader() throws Exception {
        return XMLReaderManager.getInstance().getXMLReader(this._isSecureProcessing);
    }

    protected String getStylesheetFileName(Source source) {
        String string = source.getSystemId();
        if (string != null) {
            File file = new File(string);
            if (file.exists()) {
                return string;
            }
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            if ("file".equals(uRL.getProtocol())) {
                return uRL.getFile();
            }
            return null;
        }
        return null;
    }

    @Override
    public Class getDTMManagerClass(boolean bl) {
        if (bl) {
            if (this.m_schemaAwareDTMManagerClass == null) {
                this.m_schemaAwareDTMManagerClass = DTMManager.getDTMManagerClass(true);
            }
            return this.m_schemaAwareDTMManagerClass;
        }
        if (this.m_DTMManagerClass == null) {
            this.m_DTMManagerClass = DTMManager.getDTMManagerClass(false);
        }
        return this.m_DTMManagerClass;
    }

    protected static class PIParamWrapper {
        public String _media = null;
        public String _title = null;
        public String _charset = null;

        public PIParamWrapper(String string, String string2, String string3) {
            this._media = string;
            this._title = string2;
            this._charset = string3;
        }
    }

    public static class EnumerationAttrValidator
    extends AttrValidator {
        private HashMap m_validValues;

        public EnumerationAttrValidator(String string, boolean bl, Object[] objectArray) {
            super(string, bl);
            this.m_validValues = new HashMap(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_validValues.put(objectArray[i], objectArray[i]);
            }
        }

        @Override
        protected Object validate(Object object) {
            Object v = this.m_validValues.get(object);
            if (v != null) {
                return v;
            }
            this.reportInvalidValue();
            return null;
        }
    }

    public static class IntegerAttrValidator
    extends AttrValidator {
        public IntegerAttrValidator(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        protected Object validate(Object object) {
            if (object instanceof Integer) {
                return object;
            }
            if (object instanceof String) {
                try {
                    return Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    this.reportInvalidValue();
                }
            } else {
                this.reportInvalidValue();
            }
            return null;
        }
    }

    public static class BooleanAttrValidator
    extends AttrValidator {
        public BooleanAttrValidator(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        protected Object validate(Object object) {
            if (object instanceof Boolean) {
                return object;
            }
            if (object instanceof String) {
                return Boolean.valueOf((String)object);
            }
            this.reportInvalidValue();
            return null;
        }
    }

    public static class StringAttrValidator
    extends AttrValidator {
        private boolean m_nullPermitted;

        public StringAttrValidator(String string, boolean bl) {
            this(string, bl, false);
        }

        public StringAttrValidator(String string, boolean bl, boolean bl2) {
            super(string, bl);
            this.m_nullPermitted = bl2;
        }

        @Override
        protected Object validate(Object object) {
            if (object instanceof String || object == null && this.m_nullPermitted) {
                return object;
            }
            this.reportInvalidValue();
            return null;
        }
    }

    public static abstract class AttrValidator {
        private String m_name;
        private boolean m_depricatedName;

        public AttrValidator(String string, boolean bl) {
            this.m_name = string;
            this.m_depricatedName = bl;
        }

        public String validateName(String string) {
            if (!this.m_depricatedName) {
                return string;
            }
            return "http://www.ibm.com/xmlns/prod/xltxe-j/" + string;
        }

        protected abstract Object validate(Object var1);

        final void reportInvalidValue() {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_ATTR_VAL_ERR", this.m_name);
            throw new IllegalArgumentException(errorMsg.toString());
        }
    }
}

