<!--
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 -->

NOTE! The files in this folder are generated by pre-commit based on airflow sources. They are not
supposed to be manually modified.

You can read more about pre-commit hooks [here](../contributing-docs/08_static_code_checks.rst#pre-commit-hooks).

* `provider_dependencies.json` - is generated based on `provider.yaml` files in `airflow/providers` and
  based on the imports in the provider code. If you want to add new dependency to a provider, you
  need to modify the corresponding `provider.yaml` file

* `provider_metadata.json` - is generated based on `provider.yaml` files, airflow constraints and tags for
  the providers. It contains historical metadata in providers that were released - it is useful to generate
  information in release notes and it is used to generate SBOM information for the providers. It is manually
  regenerated using `breeze release-management generate-providers-metadata` command."

* `PYPI_README.md` - is generated from the comprehensive `README.md` of the project, which contains exhaustive
  project details. Unlike the full `README.md`, `PYPI_README.md` is a distilled version tailored for PyPI,
  focusing on select sections. This subset is produced by the `generate-pypi-readme` pre-commit hook specified in
  the `.pre-commit-config.yaml` file. This hook triggers automatically whenever the related sections in the
  `README.md` change, ensuring alignment between the two files.

* `devel_deps.txt` is a file containing development-only dependencies of Airflow. They were generated
  for Airflow 2.9.3 by running `./dev/get_devel_deps.sh` script.
