/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.realm;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.realm.RegistryAuthorizationManager;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public class RegistryRealm
implements UserRealm {
    private static final Log log = LogFactory.getLog(RegistryRealm.class);
    private RegistryAuthorizationManager authorizationManager;
    private UserRealm coreRealm;

    public RegistryRealm() {
    }

    public RegistryRealm(UserRealm userRealm) throws RegistryException {
        this.initialize(userRealm);
    }

    private void initialize(UserRealm userRealm) throws RegistryException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Retrieving user manager components from the realm.");
        }
        this.authorizationManager = new RegistryAuthorizationManager(userRealm);
        this.coreRealm = userRealm;
    }

    public void init(RealmConfiguration configBean, Map<String, ClaimMapping> claimMapping, Map<String, ProfileConfiguration> profileConfigs, int tenantId) throws UserStoreException {
    }

    public void init(RealmConfiguration configBean, Map<String, Object> properties, int tenantId) throws UserStoreException {
    }

    public AuthorizationManager getAuthorizationManager() throws UserStoreException {
        return this.authorizationManager;
    }

    public UserStoreManager getUserStoreManager() throws UserStoreException {
        return this.coreRealm.getUserStoreManager();
    }

    public UserRealm getRealm() throws UserStoreException {
        if (this.coreRealm == null) {
            String msg = "Realm service is not available. Make sure that the required version of the User Manager component is properly installed.";
            log.error((Object)msg);
            throw new UserStoreException(msg);
        }
        return this.coreRealm;
    }

    public void cleanUp() throws UserStoreException {
    }

    public RealmConfiguration getRealmConfiguration() throws UserStoreException {
        return this.coreRealm.getRealmConfiguration();
    }

    public ProfileConfigurationManager getProfileConfigurationManager() throws UserStoreException {
        return this.getRealm().getProfileConfigurationManager();
    }

    public ClaimManager getClaimManager() throws UserStoreException {
        return this.getRealm().getClaimManager();
    }
}

