/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;

public class XsltPackage {
    private Processor processor;
    private StylesheetPackage stylesheetPackage;

    protected XsltPackage(Processor p, StylesheetPackage pp) {
        this.processor = p;
        this.stylesheetPackage = pp;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String getName() {
        return this.stylesheetPackage.getPackageName();
    }

    public String getVersion() {
        return this.stylesheetPackage.getPackageVersion().toString();
    }

    public XsltExecutable link() throws SaxonApiException {
        try {
            Compilation compilation = new Compilation(this.processor.getUnderlyingConfiguration(), new CompilerInfo());
            PreparedStylesheet pss = new PreparedStylesheet(compilation);
            this.stylesheetPackage.updatePreparedStylesheet(pss);
            return new XsltExecutable(this.processor, pss);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StylesheetPackage getUnderlyingPreparedPackage() {
        return this.stylesheetPackage;
    }
}

