/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.security.SecurityTokens;
import eu.unicore.security.wsutil.AuthInHandler;
import eu.unicore.security.wsutil.DSigSecurityInHandler;
import eu.unicore.security.wsutil.ETDInHandler;
import eu.unicore.security.wsutil.SecuritySession;
import eu.unicore.security.wsutil.SecuritySessionStore;
import eu.unicore.security.wsutil.SessionIDServerOutHandler;
import eu.unicore.util.Log;
import java.util.UUID;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.log4j.Logger;

public class SecuritySessionCreateInHandler
extends AbstractSoapInterceptor {
    protected static final Logger logger = Log.getLogger("unicore.security", SecuritySessionCreateInHandler.class);
    private static final long DEF_SESSION_LIFETIME = 3600000L;
    protected SecuritySessionStore sessionStore;
    private final long sessionLifetime;

    public SecuritySessionCreateInHandler(SecuritySessionStore sessionStore) {
        this(sessionStore, 3600000L);
    }

    public SecuritySessionCreateInHandler(SecuritySessionStore sessionStore, long sessionLifetime) {
        super("pre-invoke");
        this.addAfter(AuthInHandler.class.getName());
        this.addAfter(ETDInHandler.class.getName());
        this.addAfter(DSigSecurityInHandler.class.getName());
        this.sessionStore = sessionStore;
        this.sessionLifetime = sessionLifetime;
    }

    public void handleMessage(SoapMessage ctx) {
        SecurityTokens securityTokens = (SecurityTokens)ctx.get((Object)SecurityTokens.KEY);
        if (securityTokens == null) {
            logger.error("No security info in headers. Wrong configuration: " + AuthInHandler.class.getCanonicalName() + " handler" + " must be configure before this Security session creation handler.");
            return;
        }
        if (Boolean.TRUE.equals(securityTokens.getContext().get("reused-unicore-security-session"))) {
            return;
        }
        this.createSession(securityTokens);
    }

    protected SecuritySession createSession(SecurityTokens securityTokens) {
        SecuritySession session = null;
        String sessionID = UUID.randomUUID().toString();
        securityTokens.getContext().put("unicore-security-session-id", sessionID);
        session = new SecuritySession(sessionID, securityTokens, this.sessionLifetime);
        this.sessionStore.storeSession(session, securityTokens);
        SessionIDServerOutHandler.setSession(session);
        return session;
    }
}

