/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.support;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.util.ClassUtils;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.NativeJpaExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeJpaHelper {
    public static <T> T detectNativeJpa(EntityManagerFactory emf, CompassSettings settings, NativeJpaCallback<T> callback) throws JpaGpsDeviceException {
        EntityManagerFactory nativeEmf = NativeJpaHelper.extractNativeJpa(emf, settings);
        Set interfaces = ClassUtils.getAllInterfacesAsSet(nativeEmf);
        HashSet<String> interfacesAsStrings = new HashSet<String>();
        for (Object anInterface : interfaces) {
            interfacesAsStrings.add(((Class)anInterface).getName());
        }
        interfacesAsStrings.add(nativeEmf.getClass().getName());
        T retVal = interfacesAsStrings.contains("org.hibernate.ejb.HibernateEntityManagerFactory") ? callback.onHibernate() : (interfacesAsStrings.contains("oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerFactoryImpl") ? callback.onTopLinkEssentials() : (interfacesAsStrings.contains("org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl") ? callback.onEclipseLink() : (interfacesAsStrings.contains("org.apache.openjpa.persistence.OpenJPAEntityManagerFactory") ? callback.onOpenJPA() : callback.onUnknown())));
        return retVal;
    }

    public static EntityManagerFactory extractNativeJpa(EntityManagerFactory emf, CompassSettings settings) {
        Set interfaces = ClassUtils.getAllInterfacesAsSet(emf);
        HashSet<String> interfacesAsStrings = new HashSet<String>();
        for (Object anInterface : interfaces) {
            interfacesAsStrings.add(((Class)anInterface).getName());
        }
        interfacesAsStrings.add(emf.getClass().getName());
        NativeJpaExtractor extractor = null;
        if (interfacesAsStrings.contains("org.springframework.orm.jpa.EntityManagerFactoryInfo")) {
            try {
                extractor = (NativeJpaExtractor)ClassUtils.forName("org.compass.spring.device.jpa.SpringNativeJpaExtractor", settings.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new JpaGpsDeviceException("Failed to load/create spring native extractor", e);
            }
        }
        if (interfacesAsStrings.contains("org.jboss.ejb3.entity.InjectedEntityManagerFactory")) {
            try {
                extractor = (NativeJpaExtractor)ClassUtils.forName("org.compass.jboss.device.jpa.JBossNativeHibernateJpaExtractor", settings.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new JpaGpsDeviceException("Failed to load/create JBoss native extractor", e);
            }
        }
        EntityManagerFactory nativeEmf = emf;
        if (extractor != null) {
            nativeEmf = extractor.extractNative(emf);
            nativeEmf = NativeJpaHelper.extractNativeJpa(nativeEmf, settings);
        }
        return nativeEmf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NativeJpaCallback<T> {
        public T onHibernate();

        public T onTopLinkEssentials();

        public T onOpenJPA();

        public T onEclipseLink();

        public T onUnknown();
    }
}

