/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.File;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.AbstractXmlConfigurationBuilder;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.DTDEntityResolver;
import org.compass.core.util.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class DTDConfigurationBuilder
extends AbstractXmlConfigurationBuilder {
    protected void doProcess(Document doc, CompassConfiguration config) throws ConfigurationException {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !"compass".equals(node.getNodeName())) continue;
            this.processCompass((Element)node, config);
        }
    }

    protected void processCompass(Element compassElement, CompassConfiguration config) throws ConfigurationException {
        String name = DomUtils.getElementAttribute(compassElement, "name", "default");
        config.getSettings().setSetting("compass.name", name);
        NodeList nl = compassElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            if ("setting".equals(ele.getNodeName())) {
                String settingName = ele.getAttribute("name");
                String settingValue = DomUtils.getTrimmedTextValue(ele);
                config.setSetting(settingName, settingValue);
                continue;
            }
            if ("mapping".equals(ele.getNodeName()) || "meta-data".equals(ele.getNodeName())) {
                String rsrc = DomUtils.getElementAttribute(ele, "resource", null);
                String file = DomUtils.getElementAttribute(ele, "file", null);
                String jar = DomUtils.getElementAttribute(ele, "jar", null);
                String pckg = DomUtils.getElementAttribute(ele, "package", null);
                String clazz = DomUtils.getElementAttribute(ele, "class", null);
                if (rsrc != null) {
                    config.addResource(rsrc);
                    continue;
                }
                if (jar != null) {
                    config.addJar(new File(jar));
                    continue;
                }
                if (pckg != null) {
                    config.addPackage(pckg);
                    continue;
                }
                if (clazz != null) {
                    try {
                        config.addClass(ClassUtils.forName(clazz, config.getClassLoader()));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConfigurationException("Failed map class [" + clazz + "]", e);
                    }
                }
                if (file == null) {
                    throw new ConfigurationException("<mapping> or <meta-data> element in configuration specifies no attributes");
                }
                config.addFile(file);
                continue;
            }
            if (!"scan".equals(ele.getNodeName())) continue;
            config.addScan(DomUtils.getElementAttribute(ele, "base-package"), DomUtils.getElementAttribute(ele, "pattern"));
        }
        this.log.info((Object)("Configured Compass [" + name + "]"));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("--with settings [" + config.getSettings() + "]"));
        }
    }

    protected EntityResolver doGetEntityResolver() {
        return new DTDEntityResolver();
    }
}

