/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public final class CacheConfigurationImpl
implements CacheConfiguration {
    private static final boolean DEFAULT_READ_THROUGH = false;
    private static final boolean DEFAULT_WRITE_THROUGH = false;
    private static final boolean DEFAULT_STATISTICS_ENABLED = false;
    private static final CacheConfiguration.Duration DEFAULT_TIME_TO_LIVE = CacheConfiguration.Duration.ETERNAL;
    private static final boolean DEFAULT_STORE_BY_VALUE = true;
    private static final IsolationLevel DEFAULT_TRANSACTION_ISOLATION_LEVEL = IsolationLevel.NONE;
    private static final Mode DEFAULT_TRANSACTION_MODE = Mode.NONE;
    protected boolean readThrough = false;
    protected boolean writeThrough = false;
    protected boolean statisticsEnabled = false;
    protected CacheConfiguration.Duration[] timeToLive;
    protected boolean storeByValue = true;
    protected IsolationLevel isolationLevel = DEFAULT_TRANSACTION_ISOLATION_LEVEL;
    protected Mode transactionMode = DEFAULT_TRANSACTION_MODE;
    private CacheLoader cacheLoader;
    private CacheWriter cacheWriter;

    public CacheConfigurationImpl() {
    }

    public CacheConfigurationImpl(boolean readThrough, boolean writeThrough, boolean storeByValue, boolean statisticsEnabled, IsolationLevel isolationLevel, Mode transactionMode, CacheConfiguration.Duration[] timeToLive) {
        this.readThrough = readThrough;
        this.writeThrough = writeThrough;
        this.storeByValue = storeByValue;
        this.statisticsEnabled = statisticsEnabled;
        this.isolationLevel = isolationLevel;
        this.transactionMode = transactionMode;
        this.timeToLive = Arrays.copyOf(timeToLive, timeToLive.length);
    }

    void setReadThrough(boolean readThrough) {
        this.readThrough = readThrough;
    }

    void setWriteThrough(boolean writeThrough) {
        this.writeThrough = writeThrough;
    }

    void setStoreByValue(boolean storeByValue) {
        this.storeByValue = storeByValue;
    }

    void setIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    void setTransactionMode(Mode transactionMode) {
        this.transactionMode = transactionMode;
    }

    void setTimeToLive(CacheConfiguration.Duration[] timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public boolean isReadThrough() {
        return this.readThrough;
    }

    @Override
    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    @Override
    public boolean isStoreByValue() {
        return this.storeByValue;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enableStatistics) {
        this.statisticsEnabled = enableStatistics;
    }

    @Override
    public CacheConfiguration.Duration getExpiry(CacheConfiguration.ExpiryType type) {
        return this.timeToLive[type.ordinal()];
    }

    void setExpiry(long expiryTime, TimeUnit timeUnit, CacheConfiguration.ExpiryType type) {
        if (this.timeToLive == null) {
            this.timeToLive = new CacheConfiguration.Duration[2];
        }
        this.timeToLive[type.ordinal()] = new CacheConfiguration.Duration(timeUnit, expiryTime);
    }

    @Override
    public boolean isTransactionEnabled() {
        return this.isolationLevel != null && this.transactionMode != null;
    }

    @Override
    public IsolationLevel getTransactionIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public Mode getTransactionMode() {
        return this.transactionMode;
    }

    public CacheLoader getCacheLoader() {
        return this.cacheLoader;
    }

    public CacheWriter getCacheWriter() {
        return this.cacheWriter;
    }

    void setCacheLoader(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    void setCacheWriter(CacheWriter cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public int hashCode() {
        int result = this.readThrough ? 1 : 0;
        result = 31 * result + (this.writeThrough ? 1 : 0);
        result = 31 * result + (this.isStatisticsEnabled() ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.timeToLive);
        result = 31 * result + (this.storeByValue ? 1 : 0);
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + (this.transactionMode != null ? this.transactionMode.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheConfiguration)) {
            return false;
        }
        CacheConfiguration that = (CacheConfiguration)o;
        if (this.readThrough != that.isReadThrough()) {
            return false;
        }
        if (this.writeThrough != that.isWriteThrough()) {
            return false;
        }
        if (this.isStatisticsEnabled() != that.isStatisticsEnabled()) {
            return false;
        }
        for (CacheConfiguration.ExpiryType ttyType : CacheConfiguration.ExpiryType.values()) {
            if (this.getExpiry(ttyType) == that.getExpiry(ttyType)) continue;
            return false;
        }
        return this.storeByValue == this.isStoreByValue() && this.isolationLevel == that.getTransactionIsolationLevel() && this.transactionMode == that.getTransactionMode();
    }
}

