/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeSuggestersRequestMarshaller
implements Marshaller<Request<DescribeSuggestersRequest>, DescribeSuggestersRequest> {
    public Request<DescribeSuggestersRequest> marshall(DescribeSuggestersRequest describeSuggestersRequest) {
        if (describeSuggestersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSuggestersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeSuggesters");
        request.addParameter("Version", "2013-01-01");
        if (describeSuggestersRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeSuggestersRequest.getDomainName()));
        }
        List<String> suggesterNamesList = describeSuggestersRequest.getSuggesterNames();
        int suggesterNamesListIndex = 1;
        for (String suggesterNamesListValue : suggesterNamesList) {
            if (suggesterNamesListValue != null) {
                request.addParameter("SuggesterNames.member." + suggesterNamesListIndex, StringUtils.fromString((String)suggesterNamesListValue));
            }
            ++suggesterNamesListIndex;
        }
        if (describeSuggestersRequest.isDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeSuggestersRequest.isDeployed()));
        }
        return request;
    }
}

