/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.record.DataRecord;
import com.hazelcast.map.record.ObjectRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionRecordStore
implements RecordStore {
    final String name;
    final PartitionContainer partitionContainer;
    final ConcurrentMap<Data, Record> records = new ConcurrentHashMap<Data, Record>(1000);
    final Set<Data> toBeRemovedKeys = new HashSet<Data>();
    final MapContainer mapContainer;
    final MapService mapService;
    final LockStore lockStore;

    public PartitionRecordStore(String name, PartitionContainer partitionContainer) {
        this.name = name;
        this.partitionContainer = partitionContainer;
        this.mapService = partitionContainer.getMapService();
        this.mapContainer = this.mapService.getMapContainer(name);
        LockService lockService = (LockService)this.mapService.getNodeEngine().getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionContainer.getPartitionId(), new DefaultObjectNamespace("hz:impl:mapService", name));
    }

    @Override
    public void flush() {
        EntryTaskScheduler deleteScheduler;
        HashSet<Data> keys = new HashSet<Data>();
        for (Record record : this.records.values()) {
            keys.add(record.getKey());
        }
        EntryTaskScheduler writeScheduler = this.mapContainer.getMapStoreWriteScheduler();
        if (writeScheduler != null) {
            Set processedKeys = writeScheduler.flush(keys);
            for (Data key : processedKeys) {
                ((Record)this.records.get(key)).onStore();
            }
        }
        if ((deleteScheduler = this.mapContainer.getMapStoreDeleteScheduler()) != null) {
            deleteScheduler.flush(this.toBeRemovedKeys);
            this.toBeRemovedKeys.clear();
        }
    }

    private void flush(Data key) {
        EntryTaskScheduler deleteScheduler;
        EntryTaskScheduler writeScheduler = this.mapContainer.getMapStoreWriteScheduler();
        HashSet<Data> keys = new HashSet<Data>(1);
        keys.add(key);
        if (writeScheduler != null) {
            Set processedKeys = writeScheduler.flush(keys);
            for (Data pkey : processedKeys) {
                ((Record)this.records.get(pkey)).onStore();
            }
        }
        if ((deleteScheduler = this.mapContainer.getMapStoreDeleteScheduler()) != null && this.toBeRemovedKeys.contains(key)) {
            deleteScheduler.flush(keys);
            this.toBeRemovedKeys.remove(key);
        }
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public Map<Data, Record> getRecords() {
        return this.records;
    }

    void clear() {
        IndexService indexService;
        LockService lockService = (LockService)this.mapService.getNodeEngine().getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionContainer.getPartitionId(), new DefaultObjectNamespace("hz:impl:mapService", this.name));
        }
        if ((indexService = this.mapContainer.getIndexService()).hasIndex()) {
            for (Data key : this.records.keySet()) {
                indexService.removeEntryIndex(key);
            }
        }
        this.records.clear();
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean containsValue(Object value) {
        for (Record record : this.records.values()) {
            if (!this.mapService.compare(this.name, value, record.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.lock(key, caller, threadId, ttl);
    }

    @Override
    public boolean txnLock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLock(Data key, String caller, int threadId, long ttl) {
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean isLockedBy(Data key, String caller, int threadId) {
        return this.lockStore != null && this.lockStore.isLockedBy(key, caller, threadId);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, int threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Set<Map.Entry<Data, Object>> entrySetObject() {
        HashMap<Data, Object> temp = new HashMap<Data, Object>(this.records.size());
        for (Data key : this.records.keySet()) {
            temp.put(key, this.mapService.toObject(((Record)this.records.get(key)).getValue()));
        }
        return temp.entrySet();
    }

    @Override
    public Set<Map.Entry<Data, Data>> entrySetData() {
        HashMap<Data, Data> temp = new HashMap<Data, Data>(this.records.size());
        for (Data key : this.records.keySet()) {
            temp.put(key, this.mapService.toData(((Record)this.records.get(key)).getValue()));
        }
        return temp.entrySet();
    }

    @Override
    public Map.Entry<Data, Data> getMapEntryData(Data dataKey) {
        Record record = (Record)this.records.get(dataKey);
        Data data = record != null ? this.mapService.toData(record.getValue()) : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, data);
    }

    @Override
    public Map.Entry<Data, Object> getMapEntryObject(Data dataKey) {
        Record record = (Record)this.records.get(dataKey);
        Object value = record != null ? this.mapService.toObject(record.getValue()) : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, value);
    }

    @Override
    public Set<Data> keySet() {
        HashSet<Data> keySet = new HashSet<Data>(this.records.size());
        for (Data data : this.records.keySet()) {
            keySet.add(data);
        }
        return keySet;
    }

    @Override
    public Collection<Object> valuesObject() {
        ArrayList<Object> values = new ArrayList<Object>(this.records.size());
        for (Record record : this.records.values()) {
            values.add(this.mapService.toObject(record.getValue()));
        }
        return values;
    }

    @Override
    public Collection<Data> valuesData() {
        ArrayList<Data> values = new ArrayList<Data>(this.records.size());
        for (Record record : this.records.values()) {
            values.add(this.mapService.toData(record.getValue()));
        }
        return values;
    }

    @Override
    public void removeAll() {
        Set<Data> locks = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, Record> lockRecords = new HashMap<Data, Record>(locks.size());
        for (Data key : locks) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockRecords.put(key, record);
        }
        Set keysToDelete = this.records.keySet();
        keysToDelete.removeAll(lockRecords.keySet());
        MapStoreWrapper store = this.mapContainer.getStore();
        HashSet<Object> keysObject = new HashSet<Object>();
        for (Data key : keysToDelete) {
            this.removeIndex(key);
            keysObject.add(this.mapService.toObject(key));
        }
        if (store != null) {
            store.deleteAll(keysObject);
            this.toBeRemovedKeys.clear();
        }
        this.records.clear();
        this.records.putAll(lockRecords);
    }

    @Override
    public void reset() {
        this.records.clear();
    }

    @Override
    public Object remove(Data dataKey) {
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
                this.removeIndex(dataKey);
                this.mapStoreDelete(null, dataKey);
            }
        } else {
            oldValue = record.getValue();
            if ((oldValue = this.mapService.interceptRemove(this.name, oldValue)) != null) {
                this.removeIndex(dataKey);
                this.mapStoreDelete(record, dataKey);
            }
            this.records.remove(dataKey);
        }
        return oldValue;
    }

    private void removeIndex(Data key) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            indexService.removeEntryIndex(key);
        }
    }

    @Override
    public Object evict(Data dataKey) {
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record != null) {
            this.flush(dataKey);
            this.mapService.interceptRemove(this.name, record.getValue());
            oldValue = record.getValue();
            this.records.remove(dataKey);
            this.removeIndex(dataKey);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Data dataKey, Object testValue) {
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        boolean removed = false;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
            }
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.mapService.compare(this.name, testValue, oldValue)) {
            this.mapService.interceptRemove(this.name, oldValue);
            this.removeIndex(dataKey);
            this.mapStoreDelete(record, dataKey);
            this.records.remove(dataKey);
            removed = true;
        }
        return removed;
    }

    @Override
    public Object get(Data dataKey) {
        Record record = (Record)this.records.get(dataKey);
        Object value = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                value = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
                if (value != null) {
                    record = this.mapService.createRecord(this.name, dataKey, value, -1L);
                    this.records.put(dataKey, record);
                    this.saveIndex(record);
                }
                if (value == null) {
                    record = this.mapService.createRecord(this.name, dataKey, null, 100L);
                    this.records.put(dataKey, record);
                }
            }
        } else {
            this.accessRecord(record);
            value = record.getValue();
        }
        value = this.mapService.interceptGet(this.name, value);
        return value;
    }

    @Override
    public boolean containsKey(Data dataKey) {
        boolean contains;
        Object value;
        Record record = (Record)this.records.get(dataKey);
        if (record == null && this.mapContainer.getStore() != null && (value = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
            record = this.mapService.createRecord(this.name, dataKey, value, -1L);
            this.records.put(dataKey, record);
        }
        boolean bl = contains = record != null && record.getValue() != null;
        if (contains) {
            this.accessRecord(record);
        }
        return contains;
    }

    @Override
    public void put(Map.Entry<Data, Object> entry) {
        Data dataKey = entry.getKey();
        Object value = entry.getValue();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, -1L);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.mapStoreWrite(record, dataKey, value);
            this.setRecordValue(record, value);
        }
        this.saveIndex(record);
    }

    @Override
    public Object put(Data dataKey, Object value, long ttl) {
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey));
            }
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
        } else {
            oldValue = record.getValue();
            value = this.mapService.interceptPut(this.name, oldValue, value);
            this.mapStoreWrite(record, dataKey, value);
            this.setRecordValue(record, value);
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean set(Data dataKey, Object value, long ttl) {
        Record record = (Record)this.records.get(dataKey);
        boolean newRecord = false;
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            newRecord = true;
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.mapStoreWrite(record, dataKey, value);
            this.setRecordValue(record, value);
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return newRecord;
    }

    @Override
    public boolean merge(Data dataKey, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        Record record = (Record)this.records.get(dataKey);
        Object newValue = null;
        if (record == null) {
            newValue = mergingEntry.getValue();
            record = this.mapService.createRecord(this.name, dataKey, newValue, -1L);
            this.mapStoreWrite(record, dataKey, newValue);
            this.records.put(dataKey, record);
        } else {
            Object oldValue = record.getValue();
            SimpleEntryView<Object, Object> existingEntry = new SimpleEntryView<Object, Object>(this.mapService.toObject(record.getKey()), this.mapService.toObject(record.getValue()), record);
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.records.remove(dataKey);
                this.removeIndex(dataKey);
                this.mapStoreDelete(record, dataKey);
                return true;
            }
            if (this.mapService.compare(this.name, newValue, oldValue)) {
                return true;
            }
            this.mapStoreWrite(record, dataKey, newValue);
            if (record instanceof DataRecord) {
                ((DataRecord)record).setValue(this.mapService.toData(newValue));
            } else if (record instanceof ObjectRecord) {
                ((ObjectRecord)record).setValue(this.mapService.toObject(newValue));
            }
        }
        this.saveIndex(record);
        return newValue != null;
    }

    @Override
    public Object replace(Data dataKey, Object value) {
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            return null;
        }
        oldValue = record.getValue();
        value = this.mapService.interceptPut(this.name, oldValue, value);
        this.mapStoreWrite(record, dataKey, value);
        this.setRecordValue(record, value);
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data dataKey, Object testValue, Object newValue) {
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            return false;
        }
        if (!this.mapService.compare(this.name, record.getValue(), testValue)) {
            return false;
        }
        newValue = this.mapService.interceptPut(this.name, record.getValue(), newValue);
        this.mapStoreWrite(record, dataKey, newValue);
        this.setRecordValue(record, newValue);
        this.saveIndex(record);
        return true;
    }

    @Override
    public void putTransient(Data dataKey, Object value, long ttl) {
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.records.put(dataKey, record);
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.setRecordValue(record, value);
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
    }

    @Override
    public boolean tryPut(Data dataKey, Object value, long ttl) {
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.mapStoreWrite(record, dataKey, value);
            this.setRecordValue(record, value);
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return true;
    }

    @Override
    public Object putIfAbsent(Data dataKey, Object value, long ttl) {
        Record record = (Record)this.records.get(dataKey);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.mapContainer.getStore().load(this.mapService.toObject(dataKey))) != null) {
                record = this.mapService.createRecord(this.name, dataKey, oldValue, -1L);
                this.records.put(dataKey, record);
            }
        } else {
            this.accessRecord(record);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, dataKey, value, ttl);
            this.mapStoreWrite(record, dataKey, value);
            this.records.put(dataKey, record);
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        return oldValue;
    }

    private void accessRecord(Record record) {
        record.onAccess();
        int maxIdleSeconds = this.mapContainer.getMapConfig().getMaxIdleSeconds();
        if (maxIdleSeconds > 0) {
            this.mapService.scheduleIdleEviction(this.name, record.getKey(), maxIdleSeconds * 1000);
        }
    }

    private void saveIndex(Record record) {
        Data dataKey = record.getKey();
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            SerializationService ss = this.mapService.getSerializationService();
            QueryEntry queryableEntry = new QueryEntry(ss, dataKey, dataKey, record.getValue());
            indexService.saveEntryIndex(queryableEntry);
        }
    }

    private void mapStoreWrite(Record record, Data key, Object value) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store != null) {
            long writeDelayMillis = this.mapContainer.getWriteDelayMillis();
            if (writeDelayMillis <= 0L) {
                store.store(this.mapService.toObject(key), this.mapService.toObject(value));
                if (record != null) {
                    record.onStore();
                }
            } else {
                this.mapService.scheduleMapStoreWrite(this.name, key, value, writeDelayMillis);
            }
        }
    }

    private void mapStoreDelete(Record record, Data key) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store != null) {
            long writeDelayMillis = this.mapContainer.getWriteDelayMillis();
            if (writeDelayMillis == 0L) {
                store.delete(this.mapService.toObject(key));
                if (record != null) {
                    record.onStore();
                }
            } else {
                this.mapService.scheduleMapStoreDelete(this.name, key, writeDelayMillis);
                this.toBeRemovedKeys.add(key);
            }
        }
    }

    private void updateTtl(Record record, long ttl) {
        if (ttl > 0L) {
            this.mapService.scheduleTtlEviction(this.name, record, ttl);
        } else if (ttl == 0L) {
            this.mapContainer.getTtlEvictionScheduler().cancel(record.getKey());
        }
    }

    private void setRecordValue(Record record, Object value) {
        this.accessRecord(record);
        record.onUpdate();
        if (record instanceof DataRecord) {
            ((DataRecord)record).setValue(this.mapService.toData(value));
        } else if (record instanceof ObjectRecord) {
            ((ObjectRecord)record).setValue(this.mapService.toObject(value));
        }
    }
}

