/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.BaseLockOperation;
import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;

abstract class BaseSignalOperation
extends BaseLockOperation {
    protected boolean all;
    protected String conditionId;
    protected transient int awaitCount;

    public BaseSignalOperation() {
    }

    public BaseSignalOperation(ObjectNamespace namespace, Data key, int threadId, String conditionId, boolean all) {
        super(namespace, key, threadId);
        this.conditionId = conditionId;
        this.all = all;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        this.awaitCount = lockStore.getAwaitCount(this.key, this.conditionId);
        int signalCount = this.awaitCount > 0 ? (this.all ? this.awaitCount : 1) : 0;
        ConditionKey notifiedKey = new ConditionKey(this.key, this.conditionId);
        for (int i = 0; i < signalCount; ++i) {
            lockStore.registerSignalKey(notifiedKey);
        }
        this.response = true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.all);
        out.writeUTF(this.conditionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.all = in.readBoolean();
        this.conditionId = in.readUTF();
    }
}

