/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlConfigHelper {
    protected boolean domLevel3 = true;

    protected String xmlToJavaName(String name) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = name.toCharArray();
        boolean dash = false;
        StringBuilder token = new StringBuilder();
        for (char aCharArray : charArray) {
            if (aCharArray == '-') {
                this.appendToken(builder, token);
                dash = true;
                continue;
            }
            token.append(dash ? Character.toUpperCase(aCharArray) : aCharArray);
            dash = false;
        }
        this.appendToken(builder, token);
        return builder.toString();
    }

    protected void appendToken(StringBuilder builder, StringBuilder token) {
        String string = token.toString();
        if ("Jvm".equals(string)) {
            string = "JVM";
        }
        builder.append(string);
        token.setLength(0);
    }

    protected String getTextContent(Node node) {
        if (node != null) {
            String text = this.domLevel3 ? node.getTextContent() : this.getTextContentOld(node);
            return text != null ? text.trim() : "";
        }
        return "";
    }

    private String getTextContentOld(Node node) {
        Node child = node.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return this.hasTextContent(child) ? child.getNodeValue() : "";
            }
            StringBuilder buf = new StringBuilder();
            this.appendTextContents(node, buf);
            return buf.toString();
        }
        return "";
    }

    private void appendTextContents(Node node, StringBuilder buf) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.hasTextContent(child)) continue;
            buf.append(child.getNodeValue());
        }
    }

    protected final boolean hasTextContent(Node node) {
        short nodeType = node.getNodeType();
        return nodeType != 8 && nodeType != 7;
    }

    public final String cleanNodeName(Node node) {
        return AbstractXmlConfigHelper.cleanNodeName(node.getNodeName());
    }

    public static String cleanNodeName(String nodeName) {
        String name = nodeName;
        if (name != null) {
            name = nodeName.replaceAll("\\w+:", "").toLowerCase();
        }
        return name;
    }

    protected boolean checkTrue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    public static class IterableNodeList
    implements Iterable<Node> {
        private final NodeList parent;
        private final int maximum;
        private final short nodeType;

        public IterableNodeList(Node node) {
            this(node.getChildNodes());
        }

        public IterableNodeList(NodeList list) {
            this(list, 0);
        }

        public IterableNodeList(Node node, short nodeType) {
            this(node.getChildNodes(), nodeType);
        }

        public IterableNodeList(NodeList parent, short nodeType) {
            this.parent = parent;
            this.nodeType = nodeType;
            this.maximum = parent.getLength();
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){
                private int index = 0;
                private Node next;

                private boolean findNext() {
                    this.next = null;
                    while (this.index < IterableNodeList.this.maximum) {
                        Node item = IterableNodeList.this.parent.item(this.index);
                        if (IterableNodeList.this.nodeType == 0 || item.getNodeType() == IterableNodeList.this.nodeType) {
                            this.next = item;
                            return true;
                        }
                        ++this.index;
                    }
                    return false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                @Override
                public Node next() {
                    if (this.findNext()) {
                        ++this.index;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

