/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.xis5.samples;

import java.util.Iterator;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.xpath.XisXPath;
import org.xmlpull.infoset.xpath.jaxen.XPathSyntaxException;

public class XisXPathDemo {
    public static void main(String[] args) {
        int pos;
        String locationOrXmlString = "<elem attr='value'><sub-elem>Text</sub-elem></elem>";
        String xpathExpr = "//";
        if (args.length != 2) {
            System.err.println("usage: " + XisXPathDemo.class.getName() + " <document url or XML content> <xpath expr>");
        }
        if (args.length > 0) {
            locationOrXmlString = args[0];
        }
        if (args.length > 1) {
            xpathExpr = args[1];
        }
        boolean useUrl = (pos = locationOrXmlString.indexOf("://")) >= 0 && pos < 6;
        try {
            XmlInfosetBuilder builder = XmlInfosetBuilder.newInstance();
            System.out.println("Evaluating XPath '" + xpathExpr + "' against '" + locationOrXmlString + "'" + (useUrl ? " URL" : ""));
            XmlDocument doc = useUrl ? builder.parseLocation(locationOrXmlString) : builder.parseString(locationOrXmlString);
            XisXPath xpath = new XisXPath(xpathExpr);
            Iterator resultsIter = xpath.selectNodes(doc).iterator();
            System.out.println("Results:");
            while (resultsIter.hasNext()) {
                Object infosetItem = resultsIter.next();
                System.out.println("----------------------------------");
                System.out.println(builder.serializeToString(infosetItem));
            }
            System.out.println("----------------------------------");
        }
        catch (XPathSyntaxException e) {
            System.err.println(e.getMultilineMessage());
        }
        catch (XmlBuilderException e) {
            e.printStackTrace();
        }
    }
}

