/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.cloud.aurora.client.sdk.JobKey;
import org.apache.airavata.cloud.aurora.client.sdk.ScheduleStatus;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TaskQuery
implements TBase<TaskQuery, _Fields>,
Serializable,
Cloneable,
Comparable<TaskQuery> {
    private static final TStruct STRUCT_DESC = new TStruct("TaskQuery");
    private static final TField ROLE_FIELD_DESC = new TField("role", 11, 14);
    private static final TField ENVIRONMENT_FIELD_DESC = new TField("environment", 11, 9);
    private static final TField JOB_NAME_FIELD_DESC = new TField("jobName", 11, 2);
    private static final TField TASK_IDS_FIELD_DESC = new TField("taskIds", 14, 4);
    private static final TField STATUSES_FIELD_DESC = new TField("statuses", 14, 5);
    private static final TField INSTANCE_IDS_FIELD_DESC = new TField("instanceIds", 14, 7);
    private static final TField SLAVE_HOSTS_FIELD_DESC = new TField("slaveHosts", 14, 10);
    private static final TField JOB_KEYS_FIELD_DESC = new TField("jobKeys", 14, 11);
    private static final TField OFFSET_FIELD_DESC = new TField("offset", 8, 12);
    private static final TField LIMIT_FIELD_DESC = new TField("limit", 8, 13);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public String role;
    public String environment;
    public String jobName;
    public Set<String> taskIds;
    public Set<ScheduleStatus> statuses;
    public Set<Integer> instanceIds;
    public Set<String> slaveHosts;
    public Set<JobKey> jobKeys;
    public int offset;
    public int limit;
    private static final int __OFFSET_ISSET_ID = 0;
    private static final int __LIMIT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TaskQuery() {
    }

    public TaskQuery(String role, String environment, String jobName, Set<String> taskIds, Set<ScheduleStatus> statuses, Set<Integer> instanceIds, Set<String> slaveHosts, Set<JobKey> jobKeys, int offset, int limit) {
        this();
        this.role = role;
        this.environment = environment;
        this.jobName = jobName;
        this.taskIds = taskIds;
        this.statuses = statuses;
        this.instanceIds = instanceIds;
        this.slaveHosts = slaveHosts;
        this.jobKeys = jobKeys;
        this.offset = offset;
        this.setOffsetIsSet(true);
        this.limit = limit;
        this.setLimitIsSet(true);
    }

    public TaskQuery(TaskQuery other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetRole()) {
            this.role = other.role;
        }
        if (other.isSetEnvironment()) {
            this.environment = other.environment;
        }
        if (other.isSetJobName()) {
            this.jobName = other.jobName;
        }
        if (other.isSetTaskIds()) {
            HashSet<String> __this__taskIds = new HashSet<String>(other.taskIds);
            this.taskIds = __this__taskIds;
        }
        if (other.isSetStatuses()) {
            HashSet<ScheduleStatus> __this__statuses = new HashSet<ScheduleStatus>(other.statuses.size());
            for (ScheduleStatus scheduleStatus : other.statuses) {
                __this__statuses.add(scheduleStatus);
            }
            this.statuses = __this__statuses;
        }
        if (other.isSetInstanceIds()) {
            HashSet<Integer> __this__instanceIds = new HashSet<Integer>(other.instanceIds);
            this.instanceIds = __this__instanceIds;
        }
        if (other.isSetSlaveHosts()) {
            HashSet<String> __this__slaveHosts = new HashSet<String>(other.slaveHosts);
            this.slaveHosts = __this__slaveHosts;
        }
        if (other.isSetJobKeys()) {
            HashSet<JobKey> __this__jobKeys = new HashSet<JobKey>(other.jobKeys.size());
            for (JobKey jobKey : other.jobKeys) {
                __this__jobKeys.add(new JobKey(jobKey));
            }
            this.jobKeys = __this__jobKeys;
        }
        this.offset = other.offset;
        this.limit = other.limit;
    }

    public TaskQuery deepCopy() {
        return new TaskQuery(this);
    }

    public void clear() {
        this.role = null;
        this.environment = null;
        this.jobName = null;
        this.taskIds = null;
        this.statuses = null;
        this.instanceIds = null;
        this.slaveHosts = null;
        this.jobKeys = null;
        this.setOffsetIsSet(false);
        this.offset = 0;
        this.setLimitIsSet(false);
        this.limit = 0;
    }

    public String getRole() {
        return this.role;
    }

    public TaskQuery setRole(String role) {
        this.role = role;
        return this;
    }

    public void unsetRole() {
        this.role = null;
    }

    public boolean isSetRole() {
        return this.role != null;
    }

    public void setRoleIsSet(boolean value) {
        if (!value) {
            this.role = null;
        }
    }

    public String getEnvironment() {
        return this.environment;
    }

    public TaskQuery setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public void unsetEnvironment() {
        this.environment = null;
    }

    public boolean isSetEnvironment() {
        return this.environment != null;
    }

    public void setEnvironmentIsSet(boolean value) {
        if (!value) {
            this.environment = null;
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public TaskQuery setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public void unsetJobName() {
        this.jobName = null;
    }

    public boolean isSetJobName() {
        return this.jobName != null;
    }

    public void setJobNameIsSet(boolean value) {
        if (!value) {
            this.jobName = null;
        }
    }

    public int getTaskIdsSize() {
        return this.taskIds == null ? 0 : this.taskIds.size();
    }

    public Iterator<String> getTaskIdsIterator() {
        return this.taskIds == null ? null : this.taskIds.iterator();
    }

    public void addToTaskIds(String elem) {
        if (this.taskIds == null) {
            this.taskIds = new HashSet<String>();
        }
        this.taskIds.add(elem);
    }

    public Set<String> getTaskIds() {
        return this.taskIds;
    }

    public TaskQuery setTaskIds(Set<String> taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    public void unsetTaskIds() {
        this.taskIds = null;
    }

    public boolean isSetTaskIds() {
        return this.taskIds != null;
    }

    public void setTaskIdsIsSet(boolean value) {
        if (!value) {
            this.taskIds = null;
        }
    }

    public int getStatusesSize() {
        return this.statuses == null ? 0 : this.statuses.size();
    }

    public Iterator<ScheduleStatus> getStatusesIterator() {
        return this.statuses == null ? null : this.statuses.iterator();
    }

    public void addToStatuses(ScheduleStatus elem) {
        if (this.statuses == null) {
            this.statuses = new HashSet<ScheduleStatus>();
        }
        this.statuses.add(elem);
    }

    public Set<ScheduleStatus> getStatuses() {
        return this.statuses;
    }

    public TaskQuery setStatuses(Set<ScheduleStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void unsetStatuses() {
        this.statuses = null;
    }

    public boolean isSetStatuses() {
        return this.statuses != null;
    }

    public void setStatusesIsSet(boolean value) {
        if (!value) {
            this.statuses = null;
        }
    }

    public int getInstanceIdsSize() {
        return this.instanceIds == null ? 0 : this.instanceIds.size();
    }

    public Iterator<Integer> getInstanceIdsIterator() {
        return this.instanceIds == null ? null : this.instanceIds.iterator();
    }

    public void addToInstanceIds(int elem) {
        if (this.instanceIds == null) {
            this.instanceIds = new HashSet<Integer>();
        }
        this.instanceIds.add(elem);
    }

    public Set<Integer> getInstanceIds() {
        return this.instanceIds;
    }

    public TaskQuery setInstanceIds(Set<Integer> instanceIds) {
        this.instanceIds = instanceIds;
        return this;
    }

    public void unsetInstanceIds() {
        this.instanceIds = null;
    }

    public boolean isSetInstanceIds() {
        return this.instanceIds != null;
    }

    public void setInstanceIdsIsSet(boolean value) {
        if (!value) {
            this.instanceIds = null;
        }
    }

    public int getSlaveHostsSize() {
        return this.slaveHosts == null ? 0 : this.slaveHosts.size();
    }

    public Iterator<String> getSlaveHostsIterator() {
        return this.slaveHosts == null ? null : this.slaveHosts.iterator();
    }

    public void addToSlaveHosts(String elem) {
        if (this.slaveHosts == null) {
            this.slaveHosts = new HashSet<String>();
        }
        this.slaveHosts.add(elem);
    }

    public Set<String> getSlaveHosts() {
        return this.slaveHosts;
    }

    public TaskQuery setSlaveHosts(Set<String> slaveHosts) {
        this.slaveHosts = slaveHosts;
        return this;
    }

    public void unsetSlaveHosts() {
        this.slaveHosts = null;
    }

    public boolean isSetSlaveHosts() {
        return this.slaveHosts != null;
    }

    public void setSlaveHostsIsSet(boolean value) {
        if (!value) {
            this.slaveHosts = null;
        }
    }

    public int getJobKeysSize() {
        return this.jobKeys == null ? 0 : this.jobKeys.size();
    }

    public Iterator<JobKey> getJobKeysIterator() {
        return this.jobKeys == null ? null : this.jobKeys.iterator();
    }

    public void addToJobKeys(JobKey elem) {
        if (this.jobKeys == null) {
            this.jobKeys = new HashSet<JobKey>();
        }
        this.jobKeys.add(elem);
    }

    public Set<JobKey> getJobKeys() {
        return this.jobKeys;
    }

    public TaskQuery setJobKeys(Set<JobKey> jobKeys) {
        this.jobKeys = jobKeys;
        return this;
    }

    public void unsetJobKeys() {
        this.jobKeys = null;
    }

    public boolean isSetJobKeys() {
        return this.jobKeys != null;
    }

    public void setJobKeysIsSet(boolean value) {
        if (!value) {
            this.jobKeys = null;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public TaskQuery setOffset(int offset) {
        this.offset = offset;
        this.setOffsetIsSet(true);
        return this;
    }

    public void unsetOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getLimit() {
        return this.limit;
    }

    public TaskQuery setLimit(int limit) {
        this.limit = limit;
        this.setLimitIsSet(true);
        return this;
    }

    public void unsetLimit() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLimit() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLimitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROLE: {
                if (value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((String)value);
                break;
            }
            case ENVIRONMENT: {
                if (value == null) {
                    this.unsetEnvironment();
                    break;
                }
                this.setEnvironment((String)value);
                break;
            }
            case JOB_NAME: {
                if (value == null) {
                    this.unsetJobName();
                    break;
                }
                this.setJobName((String)value);
                break;
            }
            case TASK_IDS: {
                if (value == null) {
                    this.unsetTaskIds();
                    break;
                }
                this.setTaskIds((Set)value);
                break;
            }
            case STATUSES: {
                if (value == null) {
                    this.unsetStatuses();
                    break;
                }
                this.setStatuses((Set)value);
                break;
            }
            case INSTANCE_IDS: {
                if (value == null) {
                    this.unsetInstanceIds();
                    break;
                }
                this.setInstanceIds((Set)value);
                break;
            }
            case SLAVE_HOSTS: {
                if (value == null) {
                    this.unsetSlaveHosts();
                    break;
                }
                this.setSlaveHosts((Set)value);
                break;
            }
            case JOB_KEYS: {
                if (value == null) {
                    this.unsetJobKeys();
                    break;
                }
                this.setJobKeys((Set)value);
                break;
            }
            case OFFSET: {
                if (value == null) {
                    this.unsetOffset();
                    break;
                }
                this.setOffset((Integer)value);
                break;
            }
            case LIMIT: {
                if (value == null) {
                    this.unsetLimit();
                    break;
                }
                this.setLimit((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROLE: {
                return this.getRole();
            }
            case ENVIRONMENT: {
                return this.getEnvironment();
            }
            case JOB_NAME: {
                return this.getJobName();
            }
            case TASK_IDS: {
                return this.getTaskIds();
            }
            case STATUSES: {
                return this.getStatuses();
            }
            case INSTANCE_IDS: {
                return this.getInstanceIds();
            }
            case SLAVE_HOSTS: {
                return this.getSlaveHosts();
            }
            case JOB_KEYS: {
                return this.getJobKeys();
            }
            case OFFSET: {
                return this.getOffset();
            }
            case LIMIT: {
                return this.getLimit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROLE: {
                return this.isSetRole();
            }
            case ENVIRONMENT: {
                return this.isSetEnvironment();
            }
            case JOB_NAME: {
                return this.isSetJobName();
            }
            case TASK_IDS: {
                return this.isSetTaskIds();
            }
            case STATUSES: {
                return this.isSetStatuses();
            }
            case INSTANCE_IDS: {
                return this.isSetInstanceIds();
            }
            case SLAVE_HOSTS: {
                return this.isSetSlaveHosts();
            }
            case JOB_KEYS: {
                return this.isSetJobKeys();
            }
            case OFFSET: {
                return this.isSetOffset();
            }
            case LIMIT: {
                return this.isSetLimit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TaskQuery) {
            return this.equals((TaskQuery)that);
        }
        return false;
    }

    public boolean equals(TaskQuery that) {
        if (that == null) {
            return false;
        }
        boolean this_present_role = this.isSetRole();
        boolean that_present_role = that.isSetRole();
        if (this_present_role || that_present_role) {
            if (!this_present_role || !that_present_role) {
                return false;
            }
            if (!this.role.equals(that.role)) {
                return false;
            }
        }
        boolean this_present_environment = this.isSetEnvironment();
        boolean that_present_environment = that.isSetEnvironment();
        if (this_present_environment || that_present_environment) {
            if (!this_present_environment || !that_present_environment) {
                return false;
            }
            if (!this.environment.equals(that.environment)) {
                return false;
            }
        }
        boolean this_present_jobName = this.isSetJobName();
        boolean that_present_jobName = that.isSetJobName();
        if (this_present_jobName || that_present_jobName) {
            if (!this_present_jobName || !that_present_jobName) {
                return false;
            }
            if (!this.jobName.equals(that.jobName)) {
                return false;
            }
        }
        boolean this_present_taskIds = this.isSetTaskIds();
        boolean that_present_taskIds = that.isSetTaskIds();
        if (this_present_taskIds || that_present_taskIds) {
            if (!this_present_taskIds || !that_present_taskIds) {
                return false;
            }
            if (!this.taskIds.equals(that.taskIds)) {
                return false;
            }
        }
        boolean this_present_statuses = this.isSetStatuses();
        boolean that_present_statuses = that.isSetStatuses();
        if (this_present_statuses || that_present_statuses) {
            if (!this_present_statuses || !that_present_statuses) {
                return false;
            }
            if (!this.statuses.equals(that.statuses)) {
                return false;
            }
        }
        boolean this_present_instanceIds = this.isSetInstanceIds();
        boolean that_present_instanceIds = that.isSetInstanceIds();
        if (this_present_instanceIds || that_present_instanceIds) {
            if (!this_present_instanceIds || !that_present_instanceIds) {
                return false;
            }
            if (!this.instanceIds.equals(that.instanceIds)) {
                return false;
            }
        }
        boolean this_present_slaveHosts = this.isSetSlaveHosts();
        boolean that_present_slaveHosts = that.isSetSlaveHosts();
        if (this_present_slaveHosts || that_present_slaveHosts) {
            if (!this_present_slaveHosts || !that_present_slaveHosts) {
                return false;
            }
            if (!this.slaveHosts.equals(that.slaveHosts)) {
                return false;
            }
        }
        boolean this_present_jobKeys = this.isSetJobKeys();
        boolean that_present_jobKeys = that.isSetJobKeys();
        if (this_present_jobKeys || that_present_jobKeys) {
            if (!this_present_jobKeys || !that_present_jobKeys) {
                return false;
            }
            if (!this.jobKeys.equals(that.jobKeys)) {
                return false;
            }
        }
        boolean this_present_offset = true;
        boolean that_present_offset = true;
        if (this_present_offset || that_present_offset) {
            if (!this_present_offset || !that_present_offset) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
        }
        boolean this_present_limit = true;
        boolean that_present_limit = true;
        if (this_present_limit || that_present_limit) {
            if (!this_present_limit || !that_present_limit) {
                return false;
            }
            if (this.limit != that.limit) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_role = this.isSetRole();
        list.add(present_role);
        if (present_role) {
            list.add(this.role);
        }
        boolean present_environment = this.isSetEnvironment();
        list.add(present_environment);
        if (present_environment) {
            list.add(this.environment);
        }
        boolean present_jobName = this.isSetJobName();
        list.add(present_jobName);
        if (present_jobName) {
            list.add(this.jobName);
        }
        boolean present_taskIds = this.isSetTaskIds();
        list.add(present_taskIds);
        if (present_taskIds) {
            list.add(this.taskIds);
        }
        boolean present_statuses = this.isSetStatuses();
        list.add(present_statuses);
        if (present_statuses) {
            list.add(this.statuses);
        }
        boolean present_instanceIds = this.isSetInstanceIds();
        list.add(present_instanceIds);
        if (present_instanceIds) {
            list.add(this.instanceIds);
        }
        boolean present_slaveHosts = this.isSetSlaveHosts();
        list.add(present_slaveHosts);
        if (present_slaveHosts) {
            list.add(this.slaveHosts);
        }
        boolean present_jobKeys = this.isSetJobKeys();
        list.add(present_jobKeys);
        if (present_jobKeys) {
            list.add(this.jobKeys);
        }
        boolean present_offset = true;
        list.add(present_offset);
        if (present_offset) {
            list.add(this.offset);
        }
        boolean present_limit = true;
        list.add(present_limit);
        if (present_limit) {
            list.add(this.limit);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TaskQuery other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRole() && (lastComparison = TBaseHelper.compareTo((String)this.role, (String)other.role)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEnvironment()).compareTo(other.isSetEnvironment());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvironment() && (lastComparison = TBaseHelper.compareTo((String)this.environment, (String)other.environment)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetJobName()).compareTo(other.isSetJobName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobName() && (lastComparison = TBaseHelper.compareTo((String)this.jobName, (String)other.jobName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskIds()).compareTo(other.isSetTaskIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskIds() && (lastComparison = TBaseHelper.compareTo(this.taskIds, other.taskIds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatuses()).compareTo(other.isSetStatuses());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatuses() && (lastComparison = TBaseHelper.compareTo(this.statuses, other.statuses)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInstanceIds()).compareTo(other.isSetInstanceIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInstanceIds() && (lastComparison = TBaseHelper.compareTo(this.instanceIds, other.instanceIds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSlaveHosts()).compareTo(other.isSetSlaveHosts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSlaveHosts() && (lastComparison = TBaseHelper.compareTo(this.slaveHosts, other.slaveHosts)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetJobKeys()).compareTo(other.isSetJobKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobKeys() && (lastComparison = TBaseHelper.compareTo(this.jobKeys, other.jobKeys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOffset()).compareTo(other.isSetOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffset() && (lastComparison = TBaseHelper.compareTo((int)this.offset, (int)other.offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLimit()).compareTo(other.isSetLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLimit() && (lastComparison = TBaseHelper.compareTo((int)this.limit, (int)other.limit)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TaskQuery(");
        boolean first = true;
        sb.append("role:");
        if (this.role == null) {
            sb.append("null");
        } else {
            sb.append(this.role);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("environment:");
        if (this.environment == null) {
            sb.append("null");
        } else {
            sb.append(this.environment);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("jobName:");
        if (this.jobName == null) {
            sb.append("null");
        } else {
            sb.append(this.jobName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("taskIds:");
        if (this.taskIds == null) {
            sb.append("null");
        } else {
            sb.append(this.taskIds);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("statuses:");
        if (this.statuses == null) {
            sb.append("null");
        } else {
            sb.append(this.statuses);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("instanceIds:");
        if (this.instanceIds == null) {
            sb.append("null");
        } else {
            sb.append(this.instanceIds);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("slaveHosts:");
        if (this.slaveHosts == null) {
            sb.append("null");
        } else {
            sb.append(this.slaveHosts);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("jobKeys:");
        if (this.jobKeys == null) {
            sb.append("null");
        } else {
            sb.append(this.jobKeys);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("offset:");
        sb.append(this.offset);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("limit:");
        sb.append(this.limit);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TaskQueryStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TaskQueryTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROLE, new FieldMetaData("role", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ENVIRONMENT, new FieldMetaData("environment", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.JOB_NAME, new FieldMetaData("jobName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TASK_IDS, new FieldMetaData("taskIds", 3, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.STATUSES, new FieldMetaData("statuses", 3, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new EnumMetaData(16, ScheduleStatus.class))));
        tmpMap.put(_Fields.INSTANCE_IDS, new FieldMetaData("instanceIds", 3, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.SLAVE_HOSTS, new FieldMetaData("slaveHosts", 3, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.JOB_KEYS, new FieldMetaData("jobKeys", 3, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, JobKey.class))));
        tmpMap.put(_Fields.OFFSET, new FieldMetaData("offset", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LIMIT, new FieldMetaData("limit", 3, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TaskQuery.class, metaDataMap);
    }

    private static class TaskQueryTupleScheme
    extends TupleScheme<TaskQuery> {
        private TaskQueryTupleScheme() {
        }

        public void write(TProtocol prot, TaskQuery struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetRole()) {
                optionals.set(0);
            }
            if (struct.isSetEnvironment()) {
                optionals.set(1);
            }
            if (struct.isSetJobName()) {
                optionals.set(2);
            }
            if (struct.isSetTaskIds()) {
                optionals.set(3);
            }
            if (struct.isSetStatuses()) {
                optionals.set(4);
            }
            if (struct.isSetInstanceIds()) {
                optionals.set(5);
            }
            if (struct.isSetSlaveHosts()) {
                optionals.set(6);
            }
            if (struct.isSetJobKeys()) {
                optionals.set(7);
            }
            if (struct.isSetOffset()) {
                optionals.set(8);
            }
            if (struct.isSetLimit()) {
                optionals.set(9);
            }
            oprot.writeBitSet(optionals, 10);
            if (struct.isSetRole()) {
                oprot.writeString(struct.role);
            }
            if (struct.isSetEnvironment()) {
                oprot.writeString(struct.environment);
            }
            if (struct.isSetJobName()) {
                oprot.writeString(struct.jobName);
            }
            if (struct.isSetTaskIds()) {
                oprot.writeI32(struct.taskIds.size());
                for (String _iter162 : struct.taskIds) {
                    oprot.writeString(_iter162);
                }
            }
            if (struct.isSetStatuses()) {
                oprot.writeI32(struct.statuses.size());
                for (ScheduleStatus _iter163 : struct.statuses) {
                    oprot.writeI32(_iter163.getValue());
                }
            }
            if (struct.isSetInstanceIds()) {
                oprot.writeI32(struct.instanceIds.size());
                Iterator<Object> iterator = struct.instanceIds.iterator();
                while (iterator.hasNext()) {
                    int _iter164 = (Integer)iterator.next();
                    oprot.writeI32(_iter164);
                }
            }
            if (struct.isSetSlaveHosts()) {
                oprot.writeI32(struct.slaveHosts.size());
                for (String _iter165 : struct.slaveHosts) {
                    oprot.writeString(_iter165);
                }
            }
            if (struct.isSetJobKeys()) {
                oprot.writeI32(struct.jobKeys.size());
                for (JobKey _iter166 : struct.jobKeys) {
                    _iter166.write((TProtocol)oprot);
                }
            }
            if (struct.isSetOffset()) {
                oprot.writeI32(struct.offset);
            }
            if (struct.isSetLimit()) {
                oprot.writeI32(struct.limit);
            }
        }

        public void read(TProtocol prot, TaskQuery struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(10);
            if (incoming.get(0)) {
                struct.role = iprot.readString();
                struct.setRoleIsSet(true);
            }
            if (incoming.get(1)) {
                struct.environment = iprot.readString();
                struct.setEnvironmentIsSet(true);
            }
            if (incoming.get(2)) {
                struct.jobName = iprot.readString();
                struct.setJobNameIsSet(true);
            }
            if (incoming.get(3)) {
                TSet _set167 = new TSet(11, iprot.readI32());
                struct.taskIds = new HashSet<String>(2 * _set167.size);
                for (int _i169 = 0; _i169 < _set167.size; ++_i169) {
                    String _elem168 = iprot.readString();
                    struct.taskIds.add(_elem168);
                }
                struct.setTaskIdsIsSet(true);
            }
            if (incoming.get(4)) {
                TSet _set170 = new TSet(8, iprot.readI32());
                struct.statuses = new HashSet<ScheduleStatus>(2 * _set170.size);
                for (int _i172 = 0; _i172 < _set170.size; ++_i172) {
                    ScheduleStatus _elem171 = ScheduleStatus.findByValue(iprot.readI32());
                    struct.statuses.add(_elem171);
                }
                struct.setStatusesIsSet(true);
            }
            if (incoming.get(5)) {
                TSet _set173 = new TSet(8, iprot.readI32());
                struct.instanceIds = new HashSet<Integer>(2 * _set173.size);
                for (int _i175 = 0; _i175 < _set173.size; ++_i175) {
                    int _elem174 = iprot.readI32();
                    struct.instanceIds.add(_elem174);
                }
                struct.setInstanceIdsIsSet(true);
            }
            if (incoming.get(6)) {
                TSet _set176 = new TSet(11, iprot.readI32());
                struct.slaveHosts = new HashSet<String>(2 * _set176.size);
                for (int _i178 = 0; _i178 < _set176.size; ++_i178) {
                    String _elem177 = iprot.readString();
                    struct.slaveHosts.add(_elem177);
                }
                struct.setSlaveHostsIsSet(true);
            }
            if (incoming.get(7)) {
                TSet _set179 = new TSet(12, iprot.readI32());
                struct.jobKeys = new HashSet<JobKey>(2 * _set179.size);
                for (int _i181 = 0; _i181 < _set179.size; ++_i181) {
                    JobKey _elem180 = new JobKey();
                    _elem180.read((TProtocol)iprot);
                    struct.jobKeys.add(_elem180);
                }
                struct.setJobKeysIsSet(true);
            }
            if (incoming.get(8)) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
            }
            if (incoming.get(9)) {
                struct.limit = iprot.readI32();
                struct.setLimitIsSet(true);
            }
        }
    }

    private static class TaskQueryTupleSchemeFactory
    implements SchemeFactory {
        private TaskQueryTupleSchemeFactory() {
        }

        public TaskQueryTupleScheme getScheme() {
            return new TaskQueryTupleScheme();
        }
    }

    private static class TaskQueryStandardScheme
    extends StandardScheme<TaskQuery> {
        private TaskQueryStandardScheme() {
        }

        public void read(TProtocol iprot, TaskQuery struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 14: {
                        if (schemeField.type == 11) {
                            struct.role = iprot.readString();
                            struct.setRoleIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.environment = iprot.readString();
                            struct.setEnvironmentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.jobName = iprot.readString();
                            struct.setJobNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 14) {
                            TSet _set142 = iprot.readSetBegin();
                            struct.taskIds = new HashSet<String>(2 * _set142.size);
                            for (int _i144 = 0; _i144 < _set142.size; ++_i144) {
                                String _elem143 = iprot.readString();
                                struct.taskIds.add(_elem143);
                            }
                            iprot.readSetEnd();
                            struct.setTaskIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 14) {
                            TSet _set145 = iprot.readSetBegin();
                            struct.statuses = new HashSet<ScheduleStatus>(2 * _set145.size);
                            for (int _i147 = 0; _i147 < _set145.size; ++_i147) {
                                ScheduleStatus _elem146 = ScheduleStatus.findByValue(iprot.readI32());
                                struct.statuses.add(_elem146);
                            }
                            iprot.readSetEnd();
                            struct.setStatusesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 14) {
                            TSet _set148 = iprot.readSetBegin();
                            struct.instanceIds = new HashSet<Integer>(2 * _set148.size);
                            for (int _i150 = 0; _i150 < _set148.size; ++_i150) {
                                int _elem149 = iprot.readI32();
                                struct.instanceIds.add(_elem149);
                            }
                            iprot.readSetEnd();
                            struct.setInstanceIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 14) {
                            TSet _set151 = iprot.readSetBegin();
                            struct.slaveHosts = new HashSet<String>(2 * _set151.size);
                            for (int _i153 = 0; _i153 < _set151.size; ++_i153) {
                                String _elem152 = iprot.readString();
                                struct.slaveHosts.add(_elem152);
                            }
                            iprot.readSetEnd();
                            struct.setSlaveHostsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 14) {
                            TSet _set154 = iprot.readSetBegin();
                            struct.jobKeys = new HashSet<JobKey>(2 * _set154.size);
                            for (int _i156 = 0; _i156 < _set154.size; ++_i156) {
                                JobKey _elem155 = new JobKey();
                                _elem155.read(iprot);
                                struct.jobKeys.add(_elem155);
                            }
                            iprot.readSetEnd();
                            struct.setJobKeysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 8) {
                            struct.offset = iprot.readI32();
                            struct.setOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 8) {
                            struct.limit = iprot.readI32();
                            struct.setLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TaskQuery struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.jobName != null) {
                oprot.writeFieldBegin(JOB_NAME_FIELD_DESC);
                oprot.writeString(struct.jobName);
                oprot.writeFieldEnd();
            }
            if (struct.taskIds != null) {
                oprot.writeFieldBegin(TASK_IDS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.taskIds.size()));
                for (String _iter157 : struct.taskIds) {
                    oprot.writeString(_iter157);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.statuses != null) {
                oprot.writeFieldBegin(STATUSES_FIELD_DESC);
                oprot.writeSetBegin(new TSet(8, struct.statuses.size()));
                for (ScheduleStatus _iter158 : struct.statuses) {
                    oprot.writeI32(_iter158.getValue());
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.instanceIds != null) {
                oprot.writeFieldBegin(INSTANCE_IDS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(8, struct.instanceIds.size()));
                Iterator<Object> iterator = struct.instanceIds.iterator();
                while (iterator.hasNext()) {
                    int _iter159 = (Integer)iterator.next();
                    oprot.writeI32(_iter159);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.environment != null) {
                oprot.writeFieldBegin(ENVIRONMENT_FIELD_DESC);
                oprot.writeString(struct.environment);
                oprot.writeFieldEnd();
            }
            if (struct.slaveHosts != null) {
                oprot.writeFieldBegin(SLAVE_HOSTS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.slaveHosts.size()));
                for (String _iter160 : struct.slaveHosts) {
                    oprot.writeString(_iter160);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.jobKeys != null) {
                oprot.writeFieldBegin(JOB_KEYS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.jobKeys.size()));
                for (JobKey _iter161 : struct.jobKeys) {
                    _iter161.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(OFFSET_FIELD_DESC);
            oprot.writeI32(struct.offset);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(LIMIT_FIELD_DESC);
            oprot.writeI32(struct.limit);
            oprot.writeFieldEnd();
            if (struct.role != null) {
                oprot.writeFieldBegin(ROLE_FIELD_DESC);
                oprot.writeString(struct.role);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TaskQueryStandardSchemeFactory
    implements SchemeFactory {
        private TaskQueryStandardSchemeFactory() {
        }

        public TaskQueryStandardScheme getScheme() {
            return new TaskQueryStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROLE(14, "role"),
        ENVIRONMENT(9, "environment"),
        JOB_NAME(2, "jobName"),
        TASK_IDS(4, "taskIds"),
        STATUSES(5, "statuses"),
        INSTANCE_IDS(7, "instanceIds"),
        SLAVE_HOSTS(10, "slaveHosts"),
        JOB_KEYS(11, "jobKeys"),
        OFFSET(12, "offset"),
        LIMIT(13, "limit");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 14: {
                    return ROLE;
                }
                case 9: {
                    return ENVIRONMENT;
                }
                case 2: {
                    return JOB_NAME;
                }
                case 4: {
                    return TASK_IDS;
                }
                case 5: {
                    return STATUSES;
                }
                case 7: {
                    return INSTANCE_IDS;
                }
                case 10: {
                    return SLAVE_HOSTS;
                }
                case 11: {
                    return JOB_KEYS;
                }
                case 12: {
                    return OFFSET;
                }
                case 13: {
                    return LIMIT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

