/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.sample.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.tabletscan.thrift.TSamplerConfiguration;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Writable;

public class SamplerConfigurationImpl
implements Writable {
    private String className;
    private Map<String, String> options;

    public SamplerConfigurationImpl(DataInput in) throws IOException {
        this.readFields(in);
    }

    public SamplerConfigurationImpl(SamplerConfiguration sc) {
        this.className = sc.getSamplerClassName();
        this.options = new HashMap<String, String>(sc.getOptions());
    }

    public SamplerConfigurationImpl(String className, Map<String, String> options) {
        this.className = className;
        this.options = options;
    }

    public SamplerConfigurationImpl() {
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public int hashCode() {
        return 31 * this.className.hashCode() + this.options.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SamplerConfigurationImpl) {
            SamplerConfigurationImpl osc = (SamplerConfigurationImpl)o;
            return this.className.equals(osc.className) && this.options.equals(osc.options);
        }
        return false;
    }

    public void write(DataOutput out) throws IOException {
        out.write(1);
        out.writeUTF(this.className);
        out.writeInt(this.options.size());
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version != 1) {
            throw new IllegalArgumentException("Unexpected version " + version);
        }
        this.className = in.readUTF();
        this.options = new HashMap<String, String>();
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            String key = in.readUTF();
            String val = in.readUTF();
            this.options.put(key, val);
        }
    }

    public SamplerConfiguration toSamplerConfiguration() {
        SamplerConfiguration sc = new SamplerConfiguration(this.className);
        sc.setOptions(this.options);
        return sc;
    }

    public List<Pair<String, String>> toTableProperties() {
        ArrayList<Pair<String, String>> props = new ArrayList<Pair<String, String>>();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            props.add(new Pair<CallSite, String>((CallSite)((Object)(Property.TABLE_SAMPLER_OPTS.getKey() + entry.getKey())), entry.getValue()));
        }
        props.add(new Pair<String, String>(Property.TABLE_SAMPLER.getKey(), this.className));
        return props;
    }

    public Map<String, String> toTablePropertiesMap() {
        LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
        for (Pair<String, String> pair : this.toTableProperties()) {
            propsMap.put(pair.getFirst(), pair.getSecond());
        }
        return propsMap;
    }

    public static SamplerConfigurationImpl newSamplerConfig(AccumuloConfiguration acuconf) {
        String className = acuconf.get(Property.TABLE_SAMPLER);
        if (className == null || className.equals("")) {
            return null;
        }
        Map<String, String> rawOptions = acuconf.getAllPropertiesWithPrefix(Property.TABLE_SAMPLER_OPTS);
        HashMap<String, String> options = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : rawOptions.entrySet()) {
            String key = entry.getKey().substring(Property.TABLE_SAMPLER_OPTS.getKey().length());
            options.put(key, entry.getValue());
        }
        return new SamplerConfigurationImpl(className, options);
    }

    public String toString() {
        return this.className + " " + this.options;
    }

    public static TSamplerConfiguration toThrift(SamplerConfiguration samplerConfig) {
        if (samplerConfig == null) {
            return null;
        }
        return new TSamplerConfiguration(samplerConfig.getSamplerClassName(), samplerConfig.getOptions());
    }

    public static SamplerConfiguration fromThrift(TSamplerConfiguration tsc) {
        if (tsc == null) {
            return null;
        }
        return new SamplerConfiguration(tsc.getClassName()).setOptions(tsc.getOptions());
    }
}

