/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto.streams;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BlockedOutputStream
extends OutputStream {
    int blockSize;
    DataOutputStream out;
    ByteBuffer bb;

    public BlockedOutputStream(OutputStream out, int blockSize, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0.");
        }
        this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        this.blockSize = blockSize;
        int remainder = bufferSize % blockSize;
        if (remainder != 0) {
            remainder = blockSize - remainder;
        }
        this.bb = ByteBuffer.allocate(bufferSize + remainder - 4);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.bb.hasArray()) {
            throw new IllegalStateException("BlockedOutputStream has no backing array.");
        }
        int size = this.bb.position();
        if (size == 0) {
            return;
        }
        this.out.writeInt(size);
        int remainder = (size + 4) % this.blockSize;
        if (remainder != 0) {
            remainder = this.blockSize - remainder;
        }
        this.bb.position(size + remainder);
        this.out.write(this.bb.array(), 0, size + remainder);
        this.out.flush();
        this.bb.rewind();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bb.remaining() == 0) {
            this.flush();
        }
        this.bb.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len >= this.bb.remaining()) {
            int remaining = this.bb.remaining();
            this.bb.put(b, off, remaining);
            this.flush();
            off += remaining;
            len -= remaining;
        }
        this.bb.put(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

