/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.bulk.Bulk;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.util.json.ByteArrayToBase64TypeAdapter;

public class LoadMappingIterator
implements Iterator<Map.Entry<KeyExtent, Bulk.Files>>,
AutoCloseable {
    private final TableId tableId;
    private final JsonReader reader;
    private static final Gson gson = ByteArrayToBase64TypeAdapter.createBase64Gson();
    private Map<String, String> renameMap;

    LoadMappingIterator(TableId tableId, InputStream loadMappingFile) throws IOException {
        this.tableId = tableId;
        this.reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(loadMappingFile, StandardCharsets.UTF_8)));
        this.reader.beginArray();
    }

    public void setRenameMap(Map<String, String> renameMap) {
        this.renameMap = renameMap;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.hasNext();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Map.Entry<KeyExtent, Bulk.Files> next() {
        Bulk.Mapping bm = (Bulk.Mapping)gson.fromJson(this.reader, Bulk.Mapping.class);
        if (this.renameMap != null) {
            return new AbstractMap.SimpleEntry<KeyExtent, Bulk.Files>(bm.getKeyExtent(this.tableId), bm.getFiles().mapNames(this.renameMap));
        }
        return new AbstractMap.SimpleEntry<KeyExtent, Bulk.Files>(bm.getKeyExtent(this.tableId), bm.getFiles());
    }
}

