/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.upgrade;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.manager.EventCoordinator;
import org.apache.accumulo.server.AccumuloDataVersion;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreUpgradeValidation {
    private static final Logger log = LoggerFactory.getLogger(PreUpgradeValidation.class);

    public void validate(ServerContext context, EventCoordinator eventCoordinator) {
        int cv = AccumuloDataVersion.getCurrentVersion((ServerContext)context);
        if (cv == AccumuloDataVersion.get()) {
            log.debug("already at current data version: {}, skipping validation", (Object)cv);
            return;
        }
        this.validateACLs(context);
    }

    private void validateACLs(ServerContext context) {
        AtomicBoolean aclErrorOccurred = new AtomicBoolean(false);
        ZooReaderWriter zrw = context.getZooReaderWriter();
        ZooKeeper zk = zrw.getZooKeeper();
        String rootPath = context.getZooKeeperRoot();
        Set<String> users = Set.of("accumulo", "anyone");
        log.info("Starting validation on ZooKeeper ACLs");
        try {
            ZKUtil.visitSubTreeDFS((ZooKeeper)zk, (String)rootPath, (boolean)false, (rc, path, ctx, name) -> {
                try {
                    List acls = zk.getACL(path, new Stat());
                    if (!PreUpgradeValidation.hasAllPermissions(users, acls)) {
                        log.error("ZNode at {} does not have an ACL that allows accumulo to write to it. ZNode ACL will need to be modified. Current ACLs: {}", (Object)path, (Object)acls);
                        aclErrorOccurred.set(true);
                    }
                }
                catch (InterruptedException | KeeperException e) {
                    log.error("Error getting ACL for path: {}", (Object)path, (Object)e);
                    aclErrorOccurred.set(true);
                }
            });
            if (aclErrorOccurred.get()) {
                throw new RuntimeException("Upgrade precondition failed! ACLs will need to be modified for some ZooKeeper nodes. Check the log for specific failed paths, check ZooKeeper troubleshooting in user documentation for instructions on how to fix.");
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Upgrade Failed! Error validating nodes under " + rootPath, e);
        }
        log.info("Successfully completed validation on ZooKeeper ACLs");
    }

    private static boolean hasAllPermissions(Set<String> users, List<ACL> acls) {
        return acls.stream().anyMatch(a -> users.contains(PreUpgradeValidation.extractAuthName(a)) && a.getPerms() == 31);
    }

    private static String extractAuthName(ACL acl) {
        Objects.requireNonNull(acl, "provided ACL cannot be null");
        try {
            return acl.getId().getId().trim().split(":")[0];
        }
        catch (Exception ex) {
            log.debug("Invalid ACL passed, cannot parse id from '{}'", (Object)acl);
            return "";
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Want to immediately stop all threads on upgrade error")
    private void fail(Exception e) {
        log.error("FATAL: Error performing pre-upgrade checks", (Throwable)e);
        System.exit(1);
    }
}

