/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.metrics.fate;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.fate.AdminUtil;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.manager.metrics.fate.FateMetrics;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FateMetricValues {
    private static final Logger log = LoggerFactory.getLogger(FateMetricValues.class);
    private final long updateTime;
    private final long currentFateOps;
    private final long zkFateChildOpsTotal;
    private final long zkConnectionErrors;
    private final Map<String, Long> txStateCounters;
    private final Map<String, Long> opTypeCounters;

    private FateMetricValues(long updateTime, long currentFateOps, long zkFateChildOpsTotal, long zkConnectionErrors, Map<String, Long> txStateCounters, Map<String, Long> opTypeCounters) {
        this.updateTime = updateTime;
        this.currentFateOps = currentFateOps;
        this.zkFateChildOpsTotal = zkFateChildOpsTotal;
        this.zkConnectionErrors = zkConnectionErrors;
        this.txStateCounters = txStateCounters;
        this.opTypeCounters = opTypeCounters;
    }

    long getCurrentFateOps() {
        return this.currentFateOps;
    }

    long getZkFateChildOpsTotal() {
        return this.zkFateChildOpsTotal;
    }

    long getZkConnectionErrors() {
        return this.zkConnectionErrors;
    }

    Map<String, Long> getTxStateCounters() {
        return this.txStateCounters;
    }

    Map<String, Long> getOpTypeCounters() {
        return this.opTypeCounters;
    }

    public static FateMetricValues getFromZooKeeper(ServerContext context, String fateRootPath, ReadOnlyTStore<FateMetrics> zooStore) {
        Builder builder = FateMetricValues.builder();
        AdminUtil admin = new AdminUtil(false);
        try {
            List currFates = admin.getTransactionStatus(zooStore, null, null);
            builder.withCurrentFateOps(currFates.size());
            TreeMap<String, Long> states = new TreeMap<String, Long>();
            for (ReadOnlyTStore.TStatus t : ReadOnlyTStore.TStatus.values()) {
                states.put(t.name(), 0L);
            }
            TreeMap<String, Long> opTypeCounters = new TreeMap<String, Long>();
            for (AdminUtil.TransactionStatus tx : currFates) {
                String stateName = tx.getStatus().name();
                states.merge(stateName, 1L, Long::sum);
                if (!ReadOnlyTStore.TStatus.IN_PROGRESS.equals((Object)tx.getStatus())) continue;
                String opType = tx.getTxName();
                if (opType == null || opType.isEmpty()) {
                    opType = "UNKNOWN";
                }
                opTypeCounters.merge(opType, 1L, Long::sum);
            }
            builder.withTxStateCounters(states);
            builder.withOpTypeCounters(opTypeCounters);
            Stat node = context.getZooReaderWriter().getZooKeeper().exists(fateRootPath, false);
            builder.withZkFateChildOpsTotal(node.getCversion());
            if (log.isTraceEnabled()) {
                log.trace("ZkNodeStat: {czxid: {}, mzxid: {}, pzxid: {}, ctime: {}, mtime: {}, version: {}, cversion: {}, num children: {}", new Object[]{node.getCzxid(), node.getMzxid(), node.getPzxid(), node.getCtime(), node.getMtime(), node.getVersion(), node.getCversion(), node.getNumChildren()});
            }
        }
        catch (KeeperException ex) {
            log.debug("Error connecting to ZooKeeper", (Throwable)ex);
            builder.incrZkConnectionErrors();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return builder.build();
    }

    public String toString() {
        return "FateMetricValues{updateTime=" + this.updateTime + ", currentFateOps=" + this.currentFateOps + ", zkFateChildOpsTotal=" + this.zkFateChildOpsTotal + ", zkConnectionErrors=" + this.zkConnectionErrors + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private long currentFateOps = 0L;
        private long zkFateChildOpsTotal = 0L;
        private long zkConnectionErrors = 0L;
        private final Map<String, Long> txStateCounters = new TreeMap<String, Long>();
        private Map<String, Long> opTypeCounters;

        Builder() {
            for (ReadOnlyTStore.TStatus t : ReadOnlyTStore.TStatus.values()) {
                this.txStateCounters.put(t.name(), 0L);
            }
            this.opTypeCounters = Collections.emptyMap();
        }

        Builder withCurrentFateOps(long value) {
            this.currentFateOps = value;
            return this;
        }

        Builder withZkFateChildOpsTotal(long value) {
            this.zkFateChildOpsTotal = value;
            return this;
        }

        Builder incrZkConnectionErrors() {
            ++this.zkConnectionErrors;
            return this;
        }

        Builder withZkConnectionErrors(long value) {
            this.zkConnectionErrors = value;
            return this;
        }

        Builder withTxStateCounters(Map<String, Long> txStateCounters) {
            this.txStateCounters.putAll(txStateCounters);
            return this;
        }

        Builder withOpTypeCounters(Map<String, Long> opTypeCounters) {
            this.opTypeCounters = new TreeMap<String, Long>(opTypeCounters);
            return this;
        }

        FateMetricValues build() {
            return new FateMetricValues(System.currentTimeMillis(), this.currentFateOps, this.zkFateChildOpsTotal, this.zkConnectionErrors, this.txStateCounters, this.opTypeCounters);
        }
    }
}

