/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.stress.random;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.cli.ClientOnDefaultTable;
import org.apache.accumulo.test.stress.random.IntArgValidator;

class WriteOptions
extends ClientOnDefaultTable {
    static final String DEFAULT_TABLE = "stress_test";
    static final int DEFAULT_MIN = 1;
    static final int DEFAULT_MAX = 128;
    static final int DEFAULT_SPREAD = 127;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--min-row-size"}, description="minimum row size")
    Integer row_min;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--max-row-size"}, description="maximum row size")
    Integer row_max;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--min-cf-size"}, description="minimum column family size")
    Integer cf_min;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--max-cf-size"}, description="maximum column family size")
    Integer cf_max;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--min-cq-size"}, description="minimum column qualifier size")
    Integer cq_min;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--max-cq-size"}, description="maximum column qualifier size")
    Integer cq_max;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--min-value-size"}, description="minimum value size")
    Integer value_min;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--max-value-size"}, description="maximum value size")
    Integer value_max;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--min-row-width"}, description="minimum row width")
    Integer row_width_min;
    @Parameter(validateValueWith={IntArgValidator.class}, names={"--max-row-width"}, description="maximum row width")
    Integer row_width_max;
    @Parameter(names={"--clear-table"}, description="clears the table before ingesting")
    boolean clear_table;
    @Parameter(names={"--row-seed"}, description="seed for generating rows")
    int row_seed = 87;
    @Parameter(names={"--cf-seed"}, description="seed for generating column families")
    int cf_seed = 7;
    @Parameter(names={"--cq-seed"}, description="seed for generating column qualifiers")
    int cq_seed = 43;
    @Parameter(names={"--value-seed"}, description="seed for generating values")
    int value_seed = 99;
    @Parameter(names={"--row-width-seed"}, description="seed for generating the number of cells within a row (a row's \"width\")")
    int row_width_seed = 444;
    @Parameter(names={"--max-cells-per-mutation"}, description="maximum number of cells per mutation; non-positive value implies no limit")
    int max_cells_per_mutation = -1;
    @Parameter(names={"--write-delay"}, description="milliseconds to wait between writes")
    long write_delay = 0L;

    public WriteOptions(String table) {
        super(table);
    }

    public WriteOptions() {
        this(DEFAULT_TABLE);
    }

    private static int minOrDefault(Integer ref) {
        return ref == null ? 1 : ref;
    }

    private static int calculateMax(Integer min_ref, Integer max_ref) {
        if (max_ref == null) {
            if (min_ref == null) {
                return 128;
            }
            return min_ref + 127;
        }
        return max_ref;
    }

    public void check() {
        this.checkPair("ROW", this.row_min, this.row_max);
        this.checkPair("COLUMN FAMILY", this.cf_min, this.cf_max);
        this.checkPair("COLUMN QUALIFIER", this.cq_min, this.cq_max);
        this.checkPair("VALUE", this.value_min, this.value_max);
    }

    public void checkPair(String label, Integer min_ref, Integer max_ref) {
        if (min_ref == null && max_ref != null) {
            throw new IllegalArgumentException(String.format("[%s] Maximum value supplied, but no minimum. Must supply a minimum with a maximum value.", label));
        }
        if (min_ref != null && max_ref != null && min_ref.compareTo(max_ref) > 0) {
            throw new IllegalArgumentException(String.format("[%s] Min value (%d) is greater than max value (%d)", label, min_ref, max_ref));
        }
    }

    public int rowMin() {
        return WriteOptions.minOrDefault(this.row_min);
    }

    public int rowMax() {
        return WriteOptions.calculateMax(this.row_min, this.row_max);
    }

    public int cfMin() {
        return WriteOptions.minOrDefault(this.cf_min);
    }

    public int cfMax() {
        return WriteOptions.calculateMax(this.cf_min, this.cf_max);
    }

    public int cqMin() {
        return WriteOptions.minOrDefault(this.cq_min);
    }

    public int cqMax() {
        return WriteOptions.calculateMax(this.cq_min, this.cq_max);
    }

    public int valueMin() {
        return WriteOptions.minOrDefault(this.value_min);
    }

    public int valueMax() {
        return WriteOptions.calculateMax(this.value_min, this.value_max);
    }

    public int rowWidthMin() {
        return WriteOptions.minOrDefault(this.row_width_min);
    }

    public int rowWidthMax() {
        return WriteOptions.calculateMax(this.row_width_min, this.row_width_max);
    }
}

