/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.multitable.CopyTool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CopyTable
extends Test {
    private final TreeSet<Text> splits = new TreeSet();

    public CopyTable() {
        for (int i = 1; i < 10; ++i) {
            this.splits.add(new Text(Integer.toString(i)));
        }
    }

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        List tables = (List)state.get("tableList");
        if (tables.isEmpty()) {
            return;
        }
        Random rand = new Random();
        String srcTableName = (String)tables.remove(rand.nextInt(tables.size()));
        int nextId = (Integer)state.get("nextId");
        String dstTableName = String.format("%s_%d", state.getString("tableNamePrefix"), nextId);
        String[] args = new String[8];
        args[0] = "-libjars";
        args[1] = this.getMapReduceJars();
        args[2] = env.getUserName();
        args[3] = env.getPassword();
        if (null == args[3]) {
            args[3] = env.getKeytab();
        }
        args[4] = srcTableName;
        args[5] = env.getInstance().getInstanceName();
        args[6] = env.getConfigProperty("ZOOKEEPERS");
        args[7] = dstTableName;
        this.log.debug((Object)("copying " + srcTableName + " to " + dstTableName));
        env.getConnector().tableOperations().create(dstTableName);
        env.getConnector().tableOperations().addSplits(dstTableName, this.splits);
        if (ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new CopyTool(), (String[])args) != 0) {
            this.log.error((Object)"Failed to run map/red verify");
            return;
        }
        String tableId = (String)Tables.getNameToIdMap((Instance)env.getInstance()).get(dstTableName);
        this.log.debug((Object)("copied " + srcTableName + " to " + dstTableName + " (id - " + tableId + " )"));
        tables.add(dstTableName);
        env.getConnector().tableOperations().delete(srcTableName);
        this.log.debug((Object)("dropped " + srcTableName));
        state.set("nextId", ++nextId);
    }
}

