/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.TreeMap;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.MemoryUsageTest;
import org.apache.hadoop.io.Text;

class TextMemoryUsageTest
extends MemoryUsageTest {
    private int keyLen;
    private int colFamLen;
    private int colQualLen;
    private int dataLen;
    private TreeMap<Text, Value> map;
    private int passes;

    TextMemoryUsageTest(int passes, int keyLen, int colFamLen, int colQualLen, int dataLen) {
        this.keyLen = keyLen;
        this.colFamLen = colFamLen;
        this.colQualLen = colQualLen;
        this.dataLen = dataLen;
        this.passes = passes;
    }

    @Override
    void init() {
        this.map = new TreeMap();
    }

    @Override
    public void addEntry(int i) {
        Text key = new Text(String.format("%0" + this.keyLen + "d:%0" + this.colFamLen + "d:%0" + this.colQualLen + "d", i, 0, 0).getBytes());
        byte[] data = new byte[this.dataLen];
        for (int j = 0; j < data.length; ++j) {
            data[j] = (byte)(j % 10 + 65);
        }
        Value value = new Value(data);
        this.map.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.map = null;
    }

    @Override
    public int getEstimatedBytesPerEntry() {
        return this.keyLen + this.colFamLen + this.colQualLen + this.dataLen;
    }

    @Override
    int getNumPasses() {
        return this.passes;
    }

    @Override
    String getName() {
        return "Text " + this.keyLen + " " + this.colFamLen + " " + this.colQualLen + " " + this.dataLen;
    }
}

