/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.test.util.SerializationUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchWriterIterator
extends WrappingIterator {
    private static final Logger log = LoggerFactory.getLogger(BatchWriterIterator.class);
    private Map<String, String> originalOptions;
    private int sleepAfterFirstWrite = 0;
    private int numEntriesToWritePerEntry = 10;
    private long batchWriterTimeout = 0L;
    private long batchWriterMaxMemory = 0L;
    private boolean clearCacheAfterFirstWrite = false;
    private boolean splitAfterFirstWrite = false;
    public static final String OPT_sleepAfterFirstWrite = "sleepAfterFirstWrite";
    public static final String OPT_numEntriesToWritePerEntry = "numEntriesToWritePerEntry";
    public static final String OPT_batchWriterTimeout = "batchWriterTimeout";
    public static final String OPT_batchWriterMaxMemory = "batchWriterMaxMemory";
    public static final String OPT_clearCacheAfterFirstWrite = "clearCacheAfterFirstWrite";
    public static final String OPT_splitAfterFirstWrite = "splitAfterFirstWrite";
    private String instanceName;
    private String tableName;
    private String zookeeperHost;
    private int zookeeperTimeout = -1;
    private String username;
    private AuthenticationToken auth = null;
    public static final String ZOOKEEPERHOST = "zookeeperHost";
    public static final String INSTANCENAME = "instanceName";
    public static final String TABLENAME = "tableName";
    public static final String USERNAME = "username";
    public static final String ZOOKEEPERTIMEOUT = "zookeeperTimeout";
    public static final String AUTHENTICATION_TOKEN = "authenticationToken";
    public static final String AUTHENTICATION_TOKEN_CLASS = "authenticationTokenClass";
    private BatchWriter batchWriter;
    private boolean firstWrite = true;
    private Value topValue = null;
    private Connector connector;
    public static final String SUCCESS_STRING = "success";
    public static final Value SUCCESS_VALUE = new Value("success".getBytes());

    public static IteratorSetting iteratorSetting(int priority, int sleepAfterFirstWrite, long batchWriterTimeout, long batchWriterMaxMemory, int numEntriesToWrite, String tableName, Connector connector, AuthenticationToken token, boolean clearCacheAfterFirstWrite, boolean splitAfterFirstWrite) {
        return BatchWriterIterator.iteratorSetting(priority, sleepAfterFirstWrite, batchWriterTimeout, batchWriterMaxMemory, numEntriesToWrite, tableName, connector.getInstance().getZooKeepers(), connector.getInstance().getInstanceName(), connector.getInstance().getZooKeepersSessionTimeOut(), connector.whoami(), token, clearCacheAfterFirstWrite, splitAfterFirstWrite);
    }

    public static IteratorSetting iteratorSetting(int priority, int sleepAfterFirstWrite, long batchWriterTimeout, long batchWriterMaxMemory, int numEntriesToWrite, String tableName, String zookeeperHost, String instanceName, int zookeeperTimeout, String username, AuthenticationToken token, boolean clearCacheAfterFirstWrite, boolean splitAfterFirstWrite) {
        IteratorSetting itset = new IteratorSetting(priority, BatchWriterIterator.class);
        itset.addOption(OPT_sleepAfterFirstWrite, Integer.toString(sleepAfterFirstWrite));
        itset.addOption(OPT_numEntriesToWritePerEntry, Integer.toString(numEntriesToWrite));
        itset.addOption(OPT_batchWriterTimeout, Long.toString(batchWriterTimeout));
        itset.addOption(OPT_batchWriterMaxMemory, Long.toString(batchWriterMaxMemory));
        itset.addOption(OPT_clearCacheAfterFirstWrite, Boolean.toString(clearCacheAfterFirstWrite));
        itset.addOption(OPT_splitAfterFirstWrite, Boolean.toString(splitAfterFirstWrite));
        itset.addOption(TABLENAME, tableName);
        itset.addOption(ZOOKEEPERHOST, zookeeperHost);
        itset.addOption(ZOOKEEPERTIMEOUT, Integer.toString(zookeeperTimeout));
        itset.addOption(INSTANCENAME, instanceName);
        itset.addOption(USERNAME, username);
        itset.addOption(AUTHENTICATION_TOKEN_CLASS, token.getClass().getName());
        itset.addOption(AUTHENTICATION_TOKEN, SerializationUtil.serializeWritableBase64((Writable)token));
        return itset;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.parseOptions(options);
        this.initBatchWriter();
    }

    private void parseOptions(Map<String, String> options) {
        this.originalOptions = new HashMap<String, String>(options);
        if (options.containsKey(OPT_numEntriesToWritePerEntry)) {
            this.numEntriesToWritePerEntry = Integer.parseInt(options.get(OPT_numEntriesToWritePerEntry));
        }
        if (options.containsKey(OPT_sleepAfterFirstWrite)) {
            this.sleepAfterFirstWrite = Integer.parseInt(options.get(OPT_sleepAfterFirstWrite));
        }
        if (options.containsKey(OPT_batchWriterTimeout)) {
            this.batchWriterTimeout = Long.parseLong(options.get(OPT_batchWriterTimeout));
        }
        if (options.containsKey(OPT_batchWriterMaxMemory)) {
            this.batchWriterMaxMemory = Long.parseLong(options.get(OPT_batchWriterMaxMemory));
        }
        if (options.containsKey(OPT_clearCacheAfterFirstWrite)) {
            this.clearCacheAfterFirstWrite = Boolean.parseBoolean(options.get(OPT_clearCacheAfterFirstWrite));
        }
        if (options.containsKey(OPT_splitAfterFirstWrite)) {
            this.splitAfterFirstWrite = Boolean.parseBoolean(options.get(OPT_splitAfterFirstWrite));
        }
        this.instanceName = options.get(INSTANCENAME);
        this.tableName = options.get(TABLENAME);
        this.zookeeperHost = options.get(ZOOKEEPERHOST);
        this.zookeeperTimeout = Integer.parseInt(options.get(ZOOKEEPERTIMEOUT));
        this.username = options.get(USERNAME);
        String authClass = options.get(AUTHENTICATION_TOKEN_CLASS);
        String authString = options.get(AUTHENTICATION_TOKEN);
        this.auth = SerializationUtil.subclassNewInstance(authClass, AuthenticationToken.class);
        SerializationUtil.deserializeWritableBase64((Writable)this.auth, authString);
    }

    private void initBatchWriter() {
        ClientConfiguration cc = ClientConfiguration.loadDefault().withInstance(this.instanceName).withZkHosts(this.zookeeperHost).withZkTimeout(this.zookeeperTimeout);
        ZooKeeperInstance instance = new ZooKeeperInstance(cc);
        try {
            this.connector = instance.getConnector(this.username, this.auth);
        }
        catch (Exception e) {
            log.error("failed to connect to Accumulo instance " + this.instanceName, (Throwable)e);
            throw new RuntimeException(e);
        }
        BatchWriterConfig bwc = new BatchWriterConfig();
        bwc.setMaxMemory(this.batchWriterMaxMemory);
        bwc.setTimeout(this.batchWriterTimeout, TimeUnit.SECONDS);
        try {
            this.batchWriter = this.connector.createBatchWriter(this.tableName, bwc);
        }
        catch (TableNotFoundException e) {
            log.error(this.tableName + " does not exist in instance " + this.instanceName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void processNext() {
        assert (this.hasTop());
        Key k = this.getTopKey();
        Text row = k.getRow();
        Text cf = k.getColumnFamily();
        Text cq = k.getColumnQualifier();
        Value v = super.getTopValue();
        String failure = null;
        try {
            for (int i = 0; i < this.numEntriesToWritePerEntry; ++i) {
                Mutation m = new Mutation(row);
                m.put(cf, cq, v);
                this.batchWriter.addMutation(m);
                if (!this.firstWrite) continue;
                this.batchWriter.flush();
                if (this.clearCacheAfterFirstWrite) {
                    TabletLocator.clearLocators();
                }
                if (this.splitAfterFirstWrite) {
                    TreeSet<Text> splits = new TreeSet<Text>();
                    splits.add(new Text(row));
                    this.connector.tableOperations().addSplits(this.tableName, splits);
                }
                if (this.sleepAfterFirstWrite > 0) {
                    try {
                        Thread.sleep(this.sleepAfterFirstWrite);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.firstWrite = false;
            }
            this.batchWriter.flush();
        }
        catch (Exception e) {
            log.error("Problem while BatchWriting to target table " + this.tableName, (Throwable)e);
            failure = e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        this.topValue = failure == null ? SUCCESS_VALUE : new Value(failure.getBytes());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.batchWriter.close();
        }
        catch (MutationsRejectedException e) {
            log.error("Failed to close BatchWriter; some mutations may not be applied", (Throwable)e);
        }
    }

    public void next() throws IOException {
        super.next();
        if (this.hasTop()) {
            this.processNext();
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        super.seek(range, columnFamilies, inclusive);
        if (this.hasTop()) {
            this.processNext();
        }
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        try {
            BatchWriterIterator newInstance = (BatchWriterIterator)((Object)((Object)((Object)this)).getClass().newInstance());
            newInstance.init((SortedKeyValueIterator<Key, Value>)this.getSource().deepCopy(env), this.originalOptions, env);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

