/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import java.util.TreeSet;
import org.apache.accumulo.core.data.ByteSequence;

public class VisibilityCombiner {
    private TreeSet<String> visibilities = new TreeSet();

    void add(ByteSequence cv) {
        if (cv.length() == 0) {
            return;
        }
        int depth = 0;
        int offset = 0;
        block5: for (int i = 0; i < cv.length(); ++i) {
            switch (cv.byteAt(i)) {
                case 40: {
                    ++depth;
                    continue block5;
                }
                case 41: {
                    if (--depth >= 0) continue block5;
                    throw new IllegalArgumentException("Invalid vis " + cv);
                }
                case 124: {
                    if (depth != 0) continue block5;
                    this.insert(cv.subSequence(offset, i));
                    offset = i + 1;
                }
            }
        }
        this.insert(cv.subSequence(offset, cv.length()));
        if (depth != 0) {
            throw new IllegalArgumentException("Invalid vis " + cv);
        }
    }

    private void insert(ByteSequence cv) {
        for (int i = 0; i < cv.length(); ++i) {
        }
        String cvs = cv.toString();
        if (cvs.charAt(0) != '(') {
            cvs = "(" + cvs + ")";
        } else {
            int depth = 0;
            int depthZeroCloses = 0;
            block5: for (int i = 0; i < cv.length(); ++i) {
                switch (cv.byteAt(i)) {
                    case 40: {
                        ++depth;
                        continue block5;
                    }
                    case 41: {
                        if (--depth != 0) continue block5;
                        ++depthZeroCloses;
                    }
                }
            }
            if (depthZeroCloses > 1) {
                cvs = "(" + cvs + ")";
            }
        }
        this.visibilities.add(cvs);
    }

    byte[] get() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String cvs : this.visibilities) {
            sb.append(sep);
            sep = "|";
            sb.append(cvs);
        }
        return sb.toString().getBytes();
    }
}

