/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.EnumSet;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class DeleteIterCommand
extends Shell.Command {
    private Option allScopeOpt;
    private Option mincScopeOpt;
    private Option majcScopeOpt;
    private Option scanScopeOpt;
    private Option nameOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        boolean tables = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty();
        boolean namespaces = cl.hasOption(OptUtil.namespaceOpt().getOpt());
        String name = cl.getOptionValue(this.nameOpt.getOpt());
        if (namespaces) {
            if (!shellState.getConnector().namespaceOperations().listIterators(OptUtil.getNamespaceOpt(cl, shellState)).containsKey(name)) {
                Shell.log.warn((Object)"no iterators found that match your criteria");
                return 0;
            }
        } else if (tables) {
            if (!shellState.getConnector().tableOperations().listIterators(OptUtil.getTableOpt(cl, shellState)).containsKey(name)) {
                Shell.log.warn((Object)"no iterators found that match your criteria");
                return 0;
            }
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        EnumSet<IteratorUtil.IteratorScope> scopes = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.mincScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.minc);
        }
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.majcScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.majc);
        }
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.scanScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.scan);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        if (namespaces) {
            shellState.getConnector().namespaceOperations().removeIterator(OptUtil.getNamespaceOpt(cl, shellState), name, scopes);
        } else if (tables) {
            shellState.getConnector().tableOperations().removeIterator(OptUtil.getTableOpt(cl, shellState), name, scopes);
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        return 0;
    }

    @Override
    public String description() {
        return "deletes a table-specific or namespace-specific iterator";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.nameOpt = new Option("n", "name", true, "iterator to delete");
        this.nameOpt.setArgName("itername");
        this.nameOpt.setRequired(true);
        this.allScopeOpt = new Option("all", "all-scopes", false, "remove from all scopes");
        this.mincScopeOpt = new Option(IteratorUtil.IteratorScope.minc.name(), "minor-compaction", false, "remove from minor compaction scope");
        this.majcScopeOpt = new Option(IteratorUtil.IteratorScope.majc.name(), "major-compaction", false, "remove from major compaction scope");
        this.scanScopeOpt = new Option(IteratorUtil.IteratorScope.scan.name(), "scan-time", false, "remove from scan scope");
        OptionGroup grp = new OptionGroup();
        grp.addOption(OptUtil.tableOpt("table to delete the iterator from"));
        grp.addOption(OptUtil.namespaceOpt("namespace to delete the iterator from"));
        o.addOptionGroup(grp);
        o.addOption(this.nameOpt);
        o.addOption(this.allScopeOpt);
        o.addOption(this.mincScopeOpt);
        o.addOption(this.majcScopeOpt);
        o.addOption(this.scanScopeOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

