/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.util.Duration;

class ActiveCompactionIterator
implements Iterator<String> {
    private InstanceOperations instanceOps;
    private Iterator<String> tsIter;
    private Iterator<String> compactionIter;

    private static String maxDecimal(double count) {
        if (count < 9.995) {
            return String.format("%.2f", count);
        }
        if (count < 99.95) {
            return String.format("%.1f", count);
        }
        return String.format("%.0f", count);
    }

    private static String shortenCount(long count) {
        if (count < 1000L) {
            return count + "";
        }
        if (count < 1000000L) {
            return ActiveCompactionIterator.maxDecimal((double)count / 1000.0) + "K";
        }
        if (count < 1000000000L) {
            return ActiveCompactionIterator.maxDecimal((double)count / 1000000.0) + "M";
        }
        return ActiveCompactionIterator.maxDecimal((double)count / 1.0E9) + "B";
    }

    private void readNext() {
        ArrayList<String> compactions = new ArrayList<String>();
        while (this.tsIter.hasNext()) {
            String tserver = this.tsIter.next();
            try {
                ArrayList acl = this.instanceOps.getActiveCompactions(tserver);
                acl = new ArrayList(acl);
                Collections.sort(acl, new Comparator<ActiveCompaction>(){

                    @Override
                    public int compare(ActiveCompaction o1, ActiveCompaction o2) {
                        return (int)(o2.getAge() - o1.getAge());
                    }
                });
                for (ActiveCompaction ac : acl) {
                    String output = ac.getOutputFile();
                    int index = output.indexOf("tables");
                    if (index > 0) {
                        output = output.substring(index + 6);
                    }
                    ac.getIterators();
                    ArrayList<String> iterList = new ArrayList<String>();
                    HashMap<String, Map> iterOpts = new HashMap<String, Map>();
                    for (IteratorSetting is : ac.getIterators()) {
                        iterList.add(is.getName() + "=" + is.getPriority() + "," + is.getIteratorClass());
                        iterOpts.put(is.getName(), is.getOptions());
                    }
                    compactions.add(String.format("%21s | %9s | %5s | %6s | %5s | %5s | %15s | %-40s | %5s | %35s | %9s | %s", tserver, Duration.format((long)ac.getAge(), (String)"", (String)"-"), ac.getType(), ac.getReason(), ActiveCompactionIterator.shortenCount(ac.getEntriesRead()), ActiveCompactionIterator.shortenCount(ac.getEntriesWritten()), ac.getTable(), ac.getTablet(), ac.getInputFiles().size(), output, iterList, iterOpts));
                }
            }
            catch (Exception e) {
                compactions.add(tserver + " ERROR " + e.getMessage());
            }
            if (compactions.size() <= 0) continue;
            break;
        }
        this.compactionIter = compactions.iterator();
    }

    ActiveCompactionIterator(List<String> tservers, InstanceOperations instanceOps) {
        this.instanceOps = instanceOps;
        this.tsIter = tservers.iterator();
        String header = String.format(" %-21s| %-9s | %-5s | %-6s | %-5s | %-5s | %-15s | %-40s | %-5s | %-35s | %-9s | %s", "TABLET SERVER", "AGE", "TYPE", "REASON", "READ", "WROTE", "TABLE", "TABLET", "INPUT", "OUTPUT", "ITERATORS", "ITERATOR OPTIONS");
        this.compactionIter = Collections.singletonList(header).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.compactionIter.hasNext();
    }

    @Override
    public String next() {
        String next = this.compactionIter.next();
        if (!this.compactionIter.hasNext()) {
            this.readNext();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

